/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.type;

import com.blazebit.persistence.view.impl.type.AbstractInstantTypeConverter;
import java.lang.reflect.Type;
import java.sql.Timestamp;
import java.util.Date;

public abstract class DateToInstantTypeConverter<T extends Date>
extends AbstractInstantTypeConverter<T> {
    public static final DateToInstantTypeConverter<Date> JAVA_UTIL_DATE_CONVERTER = new DateToInstantTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Date.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Date(this.toEpochMillis(object));
        }
    };
    public static final DateToInstantTypeConverter<Date> JAVA_SQL_TIMESTAMP_CONVERTER = new DateToInstantTypeConverter<Date>(){

        public Class<?> getUnderlyingType(Class<?> owningClass, Type declaredType) {
            return Timestamp.class;
        }

        public Date convertToUnderlyingType(Object object) {
            if (object == null) {
                return null;
            }
            return new Timestamp(this.toEpochMillis(object));
        }
    };

    public Object convertToViewType(Date object) {
        if (object == null) {
            return null;
        }
        return this.ofEpochMilli(object.getTime());
    }
}

