/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.tx;

import com.blazebit.persistence.view.impl.tx.JtaResources;
import com.blazebit.persistence.view.impl.tx.SynchronizationRegistry;
import com.blazebit.persistence.view.spi.TransactionAccess;
import com.blazebit.persistence.view.spi.TransactionAccessFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;

public class TransactionHelper {
    private static final Logger LOG = Logger.getLogger(TransactionHelper.class.getName());
    private static volatile TransactionAccessFactory factory;

    private TransactionHelper() {
    }

    public static TransactionAccess getTransactionAccess(EntityManager em) {
        SynchronizationRegistry registry = SynchronizationRegistry.getRegistry();
        if (registry == null) {
            TransactionAccess transactionAccess = TransactionHelper.getTransactionAccessInternal(em);
            if (!transactionAccess.isActive()) {
                return transactionAccess;
            }
            registry = new SynchronizationRegistry(transactionAccess);
        }
        return registry;
    }

    private static TransactionAccess getTransactionAccessInternal(EntityManager em) {
        JtaResources jtaResources;
        TransactionAccessFactory factory = TransactionHelper.factory;
        if (factory != null) {
            return factory.createTransactionAccess(em);
        }
        InitialContext context = null;
        try {
            context = new InitialContext();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
        if (context != null && (jtaResources = JtaResources.getInstance()) != null) {
            TransactionHelper.factory = jtaResources;
            return jtaResources.createTransactionAccess(em);
        }
        ArrayList<TransactionAccessFactory> transactionAccessFactories = new ArrayList<TransactionAccessFactory>();
        for (TransactionAccessFactory transactionAccessFactory : ServiceLoader.load(TransactionAccessFactory.class)) {
            transactionAccessFactories.add(transactionAccessFactory);
        }
        Collections.sort(transactionAccessFactories, new Comparator<TransactionAccessFactory>(){

            @Override
            public int compare(TransactionAccessFactory o1, TransactionAccessFactory o2) {
                return Integer.compare(o1.getPriority(), o2.getPriority());
            }
        });
        for (TransactionAccessFactory transactionAccessFactory : transactionAccessFactories) {
            try {
                TransactionAccess transactionAccess = transactionAccessFactory.createTransactionAccess(em);
                if (transactionAccess == null) continue;
                TransactionHelper.factory = transactionAccessFactory;
                return transactionAccess;
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "Error during creation of transaction access!", ex);
            }
        }
        throw new IllegalArgumentException("Unsupported jpa provider!");
    }
}

