/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.proxy;

import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.proxy.AbstractReflectionInstantiator;
import com.blazebit.persistence.view.impl.proxy.ObjectInstantiator;
import com.blazebit.persistence.view.impl.proxy.ProxyFactory;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collections;

public class ConvertReflectionInstantiator<T>
implements ObjectInstantiator<T> {
    private static final boolean TUPLE_STYLE = true;
    private final Constructor<T> constructor;
    private final Object[] defaultObject;
    private final AbstractReflectionInstantiator.TypeConverterEntry[] typeConverterEntries;

    public ConvertReflectionInstantiator(ProxyFactory proxyFactory, ManagedViewType<T> viewType, Class<?>[] parameterTypes, int constructorParameterCount, EntityViewManager entityViewManager) {
        Object[] defaultObject;
        Constructor javaConstructor;
        Class proxyClazz = proxyFactory.getProxy(entityViewManager, (ManagedViewTypeImplementor)viewType);
        try {
            Class[] types = new Class[constructorParameterCount + 3];
            types[0] = proxyClazz;
            types[1] = Integer.TYPE;
            types[2] = Object[].class;
            System.arraycopy(parameterTypes, parameterTypes.length - constructorParameterCount, types, 3, constructorParameterCount);
            javaConstructor = proxyClazz.getDeclaredConstructor(types);
            defaultObject = AbstractReflectionInstantiator.createDefaultObject(3, parameterTypes, constructorParameterCount);
            defaultObject[1] = 0;
        }
        catch (NoSuchMethodException | SecurityException ex) {
            throw new IllegalArgumentException("Couldn't find expected constructor of the proxy class: " + proxyClazz.getName(), ex);
        }
        this.constructor = javaConstructor;
        this.defaultObject = defaultObject;
        this.typeConverterEntries = AbstractReflectionInstantiator.withPrimitiveConverters(Collections.emptyList(), parameterTypes);
    }

    @Override
    public T newInstance(Object[] tuple) {
        try {
            for (int i = 0; i < this.typeConverterEntries.length; ++i) {
                AbstractReflectionInstantiator.TypeConverterEntry entry = this.typeConverterEntries[i];
                tuple[entry.index] = entry.typeConverter.convertToViewType(tuple[entry.index]);
            }
            Object[] array = Arrays.copyOf(this.defaultObject, this.defaultObject.length);
            array[2] = tuple;
            T t = this.constructor.newInstance(array);
            return t;
        }
        catch (Exception ex) {
            Object[] types = new String[tuple.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = tuple[i] == null ? null : tuple[i].getClass().getName();
            }
            throw new RuntimeException("Could not invoke the proxy constructor '" + this.constructor + "' with the given tuple: " + Arrays.toString(tuple) + " with the types: " + Arrays.toString(types), ex);
        }
    }
}

