/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import java.util.Arrays;

public class TupleId {
    private final Object[] id;

    public TupleId(int[] idPositions, Object[] tuple) {
        this.id = new Object[idPositions.length];
        for (int i = 0; i < idPositions.length; ++i) {
            int idPosition = idPositions[i];
            this.id[i] = idPosition < 0 ? Integer.valueOf(idPosition) : tuple[idPosition];
        }
    }

    public boolean isEmpty() {
        for (int i = 0; i < this.id.length; ++i) {
            if (this.id[i] == null) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = 7;
        int result = 1;
        for (Object element : this.id) {
            int elementHash = 0;
            if (element instanceof Object[]) {
                elementHash = Arrays.deepHashCode((Object[])element);
            } else if (element instanceof byte[]) {
                elementHash = Arrays.hashCode((byte[])element);
            } else if (element instanceof short[]) {
                elementHash = Arrays.hashCode((short[])element);
            } else if (element instanceof int[]) {
                elementHash = Arrays.hashCode((int[])element);
            } else if (element instanceof long[]) {
                elementHash = Arrays.hashCode((long[])element);
            } else if (element instanceof char[]) {
                elementHash = Arrays.hashCode((char[])element);
            } else if (element instanceof float[]) {
                elementHash = Arrays.hashCode((float[])element);
            } else if (element instanceof double[]) {
                elementHash = Arrays.hashCode((double[])element);
            } else if (element instanceof boolean[]) {
                elementHash = Arrays.hashCode((boolean[])element);
            } else if (element instanceof RecordingCollection) {
                elementHash = System.identityHashCode(element);
            } else if (element instanceof RecordingMap) {
                elementHash = System.identityHashCode(element);
            } else if (element != null) {
                elementHash = element.hashCode();
            }
            result = 31 * result + elementHash;
        }
        hash = 53 * hash + result;
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TupleId other = (TupleId)obj;
        Object[] a1 = this.id;
        Object[] a2 = other.id;
        if (a1 == a2) {
            return true;
        }
        int length = a1.length;
        if (a2.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = a1[i];
            Object e2 = a2[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = e1 instanceof Object[] && e2 instanceof Object[] ? Arrays.deepEquals((Object[])e1, (Object[])e2) : (e1 instanceof byte[] && e2 instanceof byte[] ? Arrays.equals((byte[])e1, (byte[])e2) : (e1 instanceof short[] && e2 instanceof short[] ? Arrays.equals((short[])e1, (short[])e2) : (e1 instanceof int[] && e2 instanceof int[] ? Arrays.equals((int[])e1, (int[])e2) : (e1 instanceof long[] && e2 instanceof long[] ? Arrays.equals((long[])e1, (long[])e2) : (e1 instanceof char[] && e2 instanceof char[] ? Arrays.equals((char[])e1, (char[])e2) : (e1 instanceof float[] && e2 instanceof float[] ? Arrays.equals((float[])e1, (float[])e2) : (e1 instanceof double[] && e2 instanceof double[] ? Arrays.equals((double[])e1, (double[])e2) : (e1 instanceof boolean[] && e2 instanceof boolean[] ? Arrays.equals((boolean[])e1, (boolean[])e2) : (e1 instanceof RecordingCollection && e2 instanceof RecordingCollection ? e1 == e2 : (e1 instanceof RecordingMap && e2 instanceof RecordingMap ? e1 == e2 : e1.equals(e2)))))))))));
            if (eq) continue;
            return false;
        }
        return true;
    }
}

