/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.objectbuilder;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;

public class ConstrainedTupleList
extends AbstractList<Object[]> {
    private final int classMappingIndex;
    private final int[] subtypeIndexes;
    private final List<Object[]> tupleList;

    public ConstrainedTupleList(int classMappingIndex, int[] subtypeIndexes, List<Object[]> tupleList) {
        this.classMappingIndex = classMappingIndex;
        this.subtypeIndexes = subtypeIndexes;
        this.tupleList = tupleList;
    }

    @Override
    public Object[] get(int index) {
        int count = 0;
        for (int i = 0; i < this.tupleList.size(); ++i) {
            if (Arrays.binarySearch(this.subtypeIndexes, ((Number)this.tupleList.get(i)[this.classMappingIndex]).intValue()) < 0) continue;
            if (count == index) {
                return this.tupleList.get(i);
            }
            ++count;
        }
        throw new NoSuchElementException();
    }

    @Override
    public Object[] set(int index, Object[] element) {
        int count = 0;
        for (int i = 0; i < this.tupleList.size(); ++i) {
            if (Arrays.binarySearch(this.subtypeIndexes, ((Number)this.tupleList.get(i)[this.classMappingIndex]).intValue()) < 0) continue;
            if (count == index) {
                return this.tupleList.set(i, element);
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Object[] remove(int index) {
        int count = 0;
        for (int i = 0; i < this.tupleList.size(); ++i) {
            if (Arrays.binarySearch(this.subtypeIndexes, ((Number)this.tupleList.get(i)[this.classMappingIndex]).intValue()) < 0) continue;
            if (count == index) {
                return this.tupleList.remove(i);
            }
            ++count;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int size() {
        int count = 0;
        for (int i = 0; i < this.tupleList.size(); ++i) {
            if (Arrays.binarySearch(this.subtypeIndexes, ((Number)this.tupleList.get(i)[this.classMappingIndex]).intValue()) < 0) continue;
            ++count;
        }
        return count;
    }
}

