/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.PathTargetResolvingExpressionVisitor;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.view.CollectionMapping;
import com.blazebit.persistence.view.impl.metamodel.CollectionMappingLiteral;
import com.blazebit.persistence.view.metamodel.MappingConstructor;
import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.persistence.OrderColumn;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.ListAttribute;
import javax.persistence.metamodel.Type;

public final class MetamodelUtils {
    private MetamodelUtils() {
    }

    public static CollectionMapping getCollectionMapping(Constructor<?> constructor, int index) {
        return MetamodelUtils.getCollectionMapping(MetamodelUtils.findAnnotation(constructor, index, CollectionMapping.class));
    }

    public static CollectionMapping getCollectionMapping(Method method) {
        return MetamodelUtils.getCollectionMapping((CollectionMapping)AnnotationUtils.findAnnotation((Method)method, CollectionMapping.class));
    }

    public static boolean isSorted(MappingConstructor<?> mappingConstructor, int index) {
        return MetamodelUtils.isSorted(mappingConstructor.getJavaConstructor(), index);
    }

    public static boolean isSorted(Constructor<?> constructor, int index) {
        Class<?> concreteClass = constructor.getDeclaringClass();
        java.lang.reflect.Type type = constructor.getGenericParameterTypes()[index];
        if (type instanceof Class) {
            return MetamodelUtils.isSorted((Class)type);
        }
        if (type instanceof TypeVariable) {
            return MetamodelUtils.isSorted(ReflectionUtils.resolveTypeVariable(concreteClass, (TypeVariable)((TypeVariable)type)));
        }
        return MetamodelUtils.isSorted(constructor.getParameterTypes()[index]);
    }

    public static boolean isSorted(Class<?> clazz, Method method) {
        return MetamodelUtils.isSorted(ReflectionUtils.getResolvedMethodReturnType(clazz, (Method)method));
    }

    public static boolean isSorted(Class<?> clazz) {
        if (SortedSet.class.isAssignableFrom(clazz)) {
            return true;
        }
        return SortedMap.class.isAssignableFrom(clazz);
    }

    public static <T> Class<Comparator<T>> getComparatorClass(CollectionMapping mapping) {
        if (Comparator.class == mapping.comparator()) {
            return null;
        }
        return mapping.comparator();
    }

    public static <T> Comparator<T> getComparator(Class<Comparator<T>> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public static boolean isIndexedList(EntityMetamodel metamodel, ExpressionFactory expressionFactory, Class<?> entityClass, String mapping) {
        if (mapping == null || mapping.isEmpty()) {
            return false;
        }
        return MetamodelUtils.isIndexedList(metamodel, entityClass, expressionFactory.createSimpleExpression(mapping, false, false, false), mapping);
    }

    public static boolean isIndexedList(EntityMetamodel metamodel, Class<?> entityClass, Expression expression, String mapping) {
        PathTargetResolvingExpressionVisitor visitor = new PathTargetResolvingExpressionVisitor(metamodel, (Type)metamodel.managedType(entityClass), null);
        expression.accept((Expression.Visitor)visitor);
        Map possibleTargets = visitor.getPossibleTargets();
        Iterator iter = possibleTargets.entrySet().iterator();
        Map.Entry targetEntry = iter.next();
        boolean indexed = MetamodelUtils.isIndexedList((Attribute)targetEntry.getKey());
        while (iter.hasNext()) {
            targetEntry = iter.next();
            if (indexed == MetamodelUtils.isIndexedList((Attribute)targetEntry.getKey())) continue;
            throw new IllegalArgumentException("Inconclusive result on checking whether the expression [" + mapping + "] resolves to an indexed list on class [" + entityClass.getName() + "].");
        }
        return indexed;
    }

    private static boolean isIndexedList(Attribute<?, ?> targetAttribute) {
        if (!(targetAttribute instanceof ListAttribute)) {
            return false;
        }
        Member member = targetAttribute.getJavaMember();
        if (member instanceof Field) {
            return ((Field)member).getAnnotation(OrderColumn.class) != null;
        }
        return AnnotationUtils.findAnnotation((Method)((Method)member), OrderColumn.class) != null;
    }

    public static <A extends Annotation> A findAnnotation(Constructor<?> constructor, int index, Class<A> annotationClass) {
        return MetamodelUtils.findAnnotation(constructor.getParameterAnnotations()[index], annotationClass);
    }

    private static <A extends Annotation> A findAnnotation(Annotation[] annotations, Class<A> annotationClass) {
        for (int i = 0; i < annotations.length; ++i) {
            if (!annotationClass.isAssignableFrom(annotations[i].annotationType())) continue;
            return (A)annotations[i];
        }
        return null;
    }

    public static CollectionMapping getCollectionMapping(CollectionMapping mapping) {
        if (mapping != null) {
            return mapping;
        }
        return new CollectionMappingLiteral(Comparator.class, false, false, false);
    }
}

