/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.PostCommitListener;
import com.blazebit.persistence.view.PostPersistEntityListener;
import com.blazebit.persistence.view.PostPersistListener;
import com.blazebit.persistence.view.PostRemoveListener;
import com.blazebit.persistence.view.PostRollbackListener;
import com.blazebit.persistence.view.PostUpdateListener;
import com.blazebit.persistence.view.PrePersistEntityListener;
import com.blazebit.persistence.view.PrePersistListener;
import com.blazebit.persistence.view.PreRemoveListener;
import com.blazebit.persistence.view.PreUpdateListener;
import com.blazebit.persistence.view.impl.EntityViewListenerClassKey;
import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import com.blazebit.persistence.view.impl.SimpleEntityViewListenerFactory;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class MetamodelBootContextImpl
implements MetamodelBootContext {
    private static final Class[] LISTENER_CLASSES = new Class[]{PostCommitListener.class, PostPersistListener.class, PostPersistEntityListener.class, PostRemoveListener.class, PostRollbackListener.class, PostUpdateListener.class, PrePersistListener.class, PrePersistEntityListener.class, PreRemoveListener.class, PreUpdateListener.class};
    private final Map<Class<?>, ViewMapping> viewMappings = new HashMap();
    private final Map<EntityViewListenerClassKey, EntityViewListenerFactory<?>> viewListeners = new HashMap();
    private final Set<String> errors = new LinkedHashSet<String>();

    @Override
    public ViewMapping getViewMapping(Class<?> clazz) {
        return this.viewMappings.get(clazz);
    }

    @Override
    public void addViewMapping(Class<?> clazz, ViewMapping viewMapping) {
        this.viewMappings.put(clazz, viewMapping);
    }

    @Override
    public void addEntityViewListener(Class<?> entityViewClass, Class<?> entityViewListenerClass) {
        for (EntityViewListenerFactory<?> viewListenerFactory : this.createViewListenerFactories(entityViewListenerClass)) {
            this.viewListeners.put(new EntityViewListenerClassKey(entityViewClass, null, viewListenerFactory.getListenerKind(), entityViewListenerClass), viewListenerFactory);
        }
    }

    @Override
    public void addEntityViewListener(Class<?> entityViewClass, Class<?> entityClass, Class<?> entityViewListenerClass) {
        for (EntityViewListenerFactory<?> viewListenerFactory : this.createViewListenerFactories(entityViewListenerClass)) {
            this.viewListeners.put(new EntityViewListenerClassKey(entityViewClass, entityClass, viewListenerFactory.getListenerKind(), entityViewListenerClass), viewListenerFactory);
        }
    }

    @Override
    public void addEntityViewListener(Class<?> entityViewClass, Class<?> entityClass, EntityViewListenerFactory<?> entityViewListenerFactory) {
        this.viewListeners.put(new EntityViewListenerClassKey(entityViewClass, entityClass, entityViewListenerFactory.getListenerKind(), entityViewListenerFactory.getListenerClass()), entityViewListenerFactory);
    }

    @Override
    public EntityViewListenerFactory<?>[] createViewListenerFactories(Class<?> entityViewListenerClass) {
        ArrayList factories = new ArrayList();
        for (Class listenerClass : LISTENER_CLASSES) {
            if (!listenerClass.isAssignableFrom(entityViewListenerClass)) continue;
            factories.add(new SimpleEntityViewListenerFactory(entityViewListenerClass, listenerClass));
        }
        return factories.toArray(new EntityViewListenerFactory[0]);
    }

    @Override
    public Map<Class<?>, ViewMapping> getViewMappingMap() {
        return this.viewMappings;
    }

    @Override
    public Collection<ViewMapping> getViewMappings() {
        return this.viewMappings.values();
    }

    @Override
    public Set<Class<?>> getViewClasses() {
        return this.viewMappings.keySet();
    }

    @Override
    public Map<EntityViewListenerClassKey, EntityViewListenerFactory<?>> getViewListeners() {
        return this.viewListeners;
    }

    @Override
    public Set<Class<?>> getViewListenerClasses() {
        HashSet viewListenerClasses = new HashSet(this.viewListeners.entrySet().size());
        for (EntityViewListenerClassKey entityViewListenerClassKey : this.viewListeners.keySet()) {
            viewListenerClasses.add(entityViewListenerClassKey.getEntityViewListenerClass());
        }
        return viewListenerClasses;
    }

    @Override
    public Set<Class<?>> getViewListenerClasses(Class<?> entityViewClass) {
        HashSet viewListenerClasses = new HashSet(this.viewListeners.entrySet().size());
        for (EntityViewListenerClassKey entityViewListenerClassKey : this.viewListeners.keySet()) {
            if (entityViewListenerClassKey.getEntityViewClass() != entityViewClass) continue;
            viewListenerClasses.add(entityViewListenerClassKey.getEntityViewListenerClass());
        }
        return viewListenerClasses;
    }

    @Override
    public Set<Class<?>> getViewListenerClasses(Class<?> entityViewClass, Class<?> entityClass) {
        HashSet viewListenerClasses = new HashSet(this.viewListeners.entrySet().size());
        for (EntityViewListenerClassKey entityViewListenerClassKey : this.viewListeners.keySet()) {
            if (entityViewListenerClassKey.getEntityViewClass() != entityViewClass || entityViewListenerClassKey.getEntityClass() != entityClass) continue;
            viewListenerClasses.add(entityViewListenerClassKey.getEntityViewListenerClass());
        }
        return viewListenerClasses;
    }

    @Override
    public void addError(String error) {
        this.errors.add(error);
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public Set<String> getErrors() {
        return this.errors;
    }
}

