/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

public class EmbeddableOwner {
    private final Class<?> entityClass;
    private final String embeddableMapping;

    public EmbeddableOwner(Class<?> entityClass, String embeddableMapping) {
        this.entityClass = entityClass;
        this.embeddableMapping = embeddableMapping;
    }

    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    public String getEmbeddableMapping() {
        return this.embeddableMapping;
    }

    public EmbeddableOwner withSubMapping(String mapping) {
        return new EmbeddableOwner(this.entityClass, this.embeddableMapping + "." + mapping);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EmbeddableOwner)) {
            return false;
        }
        EmbeddableOwner that = (EmbeddableOwner)o;
        if (!this.getEntityClass().equals(that.getEntityClass())) {
            return false;
        }
        return this.getEmbeddableMapping().equals(that.getEmbeddableMapping());
    }

    public int hashCode() {
        int result = this.getEntityClass().hashCode();
        result = 31 * result + this.getEmbeddableMapping().hashCode();
        return result;
    }
}

