/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBuildingContext;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.spi.EntityViewConstructorMapping;
import com.blazebit.persistence.view.spi.EntityViewMapping;
import com.blazebit.persistence.view.spi.EntityViewParameterMapping;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.List;
import java.util.Set;

public class ConstructorMapping
implements EntityViewConstructorMapping {
    private final ViewMapping viewMapping;
    private final String constructorName;
    private final Constructor<?> constructor;
    private final List<ParameterAttributeMapping> parameterAttributes;

    public ConstructorMapping(ViewMapping viewMapping, String constructorName, Constructor<?> constructor, List<ParameterAttributeMapping> parameters, MetamodelBootContext context) {
        this.viewMapping = viewMapping;
        this.constructorName = constructorName;
        this.constructor = constructor;
        if (constructorName == null || constructorName.isEmpty()) {
            context.addError("The constructor '" + constructor.toString() + "' of the class '" + constructor.getDeclaringClass().getName() + "' must have a non-empty name!");
        }
        if (constructor.getExceptionTypes().length != 0) {
            context.addError("The constructor '" + constructor.toString() + "' of the class '" + constructor.getDeclaringClass().getName() + "' may not throw an exception!");
        }
        this.parameterAttributes = Collections.unmodifiableList(parameters);
    }

    public String getName() {
        return this.constructorName;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public EntityViewMapping getDeclaringView() {
        return this.viewMapping;
    }

    public List<EntityViewParameterMapping> getParameters() {
        return Collections.unmodifiableList(this.parameterAttributes);
    }

    public List<ParameterAttributeMapping> getParameterMappings() {
        return this.parameterAttributes;
    }

    public void initializeViewMappings(MetamodelBuildingContext context) {
        for (ParameterAttributeMapping attributeMapping : this.parameterAttributes) {
            attributeMapping.initializeViewMappings(context);
        }
    }

    public boolean validateDependencies(MetamodelBuildingContext context, Set<Class<?>> dependencies, boolean reportError) {
        boolean error = false;
        for (ParameterAttributeMapping attributeMapping : this.parameterAttributes) {
            if (!attributeMapping.validateDependencies(context, dependencies, reportError)) continue;
            error = true;
            if (reportError) continue;
            return true;
        }
        return error;
    }
}

