/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.metamodel;

import com.blazebit.annotation.AnnotationUtils;
import com.blazebit.persistence.view.BatchFetch;
import com.blazebit.persistence.view.CTEProvider;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CreatableEntityView;
import com.blazebit.persistence.view.EntityView;
import com.blazebit.persistence.view.EntityViewInheritance;
import com.blazebit.persistence.view.EntityViewInheritanceMapping;
import com.blazebit.persistence.view.EntityViewListener;
import com.blazebit.persistence.view.EntityViewListeners;
import com.blazebit.persistence.view.EntityViewManager;
import com.blazebit.persistence.view.EntityViewRoot;
import com.blazebit.persistence.view.EntityViewRoots;
import com.blazebit.persistence.view.IdMapping;
import com.blazebit.persistence.view.LockMode;
import com.blazebit.persistence.view.LockOwner;
import com.blazebit.persistence.view.Mapping;
import com.blazebit.persistence.view.MappingCorrelated;
import com.blazebit.persistence.view.MappingCorrelatedSimple;
import com.blazebit.persistence.view.MappingParameter;
import com.blazebit.persistence.view.MappingSubquery;
import com.blazebit.persistence.view.PostCommit;
import com.blazebit.persistence.view.PostConvert;
import com.blazebit.persistence.view.PostCreate;
import com.blazebit.persistence.view.PostLoad;
import com.blazebit.persistence.view.PostPersist;
import com.blazebit.persistence.view.PostRemove;
import com.blazebit.persistence.view.PostRollback;
import com.blazebit.persistence.view.PostUpdate;
import com.blazebit.persistence.view.PrePersist;
import com.blazebit.persistence.view.PreRemove;
import com.blazebit.persistence.view.PreUpdate;
import com.blazebit.persistence.view.Self;
import com.blazebit.persistence.view.UpdatableEntityView;
import com.blazebit.persistence.view.ViewConstructor;
import com.blazebit.persistence.view.ViewFilter;
import com.blazebit.persistence.view.ViewFilterProvider;
import com.blazebit.persistence.view.ViewFilters;
import com.blazebit.persistence.view.With;
import com.blazebit.persistence.view.impl.EntityViewListenerFactory;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.AnnotationMethodAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.AnnotationParameterAttributeMappingReader;
import com.blazebit.persistence.view.impl.metamodel.ConstructorMapping;
import com.blazebit.persistence.view.impl.metamodel.EntityViewRootMappingImpl;
import com.blazebit.persistence.view.impl.metamodel.IdMappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MapAnnotatedElement;
import com.blazebit.persistence.view.impl.metamodel.MappingLiteral;
import com.blazebit.persistence.view.impl.metamodel.MappingReader;
import com.blazebit.persistence.view.impl.metamodel.MetamodelBootContext;
import com.blazebit.persistence.view.impl.metamodel.MethodAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ParameterAttributeMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMapping;
import com.blazebit.persistence.view.impl.metamodel.ViewMappingImpl;
import com.blazebit.persistence.view.impl.metamodel.analysis.AssignmentAnalyzer;
import com.blazebit.persistence.view.impl.metamodel.analysis.Frame;
import com.blazebit.persistence.view.spi.EntityViewRootMapping;
import com.blazebit.reflection.ReflectionUtils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtPrimitiveType;
import javassist.LoaderClassPath;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.Descriptor;
import javassist.bytecode.analysis.Type;

public class AnnotationMappingReader
implements MappingReader {
    private static final Map<Class<?>, LifecycleEntry> LIFECYCLE_ENTRY_MAP;
    private static final LifecycleEntry[] LIFECYCLE_ENTRIES;
    private final MetamodelBootContext context;
    private final AnnotationMethodAttributeMappingReader methodAttributeMappingReader;
    private final AnnotationParameterAttributeMappingReader parameterAttributeMappingReader;

    public AnnotationMappingReader(MetamodelBootContext context) {
        this.context = context;
        this.methodAttributeMappingReader = new AnnotationMethodAttributeMappingReader(context);
        this.parameterAttributeMappingReader = new AnnotationParameterAttributeMappingReader(context);
    }

    @Override
    public MetamodelBootContext getContext() {
        return this.context;
    }

    @Override
    public void readViewListenerMapping(Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        EntityViewListener entityViewListener = (EntityViewListener)AnnotationUtils.findAnnotation(entityViewListenerClass, EntityViewListener.class);
        if (entityViewListener == null) {
            EntityViewListeners entityViewListeners = (EntityViewListeners)AnnotationUtils.findAnnotation(entityViewListenerClass, EntityViewListeners.class);
            if (entityViewListeners == null) {
                this.context.addEntityViewListener(this.resolveEntityViewClass(null, entityViewListenerClass, factory), this.resolveEntityClass(null, entityViewListenerClass, factory), factory);
            } else {
                for (EntityViewListener viewListener : entityViewListeners.value()) {
                    this.context.addEntityViewListener(this.resolveEntityViewClass(viewListener, entityViewListenerClass, factory), this.resolveEntityClass(viewListener, entityViewListenerClass, factory), factory);
                }
            }
        } else {
            this.context.addEntityViewListener(this.resolveEntityViewClass(entityViewListener, entityViewListenerClass, factory), this.resolveEntityClass(entityViewListener, entityViewListenerClass, factory), factory);
        }
    }

    private Class<?> resolveEntityViewClass(EntityViewListener annotation, Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        Class<?> entityViewClass = this.resolveEntityViewClassFromTypeParameters(entityViewListenerClass, factory);
        if (annotation == null || annotation.entityView() == Object.class) {
            return entityViewClass;
        }
        if (!entityViewClass.isAssignableFrom(annotation.entityView())) {
            this.context.addError("The entity view type parameter for listener class " + entityViewListenerClass + " must be at least as general as the value of the entityView property in the EntityViewListener annotation  " + annotation.entityView());
        }
        return annotation.entityView();
    }

    private Class<?> resolveEntityClass(EntityViewListener annotation, Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        Class<?> entityClass = this.resolveEntityClassFromTypeParameters(entityViewListenerClass, factory);
        if (annotation == null || annotation.entity() == Object.class) {
            return entityClass;
        }
        if (!entityClass.isAssignableFrom(annotation.entity())) {
            this.context.addError("The entity type parameter for listener class " + entityViewListenerClass + " must be at least as general as the value of the entity property in the EntityViewListener annotation  " + annotation.entity());
        }
        return annotation.entity();
    }

    private Class<?> resolveEntityViewClassFromTypeParameters(Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        TypeVariable<Class<?>>[] typeParameters = factory.getListenerKind().getTypeParameters();
        if (typeParameters.length > 0) {
            return ReflectionUtils.resolveTypeVariable(entityViewListenerClass, typeParameters[0]);
        }
        return Object.class;
    }

    private Class<?> resolveEntityClassFromTypeParameters(Class<?> entityViewListenerClass, EntityViewListenerFactory<?> factory) {
        TypeVariable<Class<?>>[] typeParameters = factory.getListenerKind().getTypeParameters();
        if (typeParameters.length > 1) {
            return ReflectionUtils.resolveTypeVariable(entityViewListenerClass, typeParameters[1]);
        }
        return Object.class;
    }

    @Override
    public ViewMapping readViewMapping(Class<?> entityViewClass) {
        CreatableEntityView creatableEntityView;
        ViewMapping existingMapping = this.context.getViewMapping(entityViewClass);
        if (existingMapping != null) {
            return existingMapping;
        }
        EntityView entityView = (EntityView)AnnotationUtils.findAnnotation(entityViewClass, EntityView.class);
        if (entityView == null) {
            return null;
        }
        Class entityClass = entityView.value();
        ViewMappingImpl viewMapping = new ViewMappingImpl(entityViewClass, entityClass, this.context);
        this.context.addViewMapping(entityViewClass, viewMapping);
        boolean isAbstract = entityViewClass.isInterface() || Modifier.isAbstract(entityViewClass.getModifiers());
        BatchFetch batchFetch = (BatchFetch)AnnotationUtils.findAnnotation(entityViewClass, BatchFetch.class);
        if (batchFetch != null) {
            viewMapping.setDefaultBatchSize(batchFetch.size());
        }
        LinkedHashSet<Class<? extends CTEProvider>> cteProviders = new LinkedHashSet<Class<? extends CTEProvider>>();
        HashMap<String, Class<? extends ViewFilterProvider>> viewFilterProviders = new HashMap<String, Class<? extends ViewFilterProvider>>();
        LinkedHashMap<String, EntityViewRootMapping> viewRootMappings = new LinkedHashMap<String, EntityViewRootMapping>();
        for (Annotation a : AnnotationUtils.getAllAnnotations(entityViewClass)) {
            if (a instanceof With) {
                cteProviders.addAll(Arrays.asList(((With)a).value()));
                continue;
            }
            if (a instanceof ViewFilter) {
                ViewFilter viewFilter = (ViewFilter)a;
                this.addFilterMapping(viewFilter.name(), viewFilter.value(), viewFilterProviders, entityViewClass, this.context);
                continue;
            }
            if (a instanceof ViewFilters) {
                ViewFilters viewFilters = (ViewFilters)a;
                for (ViewFilter viewFilter : viewFilters.value()) {
                    this.addFilterMapping(viewFilter.name(), viewFilter.value(), viewFilterProviders, entityViewClass, this.context);
                }
                continue;
            }
            if (a instanceof EntityViewRoot) {
                EntityViewRoot entityViewRoot = (EntityViewRoot)a;
                this.addEntityViewRootMapping(entityViewRoot, viewRootMappings, entityViewClass, this.context);
                continue;
            }
            if (!(a instanceof EntityViewRoots)) continue;
            EntityViewRoots entityViewRoots = (EntityViewRoots)a;
            for (ViewFilter viewFilter : entityViewRoots.value()) {
                this.addEntityViewRootMapping((EntityViewRoot)viewFilter, viewRootMappings, entityViewClass, this.context);
            }
        }
        viewMapping.setCteProviders(cteProviders);
        viewMapping.setViewFilterProviders(viewFilterProviders);
        viewMapping.setEntityViewRoots(viewRootMappings.isEmpty() ? Collections.emptySet() : new LinkedHashSet(viewRootMappings.values()));
        UpdatableEntityView updatableEntityView = (UpdatableEntityView)AnnotationUtils.findAnnotation(entityViewClass, UpdatableEntityView.class);
        if (updatableEntityView != null) {
            if (isAbstract) {
                viewMapping.setUpdatable(true);
                viewMapping.setFlushMode(updatableEntityView.mode());
                viewMapping.setFlushStrategy(updatableEntityView.strategy());
                viewMapping.setLockMode(updatableEntityView.lockMode());
            } else {
                this.context.addError("Only abstract class entity views can be updatable! Remove the @UpdatableEntityView annotation from the entity view class '" + entityViewClass.getName() + "' or make it abstract.");
            }
        }
        if ((creatableEntityView = (CreatableEntityView)AnnotationUtils.findAnnotation(entityViewClass, CreatableEntityView.class)) != null) {
            if (isAbstract) {
                viewMapping.setCreatable(true);
                viewMapping.setValidatePersistability(creatableEntityView.validatePersistability());
                viewMapping.getExcludedAttributes().addAll(Arrays.asList(creatableEntityView.excludedEntityAttributes()));
            } else {
                this.context.addError("Only abstract class entity views can be creatable! Remove the @CreatableEntityView annotation from the entity view class '" + entityViewClass.getName() + "' or make it abstract.");
            }
        }
        if (updatableEntityView != null || creatableEntityView != null) {
            LockOwner lockOwner = (LockOwner)AnnotationUtils.findAnnotation(entityViewClass, LockOwner.class);
            if (lockOwner != null) {
                viewMapping.setLockOwner(lockOwner.value());
            }
        } else {
            viewMapping.setLockMode(LockMode.NONE);
        }
        EntityViewInheritance inheritanceAnnotation = entityViewClass.getAnnotation(EntityViewInheritance.class);
        EntityViewInheritanceMapping inheritanceMappingAnnotation = entityViewClass.getAnnotation(EntityViewInheritanceMapping.class);
        String inheritanceMapping = inheritanceMappingAnnotation != null ? inheritanceMappingAnnotation.value() : null;
        if (isAbstract) {
            viewMapping.setInheritanceMapping(inheritanceMapping);
            if (inheritanceAnnotation == null) {
                viewMapping.setInheritanceSubtypesResolved(true);
            } else if (inheritanceAnnotation.value().length > 0) {
                viewMapping.getInheritanceSubtypeClasses().addAll(Arrays.asList(inheritanceAnnotation.value()));
                viewMapping.setInheritanceSubtypesResolved(true);
            }
        } else if (inheritanceMapping != null || inheritanceAnnotation != null) {
            this.context.addError("Only abstract class entity views can use inheritance mappings! Remove the inheritance annotations from the entity view class '" + entityViewClass.getName() + "' or make it abstract.");
        } else {
            viewMapping.setInheritanceSubtypesResolved(true);
        }
        if (isAbstract) {
            this.readAbstractClassMappings(entityViewClass, viewMapping);
        } else {
            this.readClassMappings(entityViewClass, viewMapping);
        }
        return viewMapping;
    }

    private void readAbstractClassMappings(Class<?> entityViewClass, ViewMapping viewMapping) {
        Method postCommit;
        MethodAttributeMapping idAttribute = null;
        Map<String, MethodAttributeMapping> attributes = viewMapping.getMethodAttributes();
        ArrayList<Method> specialMethods = new ArrayList<Method>();
        Method[] methods = entityViewClass.getMethods();
        HashSet<String> handledMethods = new HashSet<String>(methods.length);
        HashSet<String> concreteMethods = new HashSet<String>(methods.length);
        Method[] lifecycleMethods = this.visitAndCollectLifecycleMethods(entityViewClass, methods, handledMethods, concreteMethods);
        Method[] lifecycleMethodCandidates = new Method[lifecycleMethods.length];
        for (Class c : ReflectionUtils.getSuperTypes(entityViewClass)) {
            for (Method method : c.getDeclaredMethods()) {
                if (!Modifier.isPrivate(method.getModifiers()) && Modifier.isAbstract(method.getModifiers()) && !method.isBridge()) {
                    Annotation mapping;
                    String attributeName;
                    String methodName = method.getName();
                    if (handledMethods.add(methodName)) {
                        if (method.getReturnType() == EntityViewManager.class) {
                            specialMethods.add(method);
                        } else {
                            attributeName = AbstractMethodAttribute.extractAttributeName(entityViewClass, method, this.context);
                            if (attributeName != null && !attributes.containsKey(attributeName)) {
                                mapping = AnnotationMappingReader.getMapping(attributeName, method, true);
                                MethodAttributeMapping attribute = this.methodAttributeMappingReader.readMethodAttributeMapping(viewMapping, mapping, attributeName, method, method, -1);
                                attributes.put(attributeName, attribute);
                                if (attribute.isId()) {
                                    idAttribute = attribute.handleReplacement(idAttribute);
                                }
                            }
                        }
                    } else if (!concreteMethods.contains(methodName) && method.getReturnType() != EntityViewManager.class && method.getReturnType() != Void.TYPE) {
                        attributeName = AbstractMethodAttribute.getAttributeName(method);
                        mapping = AnnotationMappingReader.getMapping(attributeName, method, true);
                        MethodAttributeMapping originalAttribute = attributes.get(attributeName);
                        if (mapping instanceof MappingLiteral && (c.isInterface() || originalAttribute == null || !originalAttribute.getMethod().getDeclaringClass().isInterface())) continue;
                        MethodAttributeMapping attribute = this.methodAttributeMappingReader.readMethodAttributeMapping(viewMapping, mapping, attributeName, method, method, -1);
                        MethodAttributeMapping newAttribute = attribute.handleReplacement(originalAttribute);
                        if (newAttribute != originalAttribute) {
                            attributes.put(attributeName, newAttribute);
                            if (newAttribute.isId()) {
                                idAttribute = newAttribute.handleReplacement(idAttribute);
                            }
                        }
                    }
                }
                if (Modifier.isAbstract(method.getModifiers()) || method.isBridge()) continue;
                for (int i = 0; i < lifecycleMethods.length; ++i) {
                    if (lifecycleMethods[i] != null || AnnotationUtils.findAnnotation((Method)method, (Class)LIFECYCLE_ENTRIES[i].annotation) == null) continue;
                    if (lifecycleMethodCandidates[i] != null) {
                        if (lifecycleMethodCandidates[i].getDeclaringClass().isAssignableFrom(method.getDeclaringClass())) {
                            lifecycleMethodCandidates[i] = method;
                            continue;
                        }
                        if (method.getDeclaringClass().isAssignableFrom(lifecycleMethodCandidates[i].getDeclaringClass())) continue;
                        this.context.addError("Multiple " + LIFECYCLE_ENTRIES[i].name + " methods found in super types of entity view '" + entityViewClass.getName() + "':\n\t" + lifecycleMethodCandidates[i].getDeclaringClass().getName() + "." + lifecycleMethodCandidates[i].getName() + "\n\t" + method.getDeclaringClass().getName() + "." + method.getName());
                        continue;
                    }
                    lifecycleMethodCandidates[i] = method;
                }
            }
        }
        for (int i = 0; i < lifecycleMethods.length; ++i) {
            if (lifecycleMethods[i] != null) continue;
            lifecycleMethods[i] = lifecycleMethodCandidates[i];
        }
        viewMapping.setPostCreateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostCreate.class).index]);
        viewMapping.setPostConvertMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostConvert.class).index]);
        viewMapping.setPostLoadMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostLoad.class).index]);
        viewMapping.setPrePersistMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PrePersist.class).index]);
        viewMapping.setPostPersistMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostPersist.class).index]);
        viewMapping.setPreUpdateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PreUpdate.class).index]);
        viewMapping.setPostUpdateMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostUpdate.class).index]);
        viewMapping.setPreRemoveMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PreRemove.class).index]);
        viewMapping.setPostRemoveMethod(lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostRemove.class).index]);
        Method postRollback = lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostRollback.class).index];
        if (postRollback != null) {
            viewMapping.setPostRollbackMethod(postRollback);
            PostRollback annotation = (PostRollback)AnnotationUtils.findAnnotation((Method)postRollback, PostRollback.class);
            viewMapping.setPostRollbackTransitions(annotation.transitions());
        }
        if ((postCommit = lifecycleMethods[LIFECYCLE_ENTRY_MAP.get(PostCommit.class).index]) != null) {
            viewMapping.setPostCommitMethod(postCommit);
            PostCommit annotation = (PostCommit)AnnotationUtils.findAnnotation((Method)postCommit, PostCommit.class);
            viewMapping.setPostCommitTransitions(annotation.transitions());
        }
        viewMapping.setSpecialMethods(specialMethods);
        viewMapping.setIdAttributeMapping(idAttribute);
        for (Executable executable : entityViewClass.getDeclaredConstructors()) {
            int parameterCount = ((Constructor)executable).getParameterTypes().length;
            ArrayList<ParameterAttributeMapping> parameters = new ArrayList<ParameterAttributeMapping>(parameterCount);
            String constructorName = AnnotationMappingReader.extractConstructorName(executable);
            ConstructorMapping constructorMapping = new ConstructorMapping(viewMapping, constructorName, (Constructor<?>)executable, (List<ParameterAttributeMapping>)parameters, this.context);
            Annotation[][] parameterAnnotations = ((Constructor)executable).getParameterAnnotations();
            for (int i = 0; i < parameterCount; ++i) {
                MapAnnotatedElement annotatedElement = new MapAnnotatedElement(parameterAnnotations[i]);
                Annotation mapping = AnnotationMappingReader.getMapping(annotatedElement, executable, i, this.context);
                if (mapping == null) continue;
                ParameterAttributeMapping parameter = this.parameterAttributeMappingReader.readParameterAttributeMapping(viewMapping, mapping, constructorMapping, i, annotatedElement);
                parameters.add(parameter);
            }
            viewMapping.addConstructor(constructorMapping);
        }
    }

    private void readClassMappings(Class<?> entityViewClass, ViewMapping viewMapping) {
        Constructor<?>[] declaredConstructors = entityViewClass.getDeclaredConstructors();
        Constructor<?> canonicalConstructor = null;
        if (declaredConstructors.length == 1) {
            canonicalConstructor = declaredConstructors[0];
        } else {
            for (Constructor<?> constructor : declaredConstructors) {
                ViewConstructor viewConstructor = constructor.getAnnotation(ViewConstructor.class);
                if (viewConstructor == null || !viewConstructor.value().isEmpty() && !"init".equals(viewConstructor.value())) continue;
                if (canonicalConstructor == null) {
                    canonicalConstructor = constructor;
                    continue;
                }
                this.context.addError("Multiple constructors in entity view class '" + entityViewClass.getName() + "' are annotated with @ViewConstructor(\"init\") but exactly one canonical constructor is required!");
                return;
            }
        }
        if (canonicalConstructor == null) {
            this.context.addError("Could not find canonical constructor for entity view class '" + entityViewClass.getName() + "'. Please annotate it with @ViewConstructor(\"init\")!");
            return;
        }
        Map<String, AttributeInfo> fieldsToAccessors = this.findAccessors(entityViewClass);
        if (fieldsToAccessors == null) {
            return;
        }
        AttributeInfo[] parameterToAccessorMapping = this.analyzeParameterToAccessorMapping(entityViewClass, canonicalConstructor, fieldsToAccessors);
        boolean ok = true;
        for (int i = 0; i < parameterToAccessorMapping.length; ++i) {
            if (parameterToAccessorMapping[i] == null) {
                this.context.addError("Could not determine the attribute for the parameter at index " + i + " of the canonical constructor: " + canonicalConstructor);
                ok = false;
                continue;
            }
            if (parameterToAccessorMapping[i].getter != null) continue;
            this.context.addError("Could not determine the accessor for the attribute for the parameter at index " + i + " of the canonical constructor: " + canonicalConstructor);
            ok = false;
        }
        if (!ok) {
            return;
        }
        Map<String, MethodAttributeMapping> attributes = viewMapping.getMethodAttributes();
        Annotation[][] canonicalParameterAnnotations = canonicalConstructor.getParameterAnnotations();
        MethodAttributeMapping idAttribute = null;
        for (int i = 0; i < parameterToAccessorMapping.length; ++i) {
            AttributeInfo attributeInfo = parameterToAccessorMapping[i];
            if (attributeInfo == null) continue;
            MapAnnotatedElement annotatedElement = new MapAnnotatedElement(canonicalParameterAnnotations[i]);
            Annotation mapping = AnnotationMappingReader.getMapping(attributeInfo.attributeName, annotatedElement, false);
            if (mapping == null) {
                mapping = AnnotationMappingReader.getMapping(attributeInfo.attributeName, attributeInfo.field, true);
            }
            MethodAttributeMapping attribute = this.methodAttributeMappingReader.readMethodAttributeMapping(viewMapping, mapping, attributeInfo.attributeName, attributeInfo.getter, annotatedElement, i);
            attributes.put(attributeInfo.attributeName, attribute);
            if (!attribute.isId()) continue;
            idAttribute = attribute.handleReplacement(idAttribute);
        }
        viewMapping.setIdAttributeMapping(idAttribute);
    }

    public static Annotation getMapping(String attributeName, AnnotatedElement annotatedElement, boolean implicitMapping) {
        Mapping mapping = annotatedElement.getAnnotation(Mapping.class);
        if (mapping == null) {
            IdMapping idMapping = annotatedElement.getAnnotation(IdMapping.class);
            if (idMapping != null) {
                if (idMapping.value().isEmpty()) {
                    idMapping = new IdMappingLiteral(attributeName);
                }
                return idMapping;
            }
            MappingParameter mappingParameter = annotatedElement.getAnnotation(MappingParameter.class);
            if (mappingParameter != null) {
                return mappingParameter;
            }
            MappingSubquery mappingSubquery = annotatedElement.getAnnotation(MappingSubquery.class);
            if (mappingSubquery != null) {
                return mappingSubquery;
            }
            MappingCorrelated mappingCorrelated = annotatedElement.getAnnotation(MappingCorrelated.class);
            if (mappingCorrelated != null) {
                return mappingCorrelated;
            }
            MappingCorrelatedSimple mappingCorrelatedSimple = annotatedElement.getAnnotation(MappingCorrelatedSimple.class);
            if (mappingCorrelatedSimple != null) {
                return mappingCorrelatedSimple;
            }
            if (implicitMapping) {
                mapping = new MappingLiteral(attributeName);
            } else {
                return null;
            }
        }
        if (mapping.value().isEmpty()) {
            mapping = new MappingLiteral(attributeName, mapping);
        }
        return mapping;
    }

    public static Annotation getMapping(AnnotatedElement annotatedElement, Constructor<?> constructor, int index, MetamodelBootContext context) {
        if (annotatedElement.isAnnotationPresent(IdMapping.class)) {
            context.addError("The @IdMapping annotation is disallowed for entity view constructors for the " + ParameterAttributeMapping.getLocation(constructor, index));
            return null;
        }
        Mapping mapping = annotatedElement.getAnnotation(Mapping.class);
        if (mapping != null) {
            return mapping;
        }
        MappingParameter mappingParameter = annotatedElement.getAnnotation(MappingParameter.class);
        if (mappingParameter != null) {
            return mappingParameter;
        }
        MappingSubquery mappingSubquery = annotatedElement.getAnnotation(MappingSubquery.class);
        if (mappingSubquery != null) {
            return mappingSubquery;
        }
        MappingCorrelated mappingCorrelated = annotatedElement.getAnnotation(MappingCorrelated.class);
        if (mappingCorrelated != null) {
            return mappingCorrelated;
        }
        MappingCorrelatedSimple mappingCorrelatedSimple = annotatedElement.getAnnotation(MappingCorrelatedSimple.class);
        if (mappingCorrelatedSimple != null) {
            return mappingCorrelatedSimple;
        }
        Self self = annotatedElement.getAnnotation(Self.class);
        if (self != null) {
            return self;
        }
        context.addError("No entity view mapping annotation given for the " + ParameterAttributeMapping.getLocation(constructor, index));
        return null;
    }

    private AttributeInfo[] analyzeParameterToAccessorMapping(Class<?> entityViewClass, Constructor<?> canonicalConstructor, Map<String, AttributeInfo> fieldsToAccessors) {
        HashMap<String, AttributeInfo> setterToAccessors = new HashMap<String, AttributeInfo>();
        for (AttributeInfo attributeInfo : fieldsToAccessors.values()) {
            if (attributeInfo.setter == null) continue;
            setterToAccessors.put(attributeInfo.setter.getName(), attributeInfo);
        }
        Object[] parameterTypes = canonicalConstructor.getParameterTypes();
        AttributeInfo[] parameterToAccessorMapping = new AttributeInfo[parameterTypes.length];
        try {
            ClassPool pool = new ClassPool(true);
            pool.appendClassPath((ClassPath)new LoaderClassPath(entityViewClass.getClassLoader()));
            CtClass ctClass = pool.get(entityViewClass.getName());
            CtClass[] constructorParams = new CtClass[parameterTypes.length];
            int parameterStackSlots = parameterTypes.length;
            for (int i = 0; i < parameterTypes.length; ++i) {
                CtClass parameterTypeClass;
                constructorParams[i] = parameterTypeClass = pool.get(((Class)parameterTypes[i]).getName());
                if (!(parameterTypeClass instanceof CtPrimitiveType) || ((CtPrimitiveType)parameterTypeClass).getDataSize() != 2) continue;
                ++parameterStackSlots;
            }
            CtConstructor constructor = ctClass.getDeclaredConstructor(constructorParams);
            ConstPool cp = constructor.getMethodInfo().getConstPool();
            CodeIterator ci = constructor.getMethodInfo().getCodeAttribute().iterator();
            AssignmentAnalyzer analyzer = new AssignmentAnalyzer();
            Frame[] frames = analyzer.analyze(ctClass, constructor.getMethodInfo2());
            while (ci.hasNext()) {
                int index = ci.next();
                int op = ci.byteAt(index);
                switch (op) {
                    case 181: {
                        int cpIndex;
                        AttributeInfo attributeInfo;
                        Integer sourceOrigin;
                        Integer targetOrigin;
                        Frame frame = frames[index];
                        if (frame.peek() == Type.TOP) {
                            targetOrigin = frame.getStackOrigin(frame.getTopIndex() - 2);
                            sourceOrigin = frame.getStackOrigin(frame.getTopIndex() - 1);
                        } else {
                            targetOrigin = frame.getStackOrigin(frame.getTopIndex() - 1);
                            sourceOrigin = frame.getStackOrigin(frame.getTopIndex());
                        }
                        if (targetOrigin == null || sourceOrigin == null || targetOrigin != 0 || sourceOrigin > parameterStackSlots || (attributeInfo = fieldsToAccessors.get(cp.getFieldrefName(cpIndex = ci.u16bitAt(index + 1)))) == null || !attributeInfo.className.equals(cp.getFieldrefClassName(cpIndex))) break;
                        parameterToAccessorMapping[AnnotationMappingReader.stackSlotToParameterIndex((int)sourceOrigin.intValue(), (CtClass[])constructorParams)] = attributeInfo;
                        break;
                    }
                    case 182: 
                    case 183: 
                    case 185: {
                        AttributeInfo attributeInfo;
                        Integer sourceOrigin;
                        Integer targetOrigin;
                        int methodCpIdx = ci.u16bitAt(index + 1);
                        String methodName = cp.getMethodrefName(methodCpIdx);
                        Frame frame = frames[index];
                        if ("<init>".equals(methodName)) {
                            CtClass[] superParameterTypes;
                            Class<?> superclass = entityViewClass.getSuperclass();
                            if (superclass == Object.class || (superParameterTypes = Descriptor.getParameterTypes((String)cp.getMethodrefType(methodCpIdx), (ClassPool)pool)).length == 0) break;
                            Class[] superParamTypes = new Class[superParameterTypes.length];
                            for (int i = 0; i < superParameterTypes.length; ++i) {
                                superParamTypes[i] = superParameterTypes[i].isPrimitive() ? ReflectionUtils.getClass((String)superParameterTypes[i].getName()) : entityViewClass.getClassLoader().loadClass(superParameterTypes[i].getName());
                            }
                            Constructor<?> superConstructor = superclass.getDeclaredConstructor(superParamTypes);
                            AttributeInfo[] superAttributes = this.analyzeParameterToAccessorMapping(superclass, superConstructor, fieldsToAccessors);
                            int offset = frame.getTopIndex();
                            for (int i = superAttributes.length - 1; i >= 0; --i) {
                                Integer origin;
                                AttributeInfo superAttribute = superAttributes[i];
                                if (frame.getStack(offset) == Type.TOP) {
                                    --offset;
                                }
                                if (superAttribute != null && (origin = frame.getStackOrigin(offset)) != null) {
                                    parameterToAccessorMapping[origin.intValue() - 1] = superAttribute;
                                }
                                --offset;
                            }
                            break;
                        }
                        if (frame.peek() == Type.TOP) {
                            targetOrigin = frame.getTopIndex() > 1 ? frame.getStackOrigin(frame.getTopIndex() - 2) : null;
                            sourceOrigin = frame.getStackOrigin(frame.getTopIndex() - 1);
                        } else {
                            targetOrigin = frame.getTopIndex() > 0 ? frame.getStackOrigin(frame.getTopIndex() - 1) : null;
                            sourceOrigin = frame.getStackOrigin(frame.getTopIndex());
                        }
                        if (targetOrigin == null || sourceOrigin == null || targetOrigin != 0 || sourceOrigin > parameterToAccessorMapping.length || (attributeInfo = (AttributeInfo)setterToAccessors.get(methodName)) == null || !cp.getMethodrefType(methodCpIdx).equals(Descriptor.ofMethod((CtClass)CtClass.voidType, (CtClass[])new CtClass[]{pool.get(attributeInfo.field.getType().getName())}))) break;
                        parameterToAccessorMapping[sourceOrigin.intValue() - 1] = attributeInfo;
                        break;
                    }
                }
            }
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            sw.append("Could not analyze the parameter to field mapping of the canonical constructor of '").append(entityViewClass.getName()).append("' with the parameter types ").append(Arrays.toString(parameterTypes)).append(" because of the following exception:\n");
            ex.printStackTrace(new PrintWriter(sw));
            this.context.addError(sw.toString());
        }
        return parameterToAccessorMapping;
    }

    private static int stackSlotToParameterIndex(int stackSlot, CtClass[] methodParameterTypes) {
        for (int i = 0; i < methodParameterTypes.length; ++i) {
            if (stackSlot == 1) {
                return i;
            }
            CtClass parameterTypeClass = methodParameterTypes[i];
            if (parameterTypeClass instanceof CtPrimitiveType && ((CtPrimitiveType)parameterTypeClass).getDataSize() == 2) {
                stackSlot -= 2;
                continue;
            }
            --stackSlot;
        }
        return -1;
    }

    private Map<String, AttributeInfo> findAccessors(Class<?> entityViewClass) {
        HashMap<String, AttributeInfo> accessors = new HashMap<String, AttributeInfo>();
        Class<?> currentClass = entityViewClass;
        do {
            for (Field field : currentClass.getDeclaredFields()) {
                if (accessors.put(field.getName(), new AttributeInfo(currentClass.getName(), field.getName(), field, Modifier.isFinal(field.getModifiers()), ReflectionUtils.getResolvedFieldType(entityViewClass, (Field)field))) == null) continue;
                this.context.addError("The entity view class '" + entityViewClass.getName() + "' defines the field '" + field.getName() + "' multiple times in the class hierarchy which is disallowed for non-abstract entity views!");
                return null;
            }
            for (AccessibleObject accessibleObject : currentClass.getDeclaredMethods()) {
                AttributeInfo attributeInfo;
                String fieldName;
                if (Modifier.isAbstract(((Method)accessibleObject).getModifiers())) continue;
                Class<?>[] parameterTypes = ((Method)accessibleObject).getParameterTypes();
                String methodName = ((Method)accessibleObject).getName();
                if (parameterTypes.length == 0) {
                    fieldName = methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) && (Boolean.TYPE == ((Method)accessibleObject).getReturnType() || Boolean.class == ((Method)accessibleObject).getReturnType()) ? Character.toLowerCase(methodName.charAt(2)) + methodName.substring(3) : methodName);
                    attributeInfo = (AttributeInfo)accessors.get(fieldName);
                    if (attributeInfo == null || !((Method)accessibleObject).getReturnType().isAssignableFrom(attributeInfo.type)) continue;
                    attributeInfo.getter = accessibleObject;
                    continue;
                }
                if (parameterTypes.length != 1 || Void.TYPE != ((Method)accessibleObject).getReturnType() || (attributeInfo = (AttributeInfo)accessors.get(fieldName = methodName.startsWith("set") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4) : methodName)) == null || attributeInfo.isFinal || !parameterTypes[0].isAssignableFrom(attributeInfo.type)) continue;
                attributeInfo.setter = accessibleObject;
            }
        } while ((currentClass = currentClass.getSuperclass()) != Object.class);
        return accessors;
    }

    private void addFilterMapping(String filterName, Class<? extends ViewFilterProvider> viewFilterProvider, Map<String, Class<? extends ViewFilterProvider>> viewFilters, Class<?> entityViewClass, MetamodelBootContext context) {
        boolean errorOccurred = false;
        if (filterName != null && filterName.isEmpty()) {
            errorOccurred = true;
            context.addError("Illegal empty name for the filter mapping at the class '" + entityViewClass.getName() + "' with filter class '" + viewFilterProvider.getName() + "'!");
        } else if (viewFilters.containsKey(filterName)) {
            errorOccurred = true;
            context.addError("Illegal duplicate filter name mapping '" + filterName + "' at the class '" + entityViewClass.getName() + "'!");
        }
        if (!errorOccurred) {
            viewFilters.put(filterName, viewFilterProvider);
        }
    }

    private void addEntityViewRootMapping(EntityViewRoot entityViewRoot, Map<String, EntityViewRootMapping> viewRootMappings, Class<?> entityViewClass, MetamodelBootContext context) {
        boolean errorOccurred = false;
        String viewRootName = entityViewRoot.name();
        if (viewRootName != null && viewRootName.isEmpty()) {
            errorOccurred = true;
            context.addError("Illegal empty name for the entity view root at the class '" + entityViewClass.getName() + "'!");
        } else if (viewRootMappings.containsKey(viewRootName)) {
            errorOccurred = true;
            context.addError("Illegal duplicate entity view root name '" + viewRootName + "' at the class '" + entityViewClass.getName() + "'!");
        }
        Class entityClass = entityViewRoot.entity();
        String joinExpression = entityViewRoot.expression();
        Class correlationProvider = entityViewRoot.correlator();
        String conditionExpression = entityViewRoot.condition();
        if (entityClass == Void.TYPE) {
            entityClass = null;
        }
        if (joinExpression != null && joinExpression.isEmpty()) {
            joinExpression = null;
        }
        if (correlationProvider == CorrelationProvider.class) {
            correlationProvider = null;
        }
        if (conditionExpression != null && conditionExpression.isEmpty()) {
            conditionExpression = null;
        }
        if (!errorOccurred) {
            viewRootMappings.put(viewRootName, new EntityViewRootMappingImpl(viewRootName, entityClass, joinExpression, correlationProvider, conditionExpression, entityViewRoot.joinType(), entityViewRoot.fetches(), Arrays.asList(entityViewRoot.order()), entityViewRoot.limit(), entityViewRoot.offset()));
        }
    }

    private Method[] visitAndCollectLifecycleMethods(Class<?> entityViewClass, Method[] methods, Set<String> handledMethods, Set<String> concreteMethods) {
        Method[] foundMethods = new Method[LIFECYCLE_ENTRY_MAP.size()];
        for (Method method : methods) {
            if (Modifier.isAbstract(method.getModifiers()) || method.isBridge()) continue;
            handledMethods.add(method.getName());
            concreteMethods.add(method.getName());
            if (entityViewClass.isInterface()) continue;
            for (Annotation annotation : AnnotationUtils.getAllAnnotations((Method)method)) {
                LifecycleEntry lifecycleEntry = LIFECYCLE_ENTRY_MAP.get(annotation.annotationType());
                if (lifecycleEntry == null) continue;
                if (foundMethods[lifecycleEntry.index] != null) {
                    this.context.addError("Multiple " + lifecycleEntry.name + " methods found:\n\t" + foundMethods[lifecycleEntry.index].getDeclaringClass().getName() + "." + foundMethods[lifecycleEntry.index].getName() + "\n\t" + method.getDeclaringClass().getName() + "." + method.getName());
                    continue;
                }
                foundMethods[((LifecycleEntry)lifecycleEntry).index] = method;
            }
        }
        return foundMethods;
    }

    public static String extractConstructorName(Constructor<?> c) {
        ViewConstructor viewConstructor = c.getAnnotation(ViewConstructor.class);
        if (viewConstructor == null) {
            return "init";
        }
        return viewConstructor.value();
    }

    static {
        LifecycleEntry[] lifecycleEntries = new LifecycleEntry[]{new LifecycleEntry(0, "post create", PostCreate.class), new LifecycleEntry(1, "pre persist", PrePersist.class), new LifecycleEntry(2, "post persist", PostPersist.class), new LifecycleEntry(3, "pre update", PreUpdate.class), new LifecycleEntry(4, "post update", PostUpdate.class), new LifecycleEntry(5, "pre remove", PreRemove.class), new LifecycleEntry(6, "post remove", PostRemove.class), new LifecycleEntry(7, "post rollback", PostRollback.class), new LifecycleEntry(8, "post commit", PostCommit.class), new LifecycleEntry(9, "post create", PostConvert.class), new LifecycleEntry(10, "post load", PostLoad.class)};
        LIFECYCLE_ENTRIES = lifecycleEntries;
        HashMap lifecycleEntryMap = new HashMap(lifecycleEntries.length);
        for (LifecycleEntry lifecycleEntry : lifecycleEntries) {
            lifecycleEntryMap.put(lifecycleEntry.annotation, lifecycleEntry);
        }
        LIFECYCLE_ENTRY_MAP = lifecycleEntryMap;
    }

    private static class LifecycleEntry {
        private final int index;
        private final String name;
        private final Class<? extends Annotation> annotation;

        public LifecycleEntry(int index, String name, Class<? extends Annotation> annotation) {
            this.index = index;
            this.name = name;
            this.annotation = annotation;
        }
    }

    private static final class AttributeInfo {
        final String className;
        final String attributeName;
        final Field field;
        final boolean isFinal;
        final Class<?> type;
        Method getter;
        Method setter;

        public AttributeInfo(String className, String attributeName, Field field, boolean isFinal, Class<?> type) {
            this.className = className;
            this.attributeName = attributeName;
            this.field = field;
            this.isFinal = isFinal;
            this.type = type;
        }
    }
}

