/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.filter;

import com.blazebit.persistence.RestrictionBuilder;
import com.blazebit.persistence.WhereBuilder;
import com.blazebit.persistence.view.SubqueryProvider;
import com.blazebit.persistence.view.filter.BetweenFilter;
import com.blazebit.persistence.view.filter.Range;

public class BetweenFilterImpl<FilterValue>
extends BetweenFilter<FilterValue> {
    private final Range<FilterValue> range;

    public BetweenFilterImpl(Object value) {
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof Range) {
            this.range = (Range)value;
        } else if (value instanceof Object[]) {
            Object[] objects = (Object[])value;
            if (objects.length != 2) {
                throw new IllegalArgumentException("Range filter needs a Range or Object[2] but got: " + value);
            }
            this.range = Range.between((Object)objects[0], (Object)objects[1]);
        } else {
            throw new IllegalArgumentException("Range filter needs a Range or Object[2] but got: " + value);
        }
    }

    public <T extends WhereBuilder<T>> T apply(T whereBuilder, String attributeExpression) {
        RestrictionBuilder restrictionBuilder = whereBuilder.where(attributeExpression);
        if (this.range.getLowerBound() == null) {
            if (this.range.isInclusive()) {
                return (T)((WhereBuilder)restrictionBuilder.le(this.range.getUpperBound()));
            }
            return (T)((WhereBuilder)restrictionBuilder.lt(this.range.getUpperBound()));
        }
        if (this.range.getUpperBound() == null) {
            if (this.range.isInclusive()) {
                return (T)((WhereBuilder)restrictionBuilder.ge(this.range.getLowerBound()));
            }
            return (T)((WhereBuilder)restrictionBuilder.gt(this.range.getLowerBound()));
        }
        if (this.range.isInclusive()) {
            return (T)((WhereBuilder)restrictionBuilder.between(this.range.getLowerBound()).and(this.range.getUpperBound()));
        }
        return (T)((WhereBuilder)((WhereBuilder)restrictionBuilder.gt(this.range.getLowerBound())).where(attributeExpression).lt(this.range.getUpperBound()));
    }

    public <T extends WhereBuilder<T>> T apply(T whereBuilder, String subqueryAlias, String subqueryExpresion, SubqueryProvider provider) {
        RestrictionBuilder restrictionBuilder = subqueryAlias == null ? (RestrictionBuilder)provider.createSubquery(whereBuilder.whereSubquery()) : (RestrictionBuilder)provider.createSubquery(whereBuilder.whereSubquery(subqueryAlias, subqueryExpresion));
        if (this.range.getLowerBound() == null) {
            if (this.range.isInclusive()) {
                return (T)((WhereBuilder)restrictionBuilder.le(this.range.getUpperBound()));
            }
            return (T)((WhereBuilder)restrictionBuilder.lt(this.range.getUpperBound()));
        }
        if (this.range.getUpperBound() == null) {
            if (this.range.isInclusive()) {
                return (T)((WhereBuilder)restrictionBuilder.ge(this.range.getLowerBound()));
            }
            return (T)((WhereBuilder)restrictionBuilder.gt(this.range.getLowerBound()));
        }
        if (this.range.isInclusive()) {
            return (T)((WhereBuilder)restrictionBuilder.between(this.range.getLowerBound()).and(this.range.getUpperBound()));
        }
        restrictionBuilder.gt(this.range.getLowerBound());
        if (subqueryAlias == null) {
            return (T)((WhereBuilder)((RestrictionBuilder)provider.createSubquery(whereBuilder.whereSubquery())).lt(this.range.getUpperBound()));
        }
        return (T)((WhereBuilder)((RestrictionBuilder)provider.createSubquery(whereBuilder.whereSubquery(subqueryAlias, subqueryExpresion))).lt(this.range.getUpperBound()));
    }
}

