/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.entity;

import com.blazebit.persistence.parser.util.JpaMetamodelUtils;
import com.blazebit.persistence.spi.ExtendedAttribute;
import com.blazebit.persistence.spi.ExtendedManagedType;
import com.blazebit.persistence.view.impl.EntityViewManagerImpl;
import com.blazebit.persistence.view.impl.accessor.Accessors;
import com.blazebit.persistence.view.impl.accessor.AttributeAccessor;
import com.blazebit.persistence.view.impl.entity.EntityLoader;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MappingAttribute;
import com.blazebit.persistence.view.metamodel.ViewType;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.SingularAttribute;

public abstract class AbstractEntityLoader
implements EntityLoader {
    protected final Class<?> entityClass;
    protected final ViewToEntityMapper viewIdMapper;
    protected final Constructor<Object> entityConstructor;
    protected final String idAttributeName;
    protected final AttributeAccessor entityIdAccessor;
    protected final boolean primaryKeyId;

    public AbstractEntityLoader(EntityViewManagerImpl evm, Class<?> entityClass, SingularAttribute<?, ?> jpaIdAttribute, SingularAttribute<?, ?> viewIdMappingAttribute, ViewToEntityMapper viewIdMapper, AttributeAccessor entityIdAccessor) {
        this.entityClass = entityClass;
        this.viewIdMapper = viewIdMapper;
        try {
            Constructor<?> constructor = entityClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            this.entityConstructor = constructor;
            if (jpaIdAttribute != null) {
                if (viewIdMappingAttribute != null && !viewIdMappingAttribute.getName().equals(jpaIdAttribute.getName())) {
                    this.idAttributeName = viewIdMappingAttribute.getName();
                    this.entityIdAccessor = Accessors.forEntityMapping(evm, entityClass, viewIdMappingAttribute.getName());
                    this.primaryKeyId = false;
                } else {
                    this.idAttributeName = jpaIdAttribute.getName();
                    this.entityIdAccessor = entityIdAccessor;
                    this.primaryKeyId = true;
                }
            } else {
                this.idAttributeName = null;
                this.entityIdAccessor = null;
                this.primaryKeyId = true;
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Couldn't find required no-arg constructor for entity class: " + entityClass.getName(), e);
        }
    }

    protected static SingularAttribute<?, ?> jpaIdOf(EntityViewManagerImpl evm, ManagedViewType<?> subviewType) {
        if (subviewType instanceof ViewType) {
            return JpaMetamodelUtils.getSingleIdAttribute((IdentifiableType)evm.getMetamodel().getEntityMetamodel().entity(subviewType.getEntityClass()));
        }
        return null;
    }

    protected static SingularAttribute<?, ?> viewIdMappingOf(EntityViewManagerImpl evm, ManagedViewType<?> subviewType) {
        if (subviewType instanceof ViewType) {
            ExtendedManagedType managedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, subviewType.getEntityClass());
            return (SingularAttribute)((ExtendedAttribute)managedType.getAttributes().get(((MappingAttribute)((ViewType)subviewType).getIdAttribute()).getMapping())).getAttribute();
        }
        return null;
    }

    protected static SingularAttribute<?, ?> associationIdMappingOf(EntityViewManagerImpl evm, ManagedViewType<?> subviewType, String attributeIdAttributeName) {
        if (subviewType instanceof ViewType) {
            ExtendedManagedType managedType = (ExtendedManagedType)evm.getMetamodel().getEntityMetamodel().getManagedType(ExtendedManagedType.class, subviewType.getEntityClass());
            return (SingularAttribute)((ExtendedAttribute)managedType.getAttributes().get(attributeIdAttributeName)).getAttribute();
        }
        return null;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public void toEntities(UpdateContext context, List<Object> views, List<Object> ids) {
        for (int i = 0; i < views.size(); ++i) {
            views.set(i, this.toEntity(context, views.get(i), ids.get(i)));
        }
    }

    @Override
    public Object getEntityId(UpdateContext context, Object entity) {
        if (this.entityIdAccessor == null) {
            return null;
        }
        return this.entityIdAccessor.getValue(entity);
    }

    protected final Object createEntity() {
        try {
            return this.entityConstructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Couldn't map entity view to entity!", e);
        }
    }

    protected final Object getReferenceOrLoad(UpdateContext context, Object view, Object id) {
        id = this.getEntityId(context, view, id);
        if (this.primaryKeyId && context.containsEntity(this.entityClass, id)) {
            return context.getEntityManager().getReference(this.entityClass, id);
        }
        return this.queryEntity(context.getEntityManager(), id);
    }

    protected final void getReferencesLoadOrCreate(UpdateContext context, List<Object> views, List<Object> ids) {
        Object id;
        Object view;
        int i;
        ArrayList<Object> idsToQuery = null;
        if (this.primaryKeyId) {
            for (i = 0; i < views.size(); ++i) {
                view = views.get(i);
                id = ids.get(i);
                if (id == null) {
                    views.set(i, this.createEntity());
                    continue;
                }
                if (context.containsEntity(this.entityClass, id = this.getEntityId(context, view, id))) {
                    views.set(i, context.getEntityManager().getReference(this.entityClass, id));
                    ids.set(i, null);
                    continue;
                }
                if (idsToQuery == null) {
                    idsToQuery = new ArrayList(ids.size());
                }
                idsToQuery.add(id);
            }
        } else {
            idsToQuery = new ArrayList<Object>(ids.size());
            for (i = 0; i < views.size(); ++i) {
                view = views.get(i);
                id = ids.get(i);
                if (id == null) {
                    views.set(i, this.createEntity());
                    continue;
                }
                idsToQuery.add(this.getEntityId(context, view, id));
            }
        }
        if (idsToQuery != null && !idsToQuery.isEmpty()) {
            List<Object> entities = this.queryEntities(context.getEntityManager(), idsToQuery);
            HashMap<Object, Object> entityIndex = new HashMap<Object, Object>(entities.size());
            for (Object e : entities) {
                entityIndex.put(this.getEntityId(context, e), e);
            }
            for (int i2 = 0; i2 < views.size(); ++i2) {
                Object id2 = ids.get(i2);
                if (id2 == null) continue;
                Object entity = entityIndex.get(this.getEntityId(context, views.get(i2), id2));
                views.set(i2, entity);
            }
        }
    }

    protected final Object getEntityId(UpdateContext context, Object view, Object id) {
        if (this.viewIdMapper != null) {
            id = this.viewIdMapper.applyToEntity(context, null, id);
        }
        return id;
    }

    protected abstract Object queryEntity(EntityManager var1, Object var2);

    protected abstract List<Object> queryEntities(EntityManager var1, List<Object> var2);
}

