/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.MapAction;
import com.blazebit.persistence.view.impl.entity.MapViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MapRemoveAction<C extends Map<K, V>, K, V>
implements MapAction<C> {
    private final Object key;
    private final V removedElementInView;

    public MapRemoveAction(Object key, Map<K, V> delegate) {
        this.key = key;
        this.removedElementInView = delegate.get(key);
    }

    public MapRemoveAction(Object key, V removedElementInView) {
        this.key = key;
        this.removedElementInView = removedElementInView;
    }

    @Override
    public void doAction(C map, UpdateContext context, MapViewToEntityMapper mapper, CollectionRemoveListener keyRemoveListener, CollectionRemoveListener valueRemoveListener) {
        Object value = mapper != null && mapper.getKeyMapper() != null ? map.remove(mapper.getKeyMapper().applyToEntity(context, null, this.key)) : map.remove(this.key);
        if (value != null) {
            if (keyRemoveListener != null) {
                keyRemoveListener.onCollectionRemove(context, this.key);
            }
            if (valueRemoveListener != null) {
                valueRemoveListener.onCollectionRemove(context, this.removedElementInView);
            }
        }
    }

    @Override
    public void undo(C map, Collection<?> removedKeys, Collection<?> addedKeys, Collection<?> removedElements, Collection<?> addedElements) {
        if (removedKeys.contains(this.key) || removedElements.contains(this.removedElementInView)) {
            map.put((Object)this.key, this.removedElementInView);
        }
    }

    @Override
    public Collection<Object> getAddedKeys() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys() {
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<Object> getAddedElements() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements() {
        if (this.removedElementInView == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(this.removedElementInView);
    }

    @Override
    public Collection<Object> getAddedKeys(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedKeys(C collection) {
        return Collections.singleton(this.key);
    }

    @Override
    public Collection<Object> getAddedElements(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedElements(C collection) {
        Object value = collection.get(this.key);
        if (value == null) {
            return Collections.emptyList();
        }
        return Collections.singleton(value);
    }

    @Override
    public MapAction<C> replaceObject(Object oldKey, Object oldValue, Object newKey, Object newValue) {
        if (oldKey == this.key) {
            return new MapRemoveAction<C, K, V>(newKey, this.removedElementInView);
        }
        return null;
    }

    @Override
    public MapAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Object newKey = objectMapping.get(this.key);
        Object newRemovedElementInView = objectMapping.get(this.removedElementInView);
        if (newKey != null) {
            if (newRemovedElementInView == null) {
                return new MapRemoveAction<C, K, V>(newKey, this.removedElementInView);
            }
            return new MapRemoveAction<C, K, Object>(newKey, newRemovedElementInView);
        }
        if (newRemovedElementInView != null) {
            return new MapRemoveAction<C, K, Object>(this.key, newRemovedElementInView);
        }
        return this;
    }

    @Override
    public void addAction(List<MapAction<C>> actions, Collection<Object> addedKeys, Collection<Object> removedKeys, Collection<Object> addedElements, Collection<Object> removedElements) {
        actions.add(this);
    }
}

