/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.collection;

import com.blazebit.persistence.view.impl.collection.CollectionAction;
import com.blazebit.persistence.view.impl.collection.CollectionRemoveListener;
import com.blazebit.persistence.view.impl.collection.ListAction;
import com.blazebit.persistence.view.impl.collection.RecordingCollection;
import com.blazebit.persistence.view.impl.entity.ViewToEntityMapper;
import com.blazebit.persistence.view.impl.update.UpdateContext;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ListRemoveAction<C extends List<E>, E>
implements ListAction<C> {
    private final int index;
    private final boolean last;
    private final Object removedElementInView;

    public ListRemoveAction(int index, boolean last, List<?> delegate) {
        this.index = index;
        this.last = last;
        this.removedElementInView = delegate.get(index);
    }

    public ListRemoveAction(int index, boolean last, Object removedElementInView) {
        this.index = index;
        this.last = last;
        this.removedElementInView = removedElementInView;
    }

    @Override
    public void doAction(C list, UpdateContext context, ViewToEntityMapper mapper, CollectionRemoveListener removeListener) {
        Object removeElement = list.remove(this.index);
        if (removeListener != null && removeElement != null) {
            removeListener.onCollectionRemove(context, this.removedElementInView);
        }
    }

    @Override
    public void undo(C collection, Collection<?> removedObjects, Collection<?> addedObjects) {
        collection.add(this.index, (Object)this.removedElementInView);
    }

    @Override
    public boolean containsObject(C collection, Object o) {
        return collection.size() > this.index && collection.get(this.index) == o;
    }

    @Override
    public Collection<Object> getAddedObjects() {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedObjects() {
        return Collections.singleton(this.removedElementInView);
    }

    @Override
    public Collection<Object> getAddedObjects(C collection) {
        return Collections.emptyList();
    }

    @Override
    public Collection<Object> getRemovedObjects(C collection) {
        return Collections.singleton(collection.get(this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getInsertedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getAppendedObjectEntries() {
        return Collections.emptyList();
    }

    @Override
    public List<Map.Entry<Object, Integer>> getRemovedObjectEntries() {
        if (this.last) {
            return Collections.emptyList();
        }
        return Collections.singletonList(new AbstractMap.SimpleEntry<Object, Integer>(this.removedElementInView, this.index));
    }

    @Override
    public List<Map.Entry<Object, Integer>> getTrimmedObjectEntries() {
        if (this.last) {
            return Collections.singletonList(new AbstractMap.SimpleEntry<Object, Integer>(this.removedElementInView, this.index));
        }
        return Collections.emptyList();
    }

    @Override
    public CollectionAction<C> replaceObject(Object oldElem, Object elem) {
        if (oldElem != this.removedElementInView) {
            return this;
        }
        return new ListRemoveAction<C, E>(this.index, this.last, elem);
    }

    @Override
    public CollectionAction<C> replaceObjects(Map<Object, Object> objectMapping) {
        if (objectMapping == null) {
            return this;
        }
        Object newElement = objectMapping.get(this.removedElementInView);
        if (newElement == null) {
            return this;
        }
        return new ListRemoveAction<C, E>(this.index, this.last, newElement);
    }

    @Override
    public void addAction(RecordingCollection<?, ?> recordingCollection, List<CollectionAction<C>> actions) {
        actions.add(this);
    }
}

