/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl.change;

import com.blazebit.persistence.view.change.ChangeModel;
import com.blazebit.persistence.view.change.MapChangeModel;
import com.blazebit.persistence.view.change.PluralChangeModel;
import com.blazebit.persistence.view.change.SingularChangeModel;
import com.blazebit.persistence.view.impl.change.AbstractChangeModel;
import com.blazebit.persistence.view.impl.change.AbstractPluralChangeModel;
import com.blazebit.persistence.view.impl.change.DirtyChecker;
import com.blazebit.persistence.view.impl.change.MapDirtyChecker;
import com.blazebit.persistence.view.impl.collection.RecordingMap;
import com.blazebit.persistence.view.impl.metamodel.AbstractMethodAttribute;
import com.blazebit.persistence.view.impl.metamodel.BasicTypeImpl;
import com.blazebit.persistence.view.impl.metamodel.ManagedViewTypeImplementor;
import com.blazebit.persistence.view.impl.type.TypedValue;
import com.blazebit.persistence.view.metamodel.Attribute;
import com.blazebit.persistence.view.metamodel.MapAttribute;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.MethodMapAttribute;
import com.blazebit.persistence.view.metamodel.MethodPluralAttribute;
import com.blazebit.persistence.view.metamodel.MethodSingularAttribute;
import com.blazebit.persistence.view.metamodel.PluralAttribute;
import com.blazebit.persistence.view.metamodel.SingularAttribute;
import com.blazebit.persistence.view.spi.type.BasicUserType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMapChangeModel<K, V>
extends AbstractPluralChangeModel<Map<K, V>, V, MapDirtyChecker<Map<K, V>, K, V>>
implements MapChangeModel<K, V> {
    private final ManagedViewTypeImplementor<K> keyType;
    private final BasicTypeImpl<K> keyBasicType;
    private final boolean isElementEntityType;

    public AbstractMapChangeModel(ManagedViewTypeImplementor<K> keyType, BasicTypeImpl<K> keyBasicType, ManagedViewTypeImplementor<V> type, BasicTypeImpl<V> basicType, Map<K, V> initial, Map<K, V> current, MapDirtyChecker<Map<K, V>, K, V> pluralDirtyChecker) {
        super(type, basicType, initial, current, pluralDirtyChecker);
        this.keyType = keyType;
        this.keyBasicType = keyBasicType;
        this.isElementEntityType = basicType != null && basicType.isJpaEntity();
    }

    public List<SingularChangeModel<V>> getElementChanges() {
        boolean mutable;
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return this.getRemovedElements();
        }
        if (this.initial == null || ((Map)this.initial).isEmpty()) {
            return this.getAddedElements();
        }
        boolean bl = mutable = this.basicType == null || this.basicType.getUserType().isMutable();
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set addedElements = ((RecordingMap)this.current).getAddedElements();
            Set removedElements = ((RecordingMap)this.current).getRemovedElements();
            ArrayList<SingularChangeModel<V>> elementChanges = new ArrayList<SingularChangeModel<V>>(addedElements.size() + removedElements.size());
            if (mutable) {
                for (Object value : ((Map)this.current).values()) {
                    if (addedElements.contains(value) || removedElements.contains(value)) continue;
                    this.addElementChangeModelIfDirty(elementChanges, value, value);
                }
            }
            this.addAddedElementChangeModels(elementChanges, addedElements);
            this.addRemovedElementChangeModels(elementChanges, removedElements);
            return elementChanges;
        }
        ArrayList<SingularChangeModel<V>> elementChanges = new ArrayList<SingularChangeModel<V>>(((Map)this.current).size());
        if (this.basicType != null) {
            BasicUserType userType = this.basicType.getUserType();
            if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                    if (((Map)this.current).containsKey(entry.getKey())) continue;
                    this.addElementChangeModel(elementChanges, entry.getValue(), null);
                }
                this.addModifiedElementChangeModels(elementChanges, ((Map)this.current).entrySet());
                return elementChanges;
            }
            TypedValue typedValue = new TypedValue(userType);
            if (this.keyBasicType != null) {
                Object value;
                Object key;
                TypedValue<K> typedKey = new TypedValue<K>(this.keyBasicType.getUserType());
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null) continue;
                    typedKey.setValue(key);
                    typedValue.setValue(value);
                    Object oldValue = ((Map)this.initial).get(typedKey);
                    if (!typedValue.equals(oldValue)) {
                        this.addElementChangeModel(elementChanges, oldValue, value);
                        continue;
                    }
                    this.addElementChangeModelIfDirty(elementChanges, oldValue, value);
                }
                for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                    Object newValue;
                    key = entry.getKey();
                    value = entry.getValue();
                    typedKey.setValue(key);
                    if (value == null) {
                        newValue = ((Map)this.current).get(typedKey);
                        if (newValue == null) continue;
                        this.addElementChangeModel(elementChanges, newValue, null);
                        continue;
                    }
                    newValue = ((Map)this.current).get(typedKey);
                    typedValue.setValue(value);
                    if (typedValue.equals(newValue)) continue;
                    this.addElementChangeModel(elementChanges, value, null);
                }
            } else {
                Object value;
                Object key;
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null) continue;
                    Object oldValue = ((Map)this.initial).get(key);
                    typedValue.setValue(value);
                    if (oldValue == null || !typedValue.equals(oldValue)) {
                        this.addElementChangeModel(elementChanges, oldValue, value);
                        continue;
                    }
                    this.addElementChangeModelIfDirty(elementChanges, oldValue, value);
                }
                for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                    Object newValue;
                    key = entry.getKey();
                    value = entry.getValue();
                    if (value == null) {
                        newValue = ((Map)this.current).get(key);
                        if (newValue == null) continue;
                        this.addElementChangeModel(elementChanges, newValue, null);
                        continue;
                    }
                    newValue = ((Map)this.current).get(key);
                    typedValue.setValue(value);
                    if (typedValue.equals(newValue)) continue;
                    this.addElementChangeModel(elementChanges, value, null);
                }
            }
        } else {
            Object value;
            Object key;
            for (Map.Entry entry : ((Map)this.current).entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value == null) continue;
                Object oldValue = ((Map)this.initial).get(key);
                if (!value.equals(oldValue)) {
                    this.addElementChangeModel(elementChanges, oldValue, value);
                    continue;
                }
                this.addElementChangeModelIfDirty(elementChanges, oldValue, value);
            }
            for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                Object newValue;
                key = entry.getKey();
                value = entry.getValue();
                if (value == null) {
                    newValue = ((Map)this.current).get(key);
                    if (newValue == null) continue;
                    this.addElementChangeModel(elementChanges, newValue, null);
                    continue;
                }
                newValue = ((Map)this.current).get(key);
                if (value.equals(newValue)) continue;
                this.addElementChangeModel(elementChanges, value, null);
            }
        }
        return elementChanges;
    }

    public List<SingularChangeModel<V>> getAddedElements() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set addedElements = ((RecordingMap)this.current).getAddedElements();
            ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>(addedElements.size());
            this.addAddedElementChangeModels(addedElementModels, addedElements);
            return addedElementModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>(((Map)this.current).size());
                this.addAddedElementChangeModels(addedElementModels, ((Map)this.current).values());
                return addedElementModels;
            }
            ArrayList<SingularChangeModel<V>> addedElementModels = new ArrayList<SingularChangeModel<V>>();
            if (this.basicType != null) {
                BasicUserType userType = this.basicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    for (Map.Entry entry : ((Map)this.current).entrySet()) {
                        if (((Map)this.initial).containsKey(entry.getKey())) continue;
                        this.addElementChangeModel(addedElementModels, null, entry.getValue());
                    }
                    return addedElementModels;
                }
                TypedValue typedValue = new TypedValue(userType);
                if (this.keyBasicType != null) {
                    TypedValue<K> typedKey = new TypedValue<K>(this.keyBasicType.getUserType());
                    for (Map.Entry entry : ((Map)this.current).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        typedValue.setValue(value);
                        typedKey.setValue(key);
                        Object oldValue = ((Map)this.initial).get(typedKey);
                        if (oldValue != null && typedValue.equals(oldValue)) continue;
                        this.addElementChangeModel(addedElementModels, oldValue, value);
                    }
                } else {
                    for (Map.Entry entry : ((Map)this.current).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        typedValue.setValue(value);
                        Object oldValue = ((Map)this.initial).get(key);
                        if (oldValue != null && typedValue.equals(oldValue)) continue;
                        this.addElementChangeModel(addedElementModels, oldValue, value);
                    }
                }
            } else {
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    Object oldValue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == null || value.equals(oldValue = ((Map)this.initial).get(key))) continue;
                    this.addElementChangeModel(addedElementModels, oldValue, value);
                }
            }
            return addedElementModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<V>> getRemovedElements() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            if (this.initial != this.current) {
                ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>(((Map)this.initial).size());
                this.addRemovedElementChangeModels(removedElementModels, ((Map)this.initial).values());
                return removedElementModels;
            }
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set removedElements = ((RecordingMap)this.current).getRemovedElements();
            ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>(removedElements.size());
            this.addRemovedElementChangeModels(removedElementModels, removedElements);
            return removedElementModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            ArrayList<SingularChangeModel<V>> removedElementModels = new ArrayList<SingularChangeModel<V>>();
            if (this.basicType != null) {
                BasicUserType userType = this.basicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                        if (((Map)this.current).containsKey(entry.getKey())) continue;
                        this.addElementChangeModel(removedElementModels, entry.getValue(), null);
                    }
                    return removedElementModels;
                }
                TypedValue typedValue = new TypedValue(userType);
                if (this.keyBasicType != null) {
                    TypedValue<K> typedKey = new TypedValue<K>(this.keyBasicType.getUserType());
                    for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                        Object newValue;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        typedKey.setValue(key);
                        if (value == null) {
                            newValue = ((Map)this.current).get(typedKey);
                            if (newValue == null) continue;
                            this.addElementChangeModel(removedElementModels, value, newValue);
                            continue;
                        }
                        newValue = ((Map)this.current).get(typedKey);
                        typedValue.setValue(value);
                        if (typedValue.equals(newValue)) continue;
                        this.addElementChangeModel(removedElementModels, value, newValue);
                    }
                } else {
                    for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                        Object newValue;
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) {
                            newValue = ((Map)this.current).get(key);
                            if (newValue == null) continue;
                            this.addElementChangeModel(removedElementModels, value, newValue);
                            continue;
                        }
                        newValue = ((Map)this.current).get(key);
                        typedValue.setValue(value);
                        if (typedValue.equals(newValue)) continue;
                        this.addElementChangeModel(removedElementModels, value, newValue);
                    }
                }
            } else {
                for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                    Object newValue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (value == null || value.equals(newValue = ((Map)this.current).get(key))) continue;
                    this.addElementChangeModel(removedElementModels, value, newValue);
                }
            }
            return removedElementModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<V>> getMutatedElements() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.basicType != null && !this.basicType.getUserType().isMutable()) {
            return Collections.emptyList();
        }
        ArrayList<SingularChangeModel<V>> elementModels = new ArrayList<SingularChangeModel<V>>();
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set removedElements = ((RecordingMap)this.current).getRemovedElements();
            Set addedElements = ((RecordingMap)this.current).getAddedElements();
            for (Object v : ((Map)this.current).values()) {
                if (removedElements.contains(v) || addedElements.contains(v)) continue;
                this.addElementChangeModelIfDirty(elementModels, v, v);
            }
        } else {
            if (this.initial == null || ((Map)this.initial).isEmpty()) {
                return Collections.emptyList();
            }
            HashMap valueMap = new HashMap(((Map)this.initial).size());
            for (Object v : ((Map)this.initial).values()) {
                valueMap.put(v, v);
            }
            if (this.basicType != null) {
                TypedValue typedValue = new TypedValue(this.basicType.getUserType());
                if (this.isElementEntityType) {
                    for (Object e : ((Map)this.current).values()) {
                        typedValue.setValue(e);
                        if (!valueMap.containsKey(typedValue)) continue;
                        this.addElementChangeModelIfDirty(elementModels, valueMap.get(typedValue), e);
                    }
                } else if (this.keyBasicType != null) {
                    TypedValue<K> typedKey = new TypedValue<K>(this.keyBasicType.getUserType());
                    for (Map.Entry entry : ((Map)this.current).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        typedKey.setValue(key);
                        typedValue.setValue(value);
                        if (valueMap.containsKey(typedValue)) {
                            this.addElementChangeModelIfDirty(elementModels, valueMap.get(typedValue), value);
                            continue;
                        }
                        if (!((Map)this.initial).containsKey(typedKey)) continue;
                        this.addElementChangeModelIfDirty(elementModels, ((Map)this.initial).get(typedKey), value);
                    }
                } else {
                    for (Map.Entry entry : ((Map)this.current).entrySet()) {
                        Object key = entry.getKey();
                        Object value = entry.getValue();
                        if (value == null) continue;
                        typedValue.setValue(value);
                        if (valueMap.containsKey(typedValue)) {
                            this.addElementChangeModelIfDirty(elementModels, valueMap.get(typedValue), value);
                            continue;
                        }
                        if (!((Map)this.initial).containsKey(key)) continue;
                        this.addElementChangeModelIfDirty(elementModels, ((Map)this.initial).get(key), value);
                    }
                }
            } else {
                for (Object o : ((Map)this.current).values()) {
                    if (!valueMap.containsKey(o)) continue;
                    this.addElementChangeModelIfDirty(elementModels, valueMap.get(o), o);
                }
            }
        }
        return elementModels;
    }

    public List<SingularChangeModel<K>> getKeyChanges() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return this.getRemovedKeys();
        }
        if (this.initial == null || ((Map)this.initial).isEmpty()) {
            return this.getAddedKeys();
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
            Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
            ArrayList<SingularChangeModel<K>> keyChanges = new ArrayList<SingularChangeModel<K>>(addedKeys.size() + removedKeys.size());
            if (this.keyBasicType != null) {
                BasicUserType<K> userType = this.keyBasicType.getUserType();
                if (userType.isMutable()) {
                    if (!userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                        for (Object o : ((Map)this.initial).keySet()) {
                            if (addedKeys.contains(o)) continue;
                            this.addKeyChangeModel(keyChanges, o, null);
                        }
                        this.addAddedKeyChangeModels(keyChanges, ((Map)this.current).keySet());
                        return keyChanges;
                    }
                    TypedValue<K> value = new TypedValue<K>(userType);
                    for (Object o : ((Map)this.current).keySet()) {
                        value.setValue(o);
                        if (addedKeys.contains(value) || removedKeys.contains(value)) continue;
                        this.addKeyChangeModel(keyChanges, o, o);
                    }
                }
            } else {
                for (Object o : ((Map)this.current).keySet()) {
                    if (addedKeys.contains(o) || removedKeys.contains(o)) continue;
                    this.addKeyChangeModel(keyChanges, o, o);
                }
            }
            this.addAddedKeyChangeModels(keyChanges, addedKeys);
            this.addRemovedKeyChangeModels(keyChanges, removedKeys);
            return keyChanges;
        }
        ArrayList<SingularChangeModel<K>> keyChanges = new ArrayList<SingularChangeModel<K>>(((Map)this.current).size());
        if (this.keyBasicType != null) {
            BasicUserType<K> userType = this.keyBasicType.getUserType();
            if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                this.addAddedKeyChangeModels(keyChanges, ((Map)this.current).keySet());
                this.addRemovedKeyChangeModels(keyChanges, ((Map)this.initial).keySet());
                return keyChanges;
            }
            TypedValue<K> value = new TypedValue<K>(userType);
            for (Object o : ((Map)this.current).keySet()) {
                value.setValue(o);
                if (((Map)this.initial).containsKey(value)) continue;
                this.addKeyChangeModel(keyChanges, null, o);
            }
            for (Object o : ((Map)this.initial).keySet()) {
                value.setValue(o);
                if (((Map)this.current).containsKey(value)) continue;
                this.addKeyChangeModel(keyChanges, o, null);
            }
        } else {
            for (Object key : ((Map)this.current).keySet()) {
                if (!((Map)this.initial).containsKey(key)) {
                    this.addKeyChangeModel(keyChanges, null, key);
                    continue;
                }
                this.addKeyChangeModelIfDirty(keyChanges, key, key);
            }
            for (Object key : ((Map)this.initial).keySet()) {
                if (((Map)this.current).containsKey(key)) continue;
                this.addKeyChangeModel(keyChanges, key, null);
            }
        }
        return keyChanges;
    }

    public List<SingularChangeModel<K>> getAddedKeys() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            BasicUserType<K> userType;
            Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
            ArrayList<SingularChangeModel<K>> addedKeyModels = new ArrayList<SingularChangeModel<K>>(addedKeys.size());
            if (this.keyBasicType != null && (userType = this.keyBasicType.getUserType()).isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
                for (Object o : ((Map)this.current).keySet()) {
                    if (removedKeys.contains(o)) continue;
                    this.addKeyChangeModel(addedKeyModels, null, o);
                }
                return addedKeyModels;
            }
            this.addAddedKeyChangeModels(addedKeyModels, addedKeys);
            return addedKeyModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                ArrayList<SingularChangeModel<K>> addedKeyModels = new ArrayList<SingularChangeModel<K>>(((Map)this.current).size());
                this.addAddedKeyChangeModels(addedKeyModels, ((Map)this.current).keySet());
                return addedKeyModels;
            }
            ArrayList<SingularChangeModel<K>> addedKeyModels = new ArrayList<SingularChangeModel<K>>();
            if (this.keyBasicType != null) {
                BasicUserType<K> userType = this.keyBasicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    this.addAddedKeyChangeModels(addedKeyModels, ((Map)this.current).keySet());
                    return addedKeyModels;
                }
                TypedValue<K> value = new TypedValue<K>(userType);
                for (Object o : ((Map)this.current).keySet()) {
                    value.setValue(o);
                    if (((Map)this.initial).containsKey(value)) continue;
                    this.addKeyChangeModel(addedKeyModels, null, o);
                }
            } else {
                for (Object key : ((Map)this.current).keySet()) {
                    if (((Map)this.initial).containsKey(key)) continue;
                    this.addKeyChangeModel(addedKeyModels, null, key);
                }
            }
            return addedKeyModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<K>> getRemovedKeys() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            if (this.initial != this.current) {
                ArrayList<SingularChangeModel<K>> removedKeyModels = new ArrayList<SingularChangeModel<K>>(((Map)this.initial).size());
                this.addRemovedKeyChangeModels(removedKeyModels, ((Map)this.initial).keySet());
                return removedKeyModels;
            }
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            BasicUserType<K> userType;
            Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
            ArrayList<SingularChangeModel<K>> removedKeyModels = new ArrayList<SingularChangeModel<K>>(removedKeys.size());
            if (this.keyBasicType != null && (userType = this.keyBasicType.getUserType()).isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
                for (Object o : ((Map)this.initial).keySet()) {
                    if (addedKeys.contains(o)) continue;
                    this.addKeyChangeModel(removedKeyModels, o, null);
                }
                return removedKeyModels;
            }
            this.addRemovedKeyChangeModels(removedKeyModels, removedKeys);
            return removedKeyModels;
        }
        if (this.initial != this.current) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            ArrayList<SingularChangeModel<K>> removedKeyModels = new ArrayList<SingularChangeModel<K>>();
            if (this.keyBasicType != null) {
                BasicUserType<K> userType = this.keyBasicType.getUserType();
                if (userType.isMutable() && !userType.supportsDirtyChecking() && !userType.supportsDeepCloning()) {
                    this.addRemovedKeyChangeModels(removedKeyModels, ((Map)this.initial).keySet());
                    return removedKeyModels;
                }
                TypedValue<K> value = new TypedValue<K>(userType);
                for (Object o : ((Map)this.initial).keySet()) {
                    value.setValue(o);
                    if (((Map)this.current).containsKey(value)) continue;
                    this.addKeyChangeModel(removedKeyModels, o, null);
                }
            } else {
                for (Object key : ((Map)this.initial).keySet()) {
                    if (((Map)this.current).containsKey(key)) continue;
                    this.addKeyChangeModel(removedKeyModels, key, null);
                }
            }
            return removedKeyModels;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<K>> getMutatedKeys() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.keyBasicType != null && (this.keyBasicType.getUserType().isMutable() || this.keyBasicType.getUserType().isMutable() && !this.keyBasicType.getUserType().supportsDirtyChecking())) {
            return Collections.emptyList();
        }
        ArrayList<SingularChangeModel<K>> keyModels = new ArrayList<SingularChangeModel<K>>();
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
            Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
            if (this.keyBasicType != null) {
                TypedValue<K> value = new TypedValue<K>(this.keyBasicType.getUserType());
                for (Object o : ((Map)this.current).keySet()) {
                    value.setValue(o);
                    if (removedKeys.contains(value) || addedKeys.contains(value)) continue;
                    this.addKeyChangeModelIfDirty(keyModels, o, o);
                }
            } else {
                for (Object o : ((Map)this.current).keySet()) {
                    if (removedKeys.contains(o) || addedKeys.contains(o)) continue;
                    this.addKeyChangeModelIfDirty(keyModels, o, o);
                }
            }
        } else {
            if (this.initial == null || ((Map)this.initial).isEmpty()) {
                return Collections.emptyList();
            }
            if (this.keyBasicType != null) {
                TypedValue<K> value = new TypedValue<K>(this.keyBasicType.getUserType());
                for (Object o : ((Map)this.current).keySet()) {
                    value.setValue(o);
                    if (!((Map)this.initial).containsKey(value)) continue;
                    this.addKeyChangeModelIfDirty(keyModels, o, o);
                }
            } else {
                for (Object o : ((Map)this.current).keySet()) {
                    if (!((Map)this.initial).containsKey(o)) continue;
                    this.addKeyChangeModelIfDirty(keyModels, o, o);
                }
            }
        }
        return keyModels;
    }

    public List<SingularChangeModel<?>> getObjectChanges() {
        Object value;
        Object key;
        ArrayList<SingularChangeModel<V>> objectChanges;
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return this.getRemovedObjects();
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            ArrayList<SingularChangeModel<V>> objectChanges2;
            Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
            Set addedElements = ((RecordingMap)this.current).getAddedElements();
            Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
            Set removedElements = ((RecordingMap)this.current).getRemovedElements();
            ArrayList<SingularChangeModel<V>> keyModels = objectChanges2 = new ArrayList<SingularChangeModel<V>>(addedKeys.size() + addedElements.size() + removedKeys.size() + removedElements.size());
            ArrayList<SingularChangeModel<V>> valueModels = objectChanges2;
            boolean keyMutable = this.keyBasicType == null || this.keyBasicType.getUserType().isMutable();
            boolean valueMutable = this.basicType == null || this.basicType.getUserType().isMutable();
            for (Map.Entry entry : ((Map)this.current).entrySet()) {
                Object key2 = entry.getKey();
                Object value2 = entry.getValue();
                if (keyMutable && !addedKeys.contains(key2) && !removedKeys.contains(key2)) {
                    this.addKeyChangeModel(keyModels, key2, key2);
                }
                if (!valueMutable || addedElements.contains(value2) || removedElements.contains(value2)) continue;
                this.addElementChangeModel(valueModels, value2, value2);
            }
            this.addAddedKeyChangeModels(keyModels, addedKeys);
            this.addRemovedKeyChangeModels(keyModels, removedKeys);
            this.addAddedElementChangeModels(valueModels, addedElements);
            this.addRemovedElementChangeModels(valueModels, removedElements);
            return objectChanges2;
        }
        ArrayList<SingularChangeModel<V>> keyModels = objectChanges = new ArrayList<SingularChangeModel<V>>(((Map)this.current).size());
        ArrayList<SingularChangeModel<V>> valueModels = objectChanges;
        boolean keyMutable = this.keyBasicType == null || this.keyBasicType.getUserType().isMutable();
        boolean valueMutable = this.basicType == null || this.basicType.getUserType().isMutable();
        for (Map.Entry entry : ((Map)this.current).entrySet()) {
            key = entry.getKey();
            value = entry.getValue();
            if (!((Map)this.initial).containsKey(key)) {
                this.addKeyChangeModel(keyModels, null, key);
            } else if (keyMutable) {
                this.addKeyChangeModelIfDirty(keyModels, key, key);
            }
            if (value == null) continue;
            Object oldValue = ((Map)this.initial).get(key);
            if (!value.equals(oldValue)) {
                this.addElementChangeModel(valueModels, oldValue, value);
                continue;
            }
            if (!valueMutable) continue;
            this.addElementChangeModelIfDirty(valueModels, oldValue, value);
        }
        for (Map.Entry entry : ((Map)this.initial).entrySet()) {
            Object newValue;
            key = entry.getKey();
            value = entry.getValue();
            if (!((Map)this.current).containsKey(key)) {
                this.addKeyChangeModel(keyModels, key, null);
            }
            if (value == null) {
                newValue = ((Map)this.current).get(key);
                if (newValue == null) continue;
                this.addElementChangeModel(valueModels, value, newValue);
                continue;
            }
            newValue = ((Map)this.current).get(key);
            if (value.equals(newValue)) continue;
            this.addElementChangeModel(valueModels, value, newValue);
        }
        return objectChanges;
    }

    public List<SingularChangeModel<?>> getAddedObjects() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            return Collections.emptyList();
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            ArrayList objectChanges;
            Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
            Set addedElements = ((RecordingMap)this.current).getAddedElements();
            ArrayList keyModels = objectChanges = new ArrayList(addedKeys.size() + addedElements.size());
            ArrayList valueModels = objectChanges;
            this.addAddedKeyChangeModels(keyModels, addedKeys);
            this.addAddedElementChangeModels(valueModels, addedElements);
            return objectChanges;
        }
        if (this.initial != this.current) {
            ArrayList<SingularChangeModel<V>> objectChanges;
            ArrayList<SingularChangeModel<V>> keyModels = objectChanges = new ArrayList<SingularChangeModel<V>>(((Map)this.current).size());
            ArrayList<SingularChangeModel<V>> valueModels = objectChanges;
            if (this.initial == null) {
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    this.addKeyChangeModel(keyModels, null, entry.getKey());
                    this.addElementChangeModel(valueModels, null, entry.getValue());
                }
            } else {
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    Object oldValue;
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!((Map)this.initial).containsKey(key)) {
                        this.addKeyChangeModel(keyModels, null, key);
                    }
                    if (value == null || value.equals(oldValue = ((Map)this.initial).get(key))) continue;
                    this.addElementChangeModel(valueModels, oldValue, value);
                }
            }
            return objectChanges;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<?>> getRemovedObjects() {
        if (this.current == null || ((Map)this.current).isEmpty()) {
            if (this.initial == null) {
                return Collections.emptyList();
            }
            if (this.initial != this.current) {
                ArrayList<SingularChangeModel<V>> removedModels;
                ArrayList<SingularChangeModel<V>> keyModels = removedModels = new ArrayList<SingularChangeModel<V>>(((Map)this.initial).size());
                ArrayList<SingularChangeModel<V>> valueModels = removedModels;
                for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                    this.addKeyChangeModel(keyModels, entry.getKey(), null);
                    this.addElementChangeModel(valueModels, entry.getValue(), null);
                }
                return removedModels;
            }
        }
        if (this.initial == this.current && this.current instanceof RecordingMap) {
            ArrayList objectChanges;
            Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
            Set removedElements = ((RecordingMap)this.current).getRemovedElements();
            ArrayList keyModels = objectChanges = new ArrayList(removedKeys.size() + removedElements.size());
            ArrayList valueModels = objectChanges;
            this.addRemovedKeyChangeModels(keyModels, removedKeys);
            this.addRemovedElementChangeModels(valueModels, removedElements);
            return objectChanges;
        }
        if (this.initial != this.current) {
            ArrayList<SingularChangeModel<V>> objectChanges;
            if (this.initial == null) {
                return Collections.emptyList();
            }
            ArrayList<SingularChangeModel<V>> keyModels = objectChanges = new ArrayList<SingularChangeModel<V>>(((Map)this.current).size());
            ArrayList<SingularChangeModel<V>> valueModels = objectChanges;
            for (Map.Entry entry : ((Map)this.initial).entrySet()) {
                Object newValue;
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (!((Map)this.current).containsKey(key)) {
                    this.addKeyChangeModel(keyModels, key, null);
                }
                if (value == null || value.equals(newValue = ((Map)this.current).get(key))) continue;
                this.addElementChangeModel(valueModels, value, newValue);
            }
            return objectChanges;
        }
        return Collections.emptyList();
    }

    public List<SingularChangeModel<?>> getMutatedObjects() {
        ArrayList<SingularChangeModel<V>> models;
        block9: {
            ArrayList<SingularChangeModel<V>> valueModels;
            ArrayList<SingularChangeModel<V>> keyModels;
            block8: {
                if (this.current == null || ((Map)this.current).isEmpty()) {
                    return Collections.emptyList();
                }
                keyModels = models = new ArrayList<SingularChangeModel<V>>();
                valueModels = models;
                if (this.initial != this.current || !(this.current instanceof RecordingMap)) break block8;
                Set removedKeys = ((RecordingMap)this.current).getRemovedKeys();
                Set addedKeys = ((RecordingMap)this.current).getAddedKeys();
                Set removedElements = ((RecordingMap)this.current).getRemovedElements();
                Set addedElements = ((RecordingMap)this.current).getAddedElements();
                for (Map.Entry entry : ((Map)this.current).entrySet()) {
                    Object key = entry.getKey();
                    Object value = entry.getValue();
                    if (!removedKeys.contains(key) && !addedKeys.contains(key)) {
                        this.addKeyChangeModelIfDirty(keyModels, key, key);
                    }
                    if (removedElements.contains(value) || addedElements.contains(value)) continue;
                    this.addElementChangeModelIfDirty(valueModels, value, value);
                }
                break block9;
            }
            if (this.initial == null || ((Map)this.initial).isEmpty()) {
                return Collections.emptyList();
            }
            HashMap valueMap = new HashMap(((Map)this.initial).size());
            for (Object v : ((Map)this.initial).values()) {
                valueMap.put(v, v);
            }
            if (this.basicType == null) break block9;
            TypedValue typedValue = new TypedValue(this.basicType.getUserType());
            for (Map.Entry entry : ((Map)this.current).entrySet()) {
                Object key = entry.getKey();
                Object value = entry.getValue();
                if (((Map)this.initial).containsKey(key)) {
                    this.addKeyChangeModelIfDirty(keyModels, key, key);
                }
                if (value == null) continue;
                typedValue.setValue(value);
                if (valueMap.containsKey(typedValue)) {
                    this.addElementChangeModelIfDirty(valueModels, valueMap.get(typedValue), value);
                    continue;
                }
                if (!((Map)this.initial).containsKey(key)) continue;
                this.addElementChangeModelIfDirty(valueModels, ((Map)this.initial).get(key), value);
            }
        }
        return models;
    }

    private void addAddedElementChangeModels(List<SingularChangeModel<V>> elementModels, Collection<V> elements) {
        for (V o : elements) {
            this.addElementChangeModel(elementModels, null, o);
        }
    }

    private void addRemovedElementChangeModels(List<SingularChangeModel<V>> elementModels, Collection<V> elements) {
        for (V o : elements) {
            this.addElementChangeModel(elementModels, o, null);
        }
    }

    private void addModifiedElementChangeModels(List<SingularChangeModel<V>> elementModels, Set<Map.Entry<K, V>> entries) {
        for (Map.Entry<K, V> entry : entries) {
            this.addElementChangeModel(elementModels, ((Map)this.initial).get(entry.getKey()), entry.getValue());
        }
    }

    private void addElementChangeModel(List<SingularChangeModel<V>> elementModels, V initial, V current) {
        DirtyChecker<V> dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(current != null ? current : initial);
        AbstractChangeModel<V, V> elementChangeModel = this.getObjectChangeModel(this.type == null ? this.basicType : this.type, initial, current, dirtyChecker);
        elementModels.add((SingularChangeModel)elementChangeModel);
    }

    private void addElementChangeModelIfDirty(List<SingularChangeModel<V>> elementModels, V initial, V current) {
        DirtyChecker<V> dirtyChecker;
        AbstractChangeModel<V, V> elementChangeModel = this.getObjectChangeModel(this.type == null ? this.basicType : this.type, initial, current, dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(current != null ? current : initial));
        if (elementChangeModel.isDirty()) {
            elementModels.add((SingularChangeModel)elementChangeModel);
        }
    }

    private void addAddedKeyChangeModels(List<SingularChangeModel<K>> elementModels, Collection<K> elements) {
        for (K o : elements) {
            this.addKeyChangeModel(elementModels, null, o);
        }
    }

    private void addRemovedKeyChangeModels(List<SingularChangeModel<K>> elementModels, Collection<K> elements) {
        for (K o : elements) {
            this.addKeyChangeModel(elementModels, o, null);
        }
    }

    private void addKeyChangeModel(List<SingularChangeModel<K>> elementModels, K initial, K o) {
        DirtyChecker<K> dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o);
        AbstractChangeModel<K, K> elementChangeModel = this.getObjectChangeModel(this.keyType == null ? this.keyBasicType : this.keyType, initial, o, dirtyChecker);
        elementModels.add((SingularChangeModel)elementChangeModel);
    }

    private void addKeyChangeModelIfDirty(List<SingularChangeModel<K>> elementModels, K initial, K o) {
        DirtyChecker<K> dirtyChecker;
        AbstractChangeModel<K, K> elementChangeModel = this.getObjectChangeModel(this.keyType == null ? this.keyBasicType : this.keyType, initial, o, dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o));
        if (elementChangeModel.isDirty()) {
            elementModels.add((SingularChangeModel)elementChangeModel);
        }
    }

    public boolean isDirty(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : ((Map)this.current).values()) {
            DirtyChecker dirtyChecker;
            if (!this.isDirty(this.type, o, o, dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isChanged(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : ((Map)this.current).values()) {
            DirtyChecker dirtyChecker;
            if (!this.isChanged(this.type, o, o, dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyDirty(String attributePath) {
        if (this.keyType == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection key basic type " + this.keyBasicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : ((Map)this.current).keySet()) {
            DirtyChecker keyDirtyChecker;
            if (!this.isDirty(this.keyType, o, o, keyDirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public boolean isKeyChanged(String attributePath) {
        if (this.keyType == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection key basic type " + this.keyBasicType + " of the path: " + attributePath);
        }
        if (this.current == null) {
            return false;
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return false;
        }
        for (Object o : ((Map)this.current).keySet()) {
            DirtyChecker keyDirtyChecker;
            if (!this.isChanged(this.keyType, o, o, keyDirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o), attributePath)) continue;
            return true;
        }
        return false;
    }

    public <X> List<SingularChangeModel<X>> keyGet(SingularAttribute<K, X> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    public <E, C extends Collection<E>> List<PluralChangeModel<C, E>> keyGet(PluralAttribute<K, C, E> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    public <K1, V1> List<MapChangeModel<K1, V1>> keyGet(MapAttribute<K, K1, V1> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    public <X> List<SingularChangeModel<X>> keyGet(MethodSingularAttribute<K, X> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    public <E, C extends Collection<E>> List<PluralChangeModel<C, E>> keyGet(MethodPluralAttribute<K, C, E> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    public <K1, V1> List<MapChangeModel<K1, V1>> keyGet(MethodMapAttribute<K, K1, V1> attribute) {
        return this.keyGetAll(this.getMutableKeyAttribute((Attribute<?, ?>)attribute));
    }

    protected final AbstractMethodAttribute<?, ?> getMutableKeyAttribute(Attribute<?, ?> attribute) {
        AbstractMethodAttribute methodAttribute;
        if (!(attribute instanceof MethodAttribute) || (methodAttribute = (AbstractMethodAttribute)attribute).getDirtyStateIndex() == -1) {
            throw new IllegalArgumentException("Invalid attribute that is not mutable: " + attribute);
        }
        if (attribute.getDeclaringType() != this.keyType) {
            throw new IllegalArgumentException("Invalid attribute that is not declared by the expected type: " + this.keyType + " but declared by: " + attribute.getDeclaringType());
        }
        return methodAttribute;
    }

    public <X> List<? extends ChangeModel<X>> get(String attributePath) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        ArrayList models = new ArrayList(((Map)this.current).size());
        for (Object o : ((Map)this.current).values()) {
            DirtyChecker dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
            models.addAll(this.getAll(this.type, o, dirtyChecker, attributePath));
        }
        return models;
    }

    public <X> List<? extends ChangeModel<X>> keyGet(String attributePath) {
        if (this.keyType == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection key basic type " + this.keyBasicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        ArrayList models = new ArrayList(((Map)this.current).size());
        for (Object o : ((Map)this.current).keySet()) {
            DirtyChecker keyDirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o);
            models.addAll(this.getAll(this.keyType, o, keyDirtyChecker, attributePath));
        }
        return models;
    }

    @Override
    protected <X> List<? extends ChangeModel<X>> getAll(AbstractMethodAttribute<?, ?> methodAttribute) {
        if (this.type == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection element basic type " + this.basicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap) {
            RecordingMap recordingMap = (RecordingMap)this.current;
            ArrayList models = new ArrayList(((Map)this.current).size());
            Set addedElements = recordingMap.getAddedElements();
            for (Object o : ((Map)this.current).values()) {
                DirtyChecker dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
                AbstractChangeModel<Object, Object> elementChangeModel = addedElements.contains(o) ? this.getObjectChangeModel(this.type, null, o, dirtyChecker) : this.getObjectChangeModel(this.type, o, o, dirtyChecker);
                models.add(elementChangeModel.get(methodAttribute));
            }
            return models;
        }
        ArrayList models = new ArrayList(((Map)this.current).size());
        HashSet initialElements = this.initial == null ? Collections.emptySet() : new HashSet(((Map)this.initial).values());
        for (Object o : ((Map)this.current).values()) {
            DirtyChecker dirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getElementDirtyChecker(o);
            AbstractChangeModel<Object, Object> elementChangeModel = initialElements.contains(o) ? this.getObjectChangeModel(this.type, o, o, dirtyChecker) : this.getObjectChangeModel(this.type, null, o, dirtyChecker);
            models.add(elementChangeModel.get(methodAttribute));
        }
        return models;
    }

    protected final <X> List<? extends ChangeModel<X>> keyGetAll(AbstractMethodAttribute<?, ?> methodAttribute) {
        if (this.keyType == null) {
            throw new IllegalArgumentException("Invalid dereference of the collection key basic type " + this.keyBasicType);
        }
        if (this.current == null) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap && !((RecordingMap)this.current).$$_isDirty()) {
            return Collections.emptyList();
        }
        if (this.current instanceof RecordingMap) {
            RecordingMap recordingMap = (RecordingMap)this.current;
            ArrayList models = new ArrayList(((Map)this.current).size());
            Set addedKeys = recordingMap.getAddedKeys();
            for (Object o : ((Map)this.current).keySet()) {
                DirtyChecker keyDirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o);
                AbstractChangeModel<Object, Object> elementChangeModel = addedKeys.contains(o) ? this.getObjectChangeModel(this.keyType, null, o, keyDirtyChecker) : this.getObjectChangeModel(this.keyType, o, o, keyDirtyChecker);
                models.add(elementChangeModel.get(methodAttribute));
            }
            return models;
        }
        ArrayList models = new ArrayList(((Map)this.current).size());
        Set initialKeys = this.initial == null ? Collections.emptySet() : ((Map)this.initial).keySet();
        for (Object o : ((Map)this.current).keySet()) {
            DirtyChecker keyDirtyChecker = ((MapDirtyChecker)this.pluralDirtyChecker).getKeyDirtyChecker(o);
            AbstractChangeModel<Object, Object> elementChangeModel = initialKeys.contains(o) ? this.getObjectChangeModel(this.keyType, o, o, keyDirtyChecker) : this.getObjectChangeModel(this.keyType, null, o, keyDirtyChecker);
            models.add(elementChangeModel.get(methodAttribute));
        }
        return models;
    }
}

