/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.impl;

import com.blazebit.persistence.JoinOnBuilder;
import com.blazebit.persistence.ParameterHolder;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.predicate.Predicate;
import com.blazebit.persistence.view.CorrelationBuilder;
import com.blazebit.persistence.view.CorrelationProvider;
import com.blazebit.persistence.view.CorrelationProviderFactory;
import com.blazebit.persistence.view.impl.PrefixingQueryGenerator;
import java.util.Map;
import java.util.Set;

public class StaticPathCorrelationProvider
implements CorrelationProvider,
CorrelationProviderFactory {
    private final String correlationPath;
    private final String correlationKeyAlias;
    private final int approximateExpressionSize;
    private final Predicate correlationPredicate;
    private final Set<String> rootAliases;

    public StaticPathCorrelationProvider(String correlationPath, Set<String> rootAliases) {
        this.correlationPath = correlationPath;
        this.correlationKeyAlias = null;
        this.approximateExpressionSize = -1;
        this.correlationPredicate = null;
        this.rootAliases = rootAliases;
    }

    public StaticPathCorrelationProvider(String correlationPath, String correlationKeyAlias, String correlationExpression, Predicate correlationPredicate, Set<String> rootAliases) {
        this.correlationPath = correlationPath;
        this.correlationKeyAlias = correlationKeyAlias;
        this.approximateExpressionSize = correlationExpression.length() * 2;
        this.correlationPredicate = correlationPredicate;
        this.rootAliases = rootAliases;
    }

    public boolean isParameterized() {
        return false;
    }

    public CorrelationProvider create(ParameterHolder<?> parameterHolder, Map<String, Object> optionalParameters) {
        return this;
    }

    public String getCorrelationPath() {
        return this.correlationPath;
    }

    public Predicate getCorrelationPredicate() {
        return this.correlationPredicate;
    }

    public void applyCorrelation(CorrelationBuilder correlationBuilder, String correlationExpression) {
        ExpressionFactory expressionFactory = (ExpressionFactory)correlationBuilder.getService(ExpressionFactory.class);
        String finalCorrelationPath = PrefixingQueryGenerator.prefix(expressionFactory, expressionFactory.createSimpleExpression(this.correlationPath, false), correlationExpression, this.rootAliases, false);
        if (this.correlationPredicate == null) {
            ((JoinOnBuilder)correlationBuilder.correlate(finalCorrelationPath).onExpression("1=1")).end();
        } else {
            String alias = correlationBuilder.getCorrelationAlias();
            PrefixingQueryGenerator prefixingQueryGenerator = new PrefixingQueryGenerator(expressionFactory, alias, correlationExpression, this.correlationKeyAlias, this.rootAliases, true, false);
            StringBuilder sb = new StringBuilder(this.approximateExpressionSize);
            prefixingQueryGenerator.setQueryBuffer(sb);
            this.correlationPredicate.accept((Expression.Visitor)prefixingQueryGenerator);
            String finalExpression = sb.toString();
            ((JoinOnBuilder)correlationBuilder.correlate(finalCorrelationPath).onExpression(finalExpression)).end();
        }
    }
}

