/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.view.metamodel;

import com.blazebit.persistence.view.metamodel.AttributePath;
import com.blazebit.persistence.view.metamodel.ManagedViewType;
import com.blazebit.persistence.view.metamodel.MethodAttribute;
import com.blazebit.persistence.view.metamodel.MethodMultiListAttribute;
import com.blazebit.persistence.view.metamodel.MethodMultiMapAttribute;
import com.blazebit.persistence.view.metamodel.MethodPluralAttribute;
import com.blazebit.persistence.view.metamodel.MethodSingularAttribute;
import com.blazebit.persistence.view.metamodel.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class AttributePaths {
    private AttributePaths() {
    }

    public static <X, E> AttributePath<X, E, E> of(String attributePath) {
        return new StringAttributePath(attributePath);
    }

    public static <X, E> AttributePath<X, E, E> of(MethodSingularAttribute<X, E> attribute) {
        return new TypedAttributePath(attribute);
    }

    public static <X, E> AttributePath<X, E, E> of(MethodPluralAttribute<X, ?, E> attribute) {
        return new TypedAttributePath(attribute);
    }

    public static <X, C extends Collection<E>, E> AttributePath<X, C, E> of(MethodMultiListAttribute<X, E, C> attribute) {
        return new TypedAttributePath(attribute);
    }

    public static <X, C extends Collection<E>, E> AttributePath<X, C, E> of(MethodMultiMapAttribute<X, ?, E, C> attribute) {
        return new TypedAttributePath(attribute);
    }

    private static String getAttributePathForNames(List<String> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append(attributes.get(0));
        for (int i = 1; i < attributes.size(); ++i) {
            sb.append('.').append(attributes.get(i));
        }
        return sb.toString();
    }

    private static String getAttributePathForAttributes(List<? extends MethodAttribute<?, ?>> attributes) {
        StringBuilder sb = new StringBuilder();
        sb.append(attributes.get(0).getName());
        for (int i = 1; i < attributes.size(); ++i) {
            sb.append('.').append(attributes.get(i).getName());
        }
        return sb.toString();
    }

    private static final class StringAttributePath<X, B, Y>
    implements AttributePath<X, B, Y> {
        private final List<String> attributes;

        private StringAttributePath(String attributePath) {
            List<String> attributes = Arrays.asList(attributePath.split("\\."));
            this.attributes = Collections.unmodifiableList(attributes);
        }

        private StringAttributePath(StringAttributePath<X, ?, ?> base, String attributePath) {
            String[] parts = attributePath.split("\\.");
            ArrayList<String> attributes = new ArrayList<String>(base.attributes.size() + parts.length);
            attributes.addAll(base.attributes);
            for (String part : parts) {
                attributes.add(part);
            }
            this.attributes = Collections.unmodifiableList(attributes);
        }

        private StringAttributePath(StringAttributePath<X, ?, ?> base, AttributePath<?, B, Y> sub) {
            List<String> attributeNames = sub.getAttributeNames();
            ArrayList<String> attributes = new ArrayList<String>(base.attributes.size() + attributeNames.size());
            attributes.addAll(base.attributes);
            attributes.addAll(attributeNames);
            this.attributes = Collections.unmodifiableList(attributes);
        }

        @Override
        public MethodAttribute<?, Y> resolve(ManagedViewType<X> baseType) {
            MethodAttribute<X, ?> lastAttribute = null;
            Type<Object> type = baseType;
            for (String part : this.attributes) {
                if (type instanceof ManagedViewType) {
                    lastAttribute = type.getAttribute(part);
                    if (lastAttribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForNames(this.attributes));
                    }
                    if (lastAttribute instanceof MethodSingularAttribute) {
                        type = ((MethodSingularAttribute)lastAttribute).getType();
                        continue;
                    }
                    type = ((MethodPluralAttribute)lastAttribute).getElementType();
                    continue;
                }
                throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForNames(this.attributes));
            }
            return lastAttribute;
        }

        @Override
        public List<MethodAttribute<?, ?>> resolveAll(ManagedViewType<X> baseType) {
            ArrayList list = new ArrayList(this.attributes.size());
            Type<Object> type = baseType;
            for (String part : this.attributes) {
                if (type instanceof ManagedViewType) {
                    MethodAttribute<X, ?> attribute = type.getAttribute(part);
                    if (attribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForNames(this.attributes));
                    }
                    list.add(attribute);
                    if (attribute instanceof MethodSingularAttribute) {
                        type = ((MethodSingularAttribute)attribute).getType();
                        continue;
                    }
                    type = ((MethodPluralAttribute)attribute).getElementType();
                    continue;
                }
                throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForNames(this.attributes));
            }
            return list;
        }

        @Override
        public List<String> getAttributeNames() {
            return this.attributes;
        }

        @Override
        public List<MethodAttribute<?, ?>> getAttributes() {
            throw new UnsupportedOperationException("String based attribute path can't provide attributes! Use resolveAll instead!");
        }

        @Override
        public <E> AttributePath<X, E, E> get(String attributePath) {
            return new StringAttributePath<X, B, Y>(this, attributePath);
        }

        @Override
        public <E, C extends Collection<E>> AttributePath<X, E, C> getMulti(String attributePath) {
            return new StringAttributePath<X, B, Y>(this, attributePath);
        }

        @Override
        public <E> AttributePath<X, E, E> get(MethodSingularAttribute<B, E> attribute) {
            return new StringAttributePath<X, B, Y>(this, attribute.getName());
        }

        @Override
        public <E> AttributePath<X, E, E> get(MethodPluralAttribute<B, ?, E> attribute) {
            return new StringAttributePath<X, B, Y>(this, attribute.getName());
        }

        @Override
        public <C extends Collection<E>, E> AttributePath<X, E, C> get(MethodMultiListAttribute<B, E, C> attribute) {
            return new StringAttributePath<X, B, Y>(this, attribute.getName());
        }

        @Override
        public <C extends Collection<E>, E> AttributePath<X, E, C> get(MethodMultiMapAttribute<B, ?, E, C> attribute) {
            return new StringAttributePath<X, B, Y>(this, attribute.getName());
        }

        @Override
        public <C, E> AttributePath<X, C, E> get(AttributePath<B, C, E> attributePath) {
            return new StringAttributePath<X, C, E>(this, attributePath);
        }

        @Override
        public String getPath() {
            return AttributePaths.getAttributePathForNames(this.attributes);
        }

        public String toString() {
            return AttributePaths.getAttributePathForNames(this.attributes);
        }
    }

    private static final class TypedAttributePath<X, B, Y>
    implements AttributePath<X, B, Y> {
        private final List<MethodAttribute<?, ?>> attributes;

        private TypedAttributePath(MethodAttribute<X, ?> attribute) {
            this.attributes = Collections.singletonList(attribute);
        }

        private TypedAttributePath(TypedAttributePath<X, ?, ?> base, String attributePath) {
            this(base, Arrays.asList(attributePath.split("\\.")));
        }

        private TypedAttributePath(TypedAttributePath<X, ?, ?> base, List<String> attributeNames) {
            int size = base.attributes.size();
            ArrayList attributes = new ArrayList(size + attributeNames.size());
            attributes.addAll(base.attributes);
            MethodAttribute<Object, ?> lastAttribute = base.attributes.get(size - 1);
            for (String part : attributeNames) {
                Type<Object> type = lastAttribute instanceof MethodSingularAttribute ? ((MethodSingularAttribute)lastAttribute).getType() : ((MethodPluralAttribute)lastAttribute).getElementType();
                if (type instanceof ManagedViewType) {
                    MethodAttribute attribute = ((ManagedViewType)type).getAttribute(part);
                    if (attribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while creating attribute path for: " + AttributePaths.getAttributePathForNames(attributeNames));
                    }
                    lastAttribute = attribute;
                    attributes.add(lastAttribute);
                    continue;
                }
                throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' for attribute path: " + AttributePaths.getAttributePathForNames(attributeNames));
            }
            this.attributes = Collections.unmodifiableList(attributes);
        }

        private TypedAttributePath(TypedAttributePath<X, ?, ?> base, List<? extends MethodAttribute<?, ?>> subAttributes, boolean noop) {
            int size = base.attributes.size();
            MethodAttribute<Object, ?> lastAttribute = base.attributes.get(size - 1);
            ArrayList attributes = new ArrayList(size + 1);
            attributes.addAll(base.attributes);
            for (int i = 0; i < subAttributes.size(); ++i) {
                MethodAttribute attribute;
                MethodAttribute<?, ?> subAttribute = subAttributes.get(i);
                String part = subAttribute.getName();
                Type<Object> type = lastAttribute instanceof MethodSingularAttribute ? ((MethodSingularAttribute)lastAttribute).getType() : ((MethodPluralAttribute)lastAttribute).getElementType();
                if (type instanceof ManagedViewType) {
                    attribute = ((ManagedViewType)type).getAttribute(part);
                    if (attribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while creating attribute path for: " + AttributePaths.getAttributePathForAttributes(subAttributes));
                    }
                    if (subAttribute == attribute) {
                        attributes.addAll(subAttributes.subList(i, subAttributes.size()));
                        break;
                    }
                } else {
                    throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' for attribute path: " + AttributePaths.getAttributePathForAttributes(subAttributes));
                }
                lastAttribute = attribute;
                attributes.add(lastAttribute);
            }
            this.attributes = Collections.unmodifiableList(attributes);
        }

        @Override
        public MethodAttribute<?, Y> resolve(ManagedViewType<X> baseType) {
            if (baseType == this.attributes.get(0).getDeclaringType()) {
                return this.attributes.get(this.attributes.size() - 1);
            }
            MethodAttribute<X, ?> lastAttribute = null;
            Type<Object> type = baseType;
            for (MethodAttribute<?, ?> attribute : this.attributes) {
                String part = attribute.getName();
                if (type instanceof ManagedViewType) {
                    lastAttribute = type.getAttribute(part);
                    if (lastAttribute == attribute) {
                        return this.attributes.get(this.attributes.size() - 1);
                    }
                    if (lastAttribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForAttributes(this.attributes));
                    }
                    if (lastAttribute instanceof MethodSingularAttribute) {
                        type = ((MethodSingularAttribute)lastAttribute).getType();
                        continue;
                    }
                    type = ((MethodPluralAttribute)lastAttribute).getElementType();
                    continue;
                }
                throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForAttributes(this.attributes));
            }
            return lastAttribute;
        }

        @Override
        public List<MethodAttribute<?, ?>> resolveAll(ManagedViewType<X> baseType) {
            if (baseType == this.attributes.get(0).getDeclaringType()) {
                return this.attributes;
            }
            ArrayList list = new ArrayList(this.attributes.size());
            Type<Object> type = baseType;
            for (int i = 0; i < this.attributes.size(); ++i) {
                MethodAttribute<?, ?> attribute = this.attributes.get(i);
                String part = attribute.getName();
                if (type instanceof ManagedViewType) {
                    MethodAttribute<X, ?> lastAttribute = type.getAttribute(part);
                    if (lastAttribute == null) {
                        throw new IllegalArgumentException("Error de-referencing attribute '" + part + "' because it does not exist on the type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForAttributes(this.attributes));
                    }
                    if (attribute == lastAttribute) {
                        list.addAll(this.attributes.subList(i, this.attributes.size()));
                        break;
                    }
                    list.add(lastAttribute);
                    if (lastAttribute instanceof MethodSingularAttribute) {
                        type = ((MethodSingularAttribute)lastAttribute).getType();
                        continue;
                    }
                    type = ((MethodPluralAttribute)lastAttribute).getElementType();
                    continue;
                }
                throw new IllegalArgumentException("Can not de-reference attribute '" + part + "' on non-managed type '" + type.getJavaType().getName() + "' while resolving attribute path: " + AttributePaths.getAttributePathForAttributes(this.attributes));
            }
            return list;
        }

        @Override
        public List<String> getAttributeNames() {
            ArrayList<String> attributeNames = new ArrayList<String>(this.attributes.size());
            for (MethodAttribute<?, ?> attribute : this.attributes) {
                attributeNames.add(attribute.getName());
            }
            return attributeNames;
        }

        @Override
        public List<MethodAttribute<?, ?>> getAttributes() {
            return this.attributes;
        }

        @Override
        public <E> AttributePath<X, E, E> get(String attributePath) {
            return new TypedAttributePath<X, B, Y>(this, attributePath);
        }

        @Override
        public <E, C extends Collection<E>> AttributePath<X, E, C> getMulti(String attributePath) {
            return new TypedAttributePath<X, B, Y>(this, attributePath);
        }

        @Override
        public <E> AttributePath<X, E, E> get(MethodSingularAttribute<B, E> attribute) {
            return new TypedAttributePath<X, B, Y>(this, Collections.singletonList(attribute), false);
        }

        @Override
        public <E> AttributePath<X, E, E> get(MethodPluralAttribute<B, ?, E> attribute) {
            return new TypedAttributePath<X, B, Y>(this, Collections.singletonList(attribute), false);
        }

        @Override
        public <C extends Collection<E>, E> AttributePath<X, E, C> get(MethodMultiListAttribute<B, E, C> attribute) {
            return new TypedAttributePath<X, B, Y>(this, Collections.singletonList(attribute), false);
        }

        @Override
        public <C extends Collection<E>, E> AttributePath<X, E, C> get(MethodMultiMapAttribute<B, ?, E, C> attribute) {
            return new TypedAttributePath<X, B, Y>(this, Collections.singletonList(attribute), false);
        }

        @Override
        public <C, E> AttributePath<X, C, E> get(AttributePath<B, C, E> attributePath) {
            if (attributePath instanceof TypedAttributePath) {
                return new TypedAttributePath<X, B, Y>(this, ((TypedAttributePath)attributePath).attributes, false);
            }
            return new TypedAttributePath<X, B, Y>(this, attributePath.getAttributeNames());
        }

        @Override
        public String getPath() {
            return AttributePaths.getAttributePathForAttributes(this.attributes);
        }

        public String toString() {
            return AttributePaths.getAttributePathForAttributes(this.attributes);
        }
    }
}

