/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.util;

import com.blazebit.persistence.parser.util.TypeConverter;
import com.blazebit.persistence.parser.util.TypeUtils;
import java.sql.Time;
import java.time.LocalTime;
import java.util.Calendar;
import java.util.Date;

public class LocalTimeTypeConverter
extends TypeUtils.AbstractLiteralFunctionTypeConverter<LocalTime> {
    public static final TypeConverter<?> INSTANCE = new LocalTimeTypeConverter();
    private static final long serialVersionUID = 1L;

    private LocalTimeTypeConverter() {
        super("literal_local_time");
    }

    @Override
    public LocalTime convert(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return LocalTime.of(date.getHours(), date.getMinutes(), date.getSeconds());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return LocalTime.of(calendar.get(11), calendar.get(12), calendar.get(13));
        }
        if (value instanceof String) {
            return Time.valueOf((String)value).toLocalTime();
        }
        throw LocalTimeTypeConverter.unknownConversion(value, LocalTime.class);
    }

    @Override
    public String toString(LocalTime value) {
        return TypeUtils.jdbcTime(value.getHour(), value.getMinute(), value.getSecond());
    }

    @Override
    public void appendTo(LocalTime value, StringBuilder stringBuilder) {
        TypeUtils.appendJdbcTime(stringBuilder, value.getHour(), value.getMinute(), value.getSecond());
    }
}

