/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.parser.expression;

import com.blazebit.persistence.parser.expression.AbstractNumericExpression;
import com.blazebit.persistence.parser.expression.ArithmeticOperator;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionCopyContext;
import com.blazebit.persistence.parser.expression.NumericExpression;
import com.blazebit.persistence.parser.expression.NumericType;

public class ArithmeticExpression
extends AbstractNumericExpression {
    private Expression left;
    private Expression right;
    private final ArithmeticOperator op;

    public ArithmeticExpression(Expression left, Expression right, ArithmeticOperator op) {
        super(ArithmeticExpression.resolveType(left, right));
        this.left = left;
        this.right = right;
        this.op = op;
    }

    public Expression getLeft() {
        return this.left;
    }

    public void setLeft(Expression left) {
        this.left = left;
    }

    public Expression getRight() {
        return this.right;
    }

    public void setRight(Expression right) {
        this.right = right;
    }

    public ArithmeticOperator getOp() {
        return this.op;
    }

    private static NumericType resolveType(Expression left, Expression right) {
        if (!(left instanceof NumericExpression) || !(right instanceof NumericExpression)) {
            return null;
        }
        NumericExpression numericLeft = (NumericExpression)left;
        NumericExpression numericRight = (NumericExpression)right;
        if (numericLeft == null || numericLeft.getNumericType() == null) {
            return numericRight == null ? null : numericRight.getNumericType();
        }
        if (numericRight == null || numericRight.getNumericType() == null) {
            return numericLeft.getNumericType();
        }
        return NumericType.values()[Math.max(numericLeft.getNumericType().ordinal(), numericRight.getNumericType().ordinal())];
    }

    @Override
    public Expression copy(ExpressionCopyContext copyContext) {
        return new ArithmeticExpression(this.left.copy(copyContext), this.right.copy(copyContext), this.op);
    }

    @Override
    public void accept(Expression.Visitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T accept(Expression.ResultVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArithmeticExpression)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ArithmeticExpression that = (ArithmeticExpression)o;
        if (this.left != null ? !this.left.equals(that.left) : that.left != null) {
            return false;
        }
        if (this.right != null ? !this.right.equals(that.right) : that.right != null) {
            return false;
        }
        return this.op == that.op;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.left != null ? this.left.hashCode() : 0);
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        result = 31 * result + (this.op != null ? this.op.hashCode() : 0);
        return result;
    }
}

