/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.keyset;

import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.keyset.KeysetBuilderEndedListener;
import com.blazebit.persistence.impl.keyset.KeysetBuilderImpl;
import com.blazebit.persistence.impl.keyset.KeysetLink;
import com.blazebit.persistence.impl.keyset.KeysetMode;
import com.blazebit.persistence.impl.keyset.LazyKeysetLink;
import java.util.Map;

public class AbstractKeysetBuilderEndedListener
implements KeysetBuilderEndedListener {
    private KeysetBuilderImpl<?> currentBuilder;
    private KeysetLink keysetLink;

    public void verifyBuilderEnded() {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
    }

    public <T> KeysetBuilderImpl<T> startBuilder(KeysetBuilderImpl<T> builder) {
        if (this.currentBuilder != null) {
            throw new BuilderChainingException("There was an attempt to start a builder but a previous builder was not ended.");
        }
        this.currentBuilder = builder;
        return builder;
    }

    @Override
    public void onBuilderEnded(KeysetBuilderImpl<?> builder) {
        if (this.currentBuilder == null) {
            throw new BuilderChainingException("There was an attempt to end a builder that was not started or already closed.");
        }
        this.keysetLink = this.createLink(builder);
        this.currentBuilder = null;
    }

    private KeysetLink createLink(KeysetBuilderImpl<?> builder) {
        Map<String, Object> keysetValues = builder.getKeysetValues();
        KeysetMode mode = builder.getMode();
        return new LazyKeysetLink(keysetValues, mode);
    }

    public KeysetLink getKeysetLink() {
        return this.keysetLink;
    }

    public void setKeysetLink(KeysetLink keysetLink) {
        this.keysetLink = keysetLink;
    }
}

