/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.tostringjson;

import com.blazebit.persistence.impl.util.JpqlFunctionUtil;
import com.blazebit.persistence.impl.util.SqlUtils;
import com.blazebit.persistence.parser.JsonParser;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;

public abstract class AbstractToStringJsonFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "to_string_json";

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return String.class;
    }

    public void render(FunctionRenderContext context) {
        String[] fields;
        if (context.getArgumentsSize() < 2) {
            throw new RuntimeException("The to_string_json function needs at least two arguments <subquery>, <key1>, ..., <keyN>! args=" + context);
        }
        String subquery = context.getArgument(0);
        int fromIndex = SqlUtils.indexOfFrom(subquery, 1);
        String[] selectItemExpressions = SqlUtils.getSelectItemExpressions(subquery, SqlUtils.SELECT_FINDER.indexIn(subquery));
        if (selectItemExpressions.length < (fields = new String[context.getArgumentsSize() - 1]).length) {
            throw new RuntimeException("The to_string_json function <subquery> argument must have at least as many select items as keys are given! args=" + context);
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i] = JpqlFunctionUtil.unquoteSingleQuotes(context.getArgument(i + 1));
        }
        this.render(context, fields, selectItemExpressions, subquery, fromIndex);
    }

    public Object process(CharSequence result, String[] fields) {
        if (result == null) {
            return null;
        }
        return JsonParser.parseStringOnly((CharSequence)result, (String[])fields);
    }

    public abstract void render(FunctionRenderContext var1, String[] var2, String[] var3, String var4, int var5);
}

