/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.function.pageposition;

import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlFunction;
import com.blazebit.persistence.spi.TemplateRenderer;

public class PagePositionFunction
implements JpqlFunction {
    public static final String FUNCTION_NAME = "page_position";
    protected final TemplateRenderer renderer;

    public PagePositionFunction() {
        this.renderer = new TemplateRenderer("(select base1_.rownumber_ from (select " + this.getRownumFunction() + " as rownumber_, base_.* from ?1 base_) base1_ where ?2 = base1_.?3)");
    }

    public PagePositionFunction(String template) {
        this.renderer = new TemplateRenderer(template);
    }

    protected String getRownumFunction() {
        return "row_number() over ()";
    }

    public boolean hasArguments() {
        return true;
    }

    public boolean hasParenthesesIfNoArguments() {
        return true;
    }

    public Class<?> getReturnType(Class<?> firstArgumentType) {
        return Long.class;
    }

    public void render(FunctionRenderContext context) {
        String subqueryStart;
        if (context.getArgumentsSize() != 2) {
            throw new RuntimeException("The page position function needs exactly two arguments <base_query> and <entity_id>! args=" + context);
        }
        String subquery = context.getArgument(0);
        if (!this.startsWithIgnoreCase(subquery, subqueryStart = "(select ")) {
            throw new IllegalArgumentException("Expected a subquery as the second parameter but was: " + subquery);
        }
        int fromIndex = subquery.toLowerCase().indexOf(" from ");
        if (fromIndex < 1) {
            throw new IllegalArgumentException("Expected a subquery as the second parameter but was: " + subquery);
        }
        String id = subquery.substring(subqueryStart.length(), fromIndex);
        if (id.indexOf(44) > -1) {
            throw new IllegalArgumentException("Expected a subquery with a simple id but it was composite: " + subquery);
        }
        int dotIndex = id.indexOf(46);
        if (dotIndex < 0) {
            throw new IllegalArgumentException("Expected that the id is fully qualified but it isn't: " + id);
        }
        String idName = id.substring(dotIndex + 1);
        this.renderPagePosition(context, idName);
    }

    protected void renderPagePosition(FunctionRenderContext functionRenderContext, String idName) {
        this.renderer.start(functionRenderContext).addArgument(0).addArgument(1).addParameter(idName).build();
    }

    private boolean startsWithIgnoreCase(String s1, String s2) {
        return s1.regionMatches(true, 0, s2, 0, s2.length());
    }
}

