/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.predicate;

import com.blazebit.persistence.BetweenBuilder;
import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.ParameterManager;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.impl.builder.predicate.LeftHandsideSubqueryPredicateBuilder;
import com.blazebit.persistence.impl.builder.predicate.PredicateBuilderEndedListener;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import com.blazebit.persistence.parser.predicate.BetweenPredicate;
import com.blazebit.persistence.parser.util.TypeUtils;

public class BetweenBuilderImpl<T>
extends SubqueryBuilderListenerImpl<T>
implements BetweenBuilder<T>,
LeftHandsideSubqueryPredicateBuilder {
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private final ParameterManager parameterManager;
    private final ClauseType clauseType;
    private final PredicateBuilderEndedListener listener;
    private final Expression left;
    private final boolean negated;
    private Expression start;
    private final T result;
    private BetweenPredicate predicate;
    private SubqueryInitiator<?> subqueryStartMarker;

    public BetweenBuilderImpl(T result, Expression left, Expression start, ExpressionFactory expressionFactory, ParameterManager parameterManager, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ClauseType clauseType) {
        this(result, left, start, expressionFactory, parameterManager, listener, subqueryInitFactory, clauseType, false);
    }

    public BetweenBuilderImpl(T result, Expression left, Expression start, ExpressionFactory expressionFactory, ParameterManager parameterManager, PredicateBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ClauseType clauseType, boolean negated) {
        this.result = result;
        this.left = left;
        this.start = start;
        this.expressionFactory = expressionFactory;
        this.parameterManager = parameterManager;
        this.clauseType = clauseType;
        this.listener = listener;
        this.subqueryInitFactory = subqueryInitFactory;
        this.negated = negated;
    }

    public T and(Object end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        return this.chain(new BetweenPredicate(this.left, this.start, (Expression)this.parameterManager.addParameterExpression(end, this.clauseType, this.subqueryInitFactory.getQueryBuilder()), this.negated));
    }

    public T andLiteral(Object end) {
        if (end == null) {
            throw new NullPointerException("end");
        }
        String literal = TypeUtils.asLiteral((Object)end, (EntityMetamodel)this.subqueryInitFactory.getQueryBuilder().getMetamodel());
        if (literal == null) {
            return this.and(end);
        }
        return this.chain(new BetweenPredicate(this.left, this.start, this.expressionFactory.createInItemExpression(literal), this.negated));
    }

    public T andExpression(String end) {
        return this.chain(new BetweenPredicate(this.left, this.start, this.expressionFactory.createSimpleExpression(end), this.negated));
    }

    public SubqueryInitiator<T> andSubqery() {
        this.verifySubqueryBuilderEnded();
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this.result, this, false, this.clauseType));
    }

    public SubqueryInitiator<T> andSubqery(String subqueryAlias, String expression) {
        this.verifySubqueryBuilderEnded();
        SuperExpressionSubqueryBuilderListener superExpressionSubqueryListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression)){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                BetweenBuilderImpl.this.predicate = new BetweenPredicate(BetweenBuilderImpl.this.left, BetweenBuilderImpl.this.start, this.superExpression, BetweenBuilderImpl.this.negated);
                BetweenBuilderImpl.this.listener.onBuilderEnded(BetweenBuilderImpl.this);
            }
        };
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this.result, superExpressionSubqueryListener, false, this.clauseType));
    }

    public SubqueryBuilder<T> andSubqery(FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        return this.startSubqueryBuilder(this.subqueryInitFactory.createSubqueryBuilder(this.result, this, false, criteriaBuilder, this.clauseType));
    }

    public SubqueryBuilder<T> andSubqery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        SuperExpressionSubqueryBuilderListener superExpressionSubqueryListener = new SuperExpressionSubqueryBuilderListener<T>(subqueryAlias, this.expressionFactory.createSimpleExpression(expression)){

            @Override
            public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
                super.onBuilderEnded(builder);
                BetweenBuilderImpl.this.predicate = new BetweenPredicate(BetweenBuilderImpl.this.left, BetweenBuilderImpl.this.start, this.superExpression, BetweenBuilderImpl.this.negated);
                BetweenBuilderImpl.this.listener.onBuilderEnded(BetweenBuilderImpl.this);
            }
        };
        return this.startSubqueryBuilder(this.subqueryInitFactory.createSubqueryBuilder(this.result, superExpressionSubqueryListener, false, criteriaBuilder, this.clauseType));
    }

    public MultipleSubqueryInitiator<T> andSubqueries(String expression) {
        return this.startMultipleSubqueryInitiator(this.expressionFactory.createSimpleExpression(expression));
    }

    private MultipleSubqueryInitiator<T> startMultipleSubqueryInitiator(Expression expression) {
        this.verifySubqueryBuilderEnded();
        MultipleSubqueryInitiatorImpl<T> initiator = new MultipleSubqueryInitiatorImpl<T>(this.result, expression, new ExpressionBuilderEndedListener(){

            @Override
            public void onBuilderEnded(ExpressionBuilder builder) {
                BetweenBuilderImpl.this.predicate = new BetweenPredicate(BetweenBuilderImpl.this.left, BetweenBuilderImpl.this.start, builder.getExpression(), BetweenBuilderImpl.this.negated);
                BetweenBuilderImpl.this.listener.onBuilderEnded(BetweenBuilderImpl.this);
            }
        }, this.subqueryInitFactory, this.clauseType);
        return initiator;
    }

    public BetweenPredicate getPredicate() {
        return this.predicate;
    }

    @Override
    public void setLeftExpression(Expression start) {
        this.start = start;
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<T> builder) {
        super.onBuilderEnded(builder);
        this.subqueryStartMarker = null;
        this.predicate = new BetweenPredicate(this.left, this.start, (Expression)new SubqueryExpression(builder), this.negated);
        this.listener.onBuilderEnded(this);
    }

    @Override
    public void verifySubqueryBuilderEnded() {
        if (this.subqueryStartMarker != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
        super.verifySubqueryBuilderEnded();
    }

    public <X> SubqueryInitiator<X> startSubqueryInitiator(SubqueryInitiator<X> subqueryInitiator) {
        this.subqueryStartMarker = subqueryInitiator;
        return subqueryInitiator;
    }

    private T chain(BetweenPredicate predicate) {
        this.verifySubqueryBuilderEnded();
        this.predicate = predicate;
        this.listener.onBuilderEnded(this);
        return this.result;
    }
}

