/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl.builder.object;

import com.blazebit.persistence.FullQueryBuilder;
import com.blazebit.persistence.MultipleSubqueryInitiator;
import com.blazebit.persistence.SelectObjectBuilder;
import com.blazebit.persistence.SubqueryBuilder;
import com.blazebit.persistence.SubqueryInitiator;
import com.blazebit.persistence.impl.BuilderChainingException;
import com.blazebit.persistence.impl.ClauseType;
import com.blazebit.persistence.impl.MultipleSubqueryInitiatorImpl;
import com.blazebit.persistence.impl.SelectObjectBuilderEndedListener;
import com.blazebit.persistence.impl.SubqueryBuilderListenerImpl;
import com.blazebit.persistence.impl.SubqueryInitiatorFactory;
import com.blazebit.persistence.impl.SubqueryInternalBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilder;
import com.blazebit.persistence.impl.builder.expression.ExpressionBuilderEndedListener;
import com.blazebit.persistence.impl.builder.expression.SuperExpressionSubqueryBuilderListener;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.SubqueryExpression;
import java.util.AbstractMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SelectObjectBuilderImpl<T extends FullQueryBuilder<?, T>>
extends SubqueryBuilderListenerImpl<SelectObjectBuilder<T>>
implements SelectObjectBuilder<T>,
ExpressionBuilderEndedListener {
    private final T result;
    private final SortedMap<Integer, Map.Entry<Expression, String>> expressions = new TreeMap<Integer, Map.Entry<Expression, String>>();
    private final SelectObjectBuilderEndedListener listener;
    private final SubqueryInitiatorFactory subqueryInitFactory;
    private final ExpressionFactory expressionFactory;
    private String subqueryAlias;
    private Integer subqueryPosition;
    private SubqueryInitiator<?> subqueryStartMarker;
    private MultipleSubqueryInitiator<?> multipleSubqueryStartMarker;

    public SelectObjectBuilderImpl(T result, SelectObjectBuilderEndedListener listener, SubqueryInitiatorFactory subqueryInitFactory, ExpressionFactory expressionFactory) {
        this.result = result;
        this.listener = listener;
        this.subqueryInitFactory = subqueryInitFactory;
        this.expressionFactory = expressionFactory;
    }

    public SelectObjectBuilder<T> with(String expression) {
        return this.with(expression, null);
    }

    public SelectObjectBuilder<T> with(String expression, String alias) {
        if (this.expressions.containsKey(this.expressions.size())) {
            throw new IllegalStateException("Argument for position " + this.expressions.size() + " already specified");
        }
        this.verifySubqueryBuilderEnded();
        Expression exp = this.expressionFactory.createSimpleExpression(expression, false);
        this.expressions.put(this.expressions.size(), new AbstractMap.SimpleEntry<Expression, String>(exp, alias));
        return this;
    }

    public SelectObjectBuilder<T> with(int position, String expression) {
        return this.with(position, expression, null);
    }

    public SelectObjectBuilder<T> with(int position, String expression, String alias) {
        if (this.expressions.containsKey(position)) {
            throw new IllegalStateException("Argument for position " + position + " already specified");
        }
        this.verifySubqueryBuilderEnded();
        Expression exp = this.expressionFactory.createSimpleExpression(expression, false);
        this.expressions.put(position, new AbstractMap.SimpleEntry<Expression, String>(exp, alias));
        return this;
    }

    public T end() {
        this.listener.onBuilderEnded(this.expressions.values());
        return this.result;
    }

    @Override
    public void verifySubqueryBuilderEnded() {
        if (this.subqueryStartMarker != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
        if (this.multipleSubqueryStartMarker != null) {
            throw new BuilderChainingException("A builder was not ended properly.");
        }
        super.verifySubqueryBuilderEnded();
    }

    public <X> SubqueryInitiator<X> startSubqueryInitiator(SubqueryInitiator<X> subqueryInitiator) {
        this.subqueryStartMarker = subqueryInitiator;
        return subqueryInitiator;
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery() {
        return this.withSubquery((String)null);
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(String alias) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = alias;
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this, this, false, ClauseType.SELECT));
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(String subqueryAlias, String expression) {
        return this.withSubquery(subqueryAlias, expression, (String)null);
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(String subqueryAlias, String expression, String selectAlias) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = selectAlias;
        SuperExpressionSubqueryBuilderListener superExpressionSubqueryListener = new SuperExpressionSubqueryBuilderListener(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        return this.startSubqueryInitiator(this.subqueryInitFactory.createSubqueryInitiator(this, superExpressionSubqueryListener, false, ClauseType.SELECT));
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(int position) {
        this.subqueryPosition = position;
        return this.withSubquery();
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(int position, String alias) {
        this.subqueryPosition = position;
        return this.withSubquery(alias);
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(int position, String subqueryAlias, String expression, String selectAlias) {
        this.subqueryPosition = position;
        return this.withSubquery(subqueryAlias, expression, selectAlias);
    }

    public SubqueryInitiator<SelectObjectBuilder<T>> withSubquery(int position, String subqueryAlias, String expression) {
        this.subqueryPosition = position;
        return this.withSubquery(subqueryAlias, expression);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.withSubquery(null, criteriaBuilder);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(String alias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = alias;
        return this.startSubqueryBuilder(this.subqueryInitFactory.createSubqueryBuilder(this, this, false, criteriaBuilder, ClauseType.SELECT));
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(String subqueryAlias, String expression, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.verifySubqueryBuilderEnded();
        this.subqueryAlias = selectAlias;
        SuperExpressionSubqueryBuilderListener superExpressionSubqueryListener = new SuperExpressionSubqueryBuilderListener(subqueryAlias, this.expressionFactory.createSimpleExpression(expression));
        return this.startSubqueryBuilder(this.subqueryInitFactory.createSubqueryBuilder(this, superExpressionSubqueryListener, false, criteriaBuilder, ClauseType.SELECT));
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        return this.withSubquery(subqueryAlias, expression, null, criteriaBuilder);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(int position, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.subqueryPosition = position;
        return this.withSubquery(criteriaBuilder);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(int position, String alias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.subqueryPosition = position;
        return this.withSubquery(alias, criteriaBuilder);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(int position, String subqueryAlias, String expression, String selectAlias, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.subqueryPosition = position;
        return this.withSubquery(subqueryAlias, expression, selectAlias, criteriaBuilder);
    }

    public SubqueryBuilder<SelectObjectBuilder<T>> withSubquery(int position, String subqueryAlias, String expression, FullQueryBuilder<?, ?> criteriaBuilder) {
        this.subqueryPosition = position;
        return this.withSubquery(subqueryAlias, expression, criteriaBuilder);
    }

    public MultipleSubqueryInitiator<SelectObjectBuilder<T>> withSubqueries(String expression) {
        return this.withSubqueries(expression, null);
    }

    public MultipleSubqueryInitiator<SelectObjectBuilder<T>> withSubqueries(String expression, String selectAlias) {
        this.subqueryAlias = selectAlias;
        return this.startMultipleSubqueryInitiator(this.expressionFactory.createSimpleExpression(expression));
    }

    private MultipleSubqueryInitiator<SelectObjectBuilder<T>> startMultipleSubqueryInitiator(Expression expression) {
        this.verifySubqueryBuilderEnded();
        MultipleSubqueryInitiatorImpl<SelectObjectBuilder<T>> initiator = new MultipleSubqueryInitiatorImpl<SelectObjectBuilder<T>>(this, expression, this, this.subqueryInitFactory, ClauseType.SELECT);
        this.multipleSubqueryStartMarker = initiator;
        return initiator;
    }

    public MultipleSubqueryInitiator<SelectObjectBuilder<T>> withSubqueries(int position, String expression, String selectAlias) {
        this.subqueryPosition = position;
        return this.withSubqueries(expression, selectAlias);
    }

    public MultipleSubqueryInitiator<SelectObjectBuilder<T>> withSubqueries(int position, String expression) {
        this.subqueryPosition = position;
        return this.withSubqueries(expression);
    }

    @Override
    public void onBuilderEnded(SubqueryInternalBuilder<SelectObjectBuilder<T>> builder) {
        int position;
        super.onBuilderEnded(builder);
        if (this.subqueryPosition == null) {
            position = this.expressions.size();
        } else {
            position = this.subqueryPosition;
            this.subqueryPosition = null;
        }
        this.expressions.put(position, new AbstractMap.SimpleEntry<SubqueryExpression, String>(new SubqueryExpression(builder), this.subqueryAlias));
    }

    @Override
    public void onBuilderEnded(ExpressionBuilder builder) {
        int position;
        this.multipleSubqueryStartMarker = null;
        if (this.subqueryPosition == null) {
            position = this.expressions.size();
        } else {
            position = this.subqueryPosition;
            this.subqueryPosition = null;
        }
        this.expressions.put(position, new AbstractMap.SimpleEntry<Expression, String>(builder.getExpression(), this.subqueryAlias));
    }
}

