/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.AliasManager;
import com.blazebit.persistence.impl.JoinNode;
import com.blazebit.persistence.impl.SelectInfo;
import com.blazebit.persistence.impl.SimplePathReference;
import com.blazebit.persistence.parser.EntityMetamodel;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.LazyCopyingResultVisitorAdapter;
import com.blazebit.persistence.parser.expression.MapKeyExpression;
import com.blazebit.persistence.parser.expression.MapValueExpression;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.parser.expression.PathReference;
import com.blazebit.persistence.parser.expression.PropertyExpression;
import com.blazebit.persistence.spi.JpaProvider;
import java.util.ArrayList;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.Type;

public class SplittingVisitor
extends LazyCopyingResultVisitorAdapter {
    private final EntityMetamodel metamodel;
    private final JpaProvider jpaProvider;
    private final AliasManager aliasManager;
    private Expression expressionToSplit;
    private String subAttribute;

    public SplittingVisitor(EntityMetamodel metamodel, JpaProvider jpaProvider, AliasManager aliasManager) {
        this.metamodel = metamodel;
        this.jpaProvider = jpaProvider;
        this.aliasManager = aliasManager;
    }

    public Expression visit(MapKeyExpression expression) {
        if (expression == this.expressionToSplit) {
            ArrayList<Object> expressions = new ArrayList<Object>(2);
            expressions.add(expression);
            for (String subAttributePart : this.subAttribute.split("\\.")) {
                expressions.add(new PropertyExpression(subAttributePart));
            }
            JoinNode node = ((JoinNode)expression.getPath().getBaseNode()).getKeyJoinNode();
            String field = this.subAttribute;
            Class fieldClass = this.jpaProvider.getJpaMetamodelAccessor().getAttributePath((Metamodel)this.metamodel, node.getManagedType(), field).getAttributeClass();
            Type fieldType = this.metamodel.type(fieldClass);
            return new PathExpression(expressions, (PathReference)new SimplePathReference(node, field, fieldType), false, false);
        }
        return expression;
    }

    public Expression visit(MapValueExpression expression) {
        if (expression == this.expressionToSplit) {
            Expression newExpression = (Expression)expression.getPath().accept((Expression.ResultVisitor)this);
            if (newExpression != expression.getPath()) {
                return newExpression;
            }
        } else {
            return (Expression)expression.getPath().accept((Expression.ResultVisitor)this);
        }
        return expression;
    }

    public Expression visit(PathExpression expression) {
        if (expression.getBaseNode() == null) {
            Expression newExpression;
            Expression aliasedExpression = ((SelectInfo)this.aliasManager.getAliasInfo(expression.toString())).getExpression();
            return aliasedExpression == (newExpression = (Expression)aliasedExpression.accept((Expression.ResultVisitor)this)) ? expression : newExpression;
        }
        if (expression == this.expressionToSplit) {
            ArrayList<PropertyExpression> expressions = new ArrayList<PropertyExpression>(expression.getExpressions());
            for (String subAttributePart : this.subAttribute.split("\\.")) {
                expressions.add(new PropertyExpression(subAttributePart));
            }
            String field = expression.getField() == null ? this.subAttribute : expression.getField() + "." + this.subAttribute;
            JoinNode node = (JoinNode)expression.getBaseNode();
            Class fieldClass = this.jpaProvider.getJpaMetamodelAccessor().getAttributePath((Metamodel)this.metamodel, node.getManagedType(), field).getAttributeClass();
            Type fieldType = this.metamodel.type(fieldClass);
            return new PathExpression(expressions, (PathReference)new SimplePathReference(node, field, fieldType), expression.isUsedInCollectionFunction(), expression.isCollectionQualifiedPath());
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Expression splitOff(Expression expression, Expression expressionToSplit, String subAttribute) {
        this.expressionToSplit = expressionToSplit;
        this.subAttribute = subAttribute;
        try {
            Expression expression2 = (Expression)expression.accept((Expression.ResultVisitor)this);
            return expression2;
        }
        finally {
            this.expressionToSplit = null;
            this.subAttribute = null;
        }
    }
}

