/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.persistence.impl;

import com.blazebit.persistence.impl.JpqlMacroFunctionRenderContext;
import com.blazebit.persistence.parser.expression.Expression;
import com.blazebit.persistence.parser.expression.ExpressionFactory;
import com.blazebit.persistence.parser.expression.MacroFunction;
import com.blazebit.persistence.parser.expression.PathExpression;
import com.blazebit.persistence.spi.CacheableJpqlMacro;
import com.blazebit.persistence.spi.FunctionRenderContext;
import com.blazebit.persistence.spi.JpqlMacro;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JpqlMacroAdapter
implements MacroFunction {
    private final JpqlMacro macro;
    private final ExpressionFactory expressionFactory;
    private final Object[] state;

    public JpqlMacroAdapter(JpqlMacro macro, ExpressionFactory expressionFactory) {
        this.macro = macro;
        this.expressionFactory = expressionFactory;
        this.state = new Object[]{macro, expressionFactory};
    }

    public static Map<String, MacroFunction> createMacros(Map<String, JpqlMacro> jpqlMacros, ExpressionFactory expressionFactory) {
        HashMap<String, MacroFunction> map = new HashMap<String, MacroFunction>(jpqlMacros.size());
        for (Map.Entry<String, JpqlMacro> entry : jpqlMacros.entrySet()) {
            map.put(entry.getKey(), new JpqlMacroAdapter(entry.getValue(), expressionFactory));
        }
        return map;
    }

    public Expression apply(List<Expression> expressions) {
        JpqlMacroFunctionRenderContext context = new JpqlMacroFunctionRenderContext(expressions);
        this.macro.render((FunctionRenderContext)context);
        String resultExpression = context.renderToString();
        if (resultExpression.isEmpty()) {
            return new PathExpression();
        }
        return this.expressionFactory.createSimpleExpression(resultExpression, false);
    }

    public Object[] getState() {
        return this.state;
    }

    public boolean supportsCaching() {
        return this.macro instanceof CacheableJpqlMacro;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JpqlMacroAdapter)) {
            return false;
        }
        JpqlMacroAdapter that = (JpqlMacroAdapter)o;
        return Arrays.equals(this.getState(), that.getState());
    }

    public int hashCode() {
        return Arrays.hashCode(this.getState());
    }
}

