/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.regex;

import com.blazebit.regex.node.CharNode;
import com.blazebit.regex.node.CharRangeNode;
import com.blazebit.regex.node.ComplementNode;
import com.blazebit.regex.node.DotNode;
import com.blazebit.regex.node.EmptyNode;
import com.blazebit.regex.node.Node;
import com.blazebit.regex.node.OptionalNode;
import com.blazebit.regex.node.OrNode;
import com.blazebit.regex.node.RepeatNode;

public class Pattern {
    private final String pattern;
    private final Node root;
    private int cursor = 0;

    public Pattern(String pattern) {
        this.pattern = pattern;
        this.root = this.parseUnion();
    }

    public static Node parse(String pattern) {
        return new Pattern((String)pattern).root;
    }

    private boolean hasNext() {
        return this.cursor < this.pattern.length();
    }

    private char next() {
        if (!this.hasNext()) {
            throw new IllegalArgumentException("Unexpected end of pattern");
        }
        return this.pattern.charAt(this.cursor++);
    }

    private char next(String s) {
        if (!this.hasNext()) {
            return '\u0000';
        }
        if (s.indexOf(this.pattern.charAt(this.cursor)) != -1) {
            return this.pattern.charAt(this.cursor++);
        }
        return '\u0000';
    }

    private boolean peek(String s) {
        if (!this.hasNext()) {
            return false;
        }
        return s.indexOf(this.pattern.charAt(this.cursor)) != -1;
    }

    private boolean match(char c) {
        if (!this.hasNext()) {
            return false;
        }
        if (this.pattern.charAt(this.cursor) == c) {
            ++this.cursor;
            return true;
        }
        return false;
    }

    private Node parseUnion() {
        OrNode rootNode = new OrNode();
        do {
            rootNode.add(this.parseTerm());
        } while (this.match('|'));
        return rootNode;
    }

    private Node parseTerm() {
        Node e = this.parseRepeat();
        if (this.hasNext() && !this.peek(")|")) {
            e.setNext(this.parseTerm());
        }
        return e;
    }

    private Node parseRepeat() {
        char c;
        Node e = this.parseCharacterClass();
        while ((c = this.next("?*+{")) != '\u0000') {
            switch (c) {
                case '?': {
                    e = new OptionalNode(e);
                    break;
                }
                case '*': {
                    e = new RepeatNode(e);
                    break;
                }
                case '+': {
                    e = new RepeatNode(e, 1);
                    break;
                }
                case '{': {
                    int m;
                    int n = this.parseInteger();
                    if (n == -1) {
                        throw new IllegalArgumentException("integer expected at position " + this.cursor);
                    }
                    int n2 = m = this.match(',') ? this.parseInteger() : n;
                    if (!this.match('}')) {
                        throw new IllegalArgumentException("expected '}' at position " + this.cursor);
                    }
                    e = m == -1 ? new RepeatNode(e, n) : new RepeatNode(e, n, m);
                }
            }
        }
        return e;
    }

    private int parseInteger() {
        StringBuilder sb = new StringBuilder();
        int start = this.cursor;
        while (this.peek("0123456789")) {
            sb.append(this.next());
        }
        if (start == this.cursor) {
            return -1;
        }
        return Integer.parseInt(sb.toString());
    }

    private Node parseCharacterClass() {
        if (this.match('[')) {
            boolean negate = false;
            if (this.match('^')) {
                negate = true;
            }
            Node node = this.parseCharacterClasses();
            if (negate) {
                node = new ComplementNode(node);
            }
            if (!this.match(']')) {
                throw new IllegalArgumentException("expected ']' at position " + this.cursor);
            }
            return node;
        }
        return this.parseAtom();
    }

    private Node parseCharacterClasses() {
        OrNode node = new OrNode();
        do {
            node.add(this.parseCharacterRange());
        } while (this.hasNext() && !this.peek("]"));
        return node;
    }

    private Node parseCharacterRange() {
        char c = this.parseCharacter();
        if (this.match('-')) {
            if (this.peek("]")) {
                OrNode node = new OrNode();
                node.add(new CharNode(c));
                node.add(new CharNode('-'));
                return node;
            }
            return new CharRangeNode(c, this.parseCharacter());
        }
        return new CharNode(c);
    }

    private Node parseAtom() throws IllegalArgumentException {
        if (this.match('.')) {
            return new DotNode();
        }
        if (this.match('(')) {
            if (this.match(')')) {
                return new EmptyNode();
            }
            Node e = this.parseUnion();
            if (!this.match(')')) {
                throw new IllegalArgumentException("expected ')' at position " + this.cursor);
            }
            return e;
        }
        return new CharNode(this.parseCharacter());
    }

    private char parseCharacter() throws IllegalArgumentException {
        this.match('\\');
        return this.next();
    }
}

