/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.reflection;

import com.blazebit.reflection.PropertyPathExpression;
import com.blazebit.reflection.PropertyPathExpressionValueHolder;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class ExpressionUtils {
    private static final ConcurrentMap<PropertyPathExpressionKey, PropertyPathExpression<Object, Object>> cache = new ConcurrentHashMap<PropertyPathExpressionKey, PropertyPathExpression<Object, Object>>();

    public static <X, Y> PropertyPathExpression<X, Y> getExpression(Class<X> source, String propertyPath) {
        return ExpressionUtils.getExpression(source, propertyPath, null);
    }

    public static <X, Y> PropertyPathExpressionValueHolder<X, Y> getValueHolder(Class<X> source, X target, String propertyPath) {
        return ExpressionUtils.getValueHolder(source, target, propertyPath, null);
    }

    public static <X, Y> PropertyPathExpressionValueHolder<X, Y> getValueHolder(Class<X> source, X target, String propertyPath, boolean allowFieldAccess) {
        return ExpressionUtils.getValueHolder(source, target, propertyPath, null, allowFieldAccess);
    }

    public static <X, Y> PropertyPathExpression<X, Y> getExpression(Class<X> source, String propertyPath, Class<Y> valueClass) {
        return ExpressionUtils.getExpression(source, propertyPath, valueClass, false);
    }

    public static <X, Y> PropertyPathExpression<X, Y> getExpression(Class<X> source, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        PropertyPathExpression oldExpression;
        PropertyPathExpressionKey key = new PropertyPathExpressionKey(source, propertyPath, allowFieldAccess);
        PropertyPathExpression expression = (PropertyPathExpression)cache.get(key);
        if (expression == null && (oldExpression = cache.putIfAbsent(key, expression = new PropertyPathExpression(source, propertyPath, allowFieldAccess))) != null) {
            expression = oldExpression;
        }
        return expression;
    }

    public static <X, Y> PropertyPathExpressionValueHolder<X, Y> getValueHolder(Class<X> source, X target, String propertyPath, Class<Y> valueClass) {
        return new PropertyPathExpressionValueHolder<X, Y>(target, ExpressionUtils.getExpression(source, propertyPath, valueClass));
    }

    public static <X, Y> PropertyPathExpressionValueHolder<X, Y> getValueHolder(Class<X> source, X target, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        return new PropertyPathExpressionValueHolder<X, Y>(target, ExpressionUtils.getExpression(source, propertyPath, valueClass, allowFieldAccess));
    }

    public static <X, Y> Y getValue(Class<X> source, X target, String propertyPath) {
        return ExpressionUtils.getValue(source, target, propertyPath, null);
    }

    public static <X, Y> Y getNullSafeValue(Class<X> source, X target, String propertyPath) {
        return ExpressionUtils.getNullSafeValue(source, target, propertyPath, null);
    }

    public static <X, Y> void setValue(Class<X> source, X target, String propertyPath, Y value) {
        ExpressionUtils.getExpression(source, propertyPath).setValue(target, value);
    }

    public static <X, Y> Y getValue(Class<X> source, X target, String propertyPath, boolean allowFieldAccess) {
        return ExpressionUtils.getValue(source, target, propertyPath, null, allowFieldAccess);
    }

    public static <X, Y> Y getNullSafeValue(Class<X> source, X target, String propertyPath, boolean allowFieldAccess) {
        return ExpressionUtils.getNullSafeValue(source, target, propertyPath, null, allowFieldAccess);
    }

    public static <X, Y> void setValue(Class<X> source, X target, String propertyPath, Y value, boolean allowFieldAccess) {
        ExpressionUtils.getExpression(source, propertyPath, null, allowFieldAccess).setValue(target, value);
    }

    public static <X, Y> Y getValue(Class<X> source, X target, String propertyPath, Class<Y> valueClass) {
        return ExpressionUtils.getExpression(source, propertyPath, valueClass).getValue(target);
    }

    public static <X, Y> Y getNullSafeValue(Class<X> source, X target, String propertyPath, Class<Y> valueClass) {
        return ExpressionUtils.getExpression(source, propertyPath, valueClass).getNullSafeValue(target);
    }

    public static <X, Y> Y getValue(Class<X> source, X target, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        return ExpressionUtils.getExpression(source, propertyPath, valueClass, allowFieldAccess).getValue(target);
    }

    public static <X, Y> Y getNullSafeValue(Class<X> source, X target, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        return ExpressionUtils.getExpression(source, propertyPath, valueClass, allowFieldAccess).getNullSafeValue(target);
    }

    public static <X, Y> Y getValue(X target, String propertyPath) {
        return ExpressionUtils.getValue(target, propertyPath, null);
    }

    public static <X, Y> Y getNullSafeValue(X target, String propertyPath) {
        return ExpressionUtils.getNullSafeValue(target, propertyPath, null);
    }

    public static <X, Y> void setValue(X target, String propertyPath, Y value) {
        ExpressionUtils.getExpression(target.getClass(), propertyPath).setValue(target, value);
    }

    public static <X, Y> Y getValue(X target, String propertyPath, boolean allowFieldAccess) {
        return ExpressionUtils.getValue(target, propertyPath, null, allowFieldAccess);
    }

    public static <X, Y> Y getNullSafeValue(X target, String propertyPath, boolean allowFieldAccess) {
        return ExpressionUtils.getNullSafeValue(target, propertyPath, null, allowFieldAccess);
    }

    public static <X, Y> void setValue(X target, String propertyPath, Y value, boolean allowFieldAccess) {
        ExpressionUtils.getExpression(target.getClass(), propertyPath, null, allowFieldAccess).setValue(target, value);
    }

    public static <X, Y> Y getValue(X target, String propertyPath, Class<Y> valueClass) {
        return ExpressionUtils.getExpression(target.getClass(), propertyPath, valueClass).getValue(target);
    }

    public static <X, Y> Y getNullSafeValue(X target, String propertyPath, Class<Y> valueClass) {
        return target == null ? null : (Y)ExpressionUtils.getExpression(target.getClass(), propertyPath, valueClass).getNullSafeValue(target);
    }

    public static <X, Y> Y getValue(X target, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        return ExpressionUtils.getExpression(target.getClass(), propertyPath, valueClass, allowFieldAccess).getValue(target);
    }

    public static <X, Y> Y getNullSafeValue(X target, String propertyPath, Class<Y> valueClass, boolean allowFieldAccess) {
        return target == null ? null : (Y)ExpressionUtils.getExpression(target.getClass(), propertyPath, valueClass, allowFieldAccess).getNullSafeValue(target);
    }

    private ExpressionUtils() {
    }

    private static class PropertyPathExpressionKey {
        final Class<?> source;
        final String propertyPath;
        final boolean allowField;

        public PropertyPathExpressionKey(Class<?> source, String propertyPath, boolean allowField) {
            this.source = source;
            this.propertyPath = propertyPath;
            this.allowField = allowField;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.propertyPath == null ? 0 : this.propertyPath.hashCode());
            result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyPathExpressionKey other = (PropertyPathExpressionKey)obj;
            if (this.propertyPath == null ? other.propertyPath != null : !this.propertyPath.equals(other.propertyPath)) {
                return false;
            }
            return !(this.source == null ? other.source != null : !this.source.equals(other.source));
        }
    }
}

