/*
 * Decompiled with CFR 0.152.
 */
package com.blazebit.annotation;

import com.blazebit.reflection.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class AnnotationUtils {
    private static Class<? extends Annotation> stereotypeAnnotationClass;

    private AnnotationUtils() {
    }

    public static Set<Annotation> getAllAnnotations(Class<?> clazz) {
        LinkedHashSet<Annotation> annotationSet = new LinkedHashSet<Annotation>();
        ArrayList<Class<? extends Annotation>> annotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (Class<?> type : ReflectionUtils.getSuperTypes(clazz)) {
            Annotation[] annotations;
            for (Annotation a : annotations = type.getAnnotations()) {
                annotationSet.add(a);
                annotationTypes.add(a.annotationType());
            }
        }
        if (stereotypeAnnotationClass != null) {
            while (!annotationTypes.isEmpty()) {
                Class annotationType = (Class)annotationTypes.remove(annotationTypes.size() - 1);
                if (!annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
                for (Annotation annotation : annotationType.getAnnotations()) {
                    annotationTypes.add(annotation.annotationType());
                    if (annotation.annotationType().equals(stereotypeAnnotationClass)) continue;
                    annotationSet.add(annotation);
                }
            }
        }
        return annotationSet;
    }

    public static Set<Annotation> getAllAnnotations(Method m) {
        LinkedHashSet<Annotation> annotationSet = new LinkedHashSet<Annotation>();
        Annotation[] annotations = m.getAnnotations();
        ArrayList<Class<? extends Annotation>> annotationTypes = new ArrayList<Class<? extends Annotation>>();
        for (Annotation a : annotations) {
            annotationSet.add(a);
            annotationTypes.add(a.annotationType());
        }
        if (stereotypeAnnotationClass != null) {
            while (!annotationTypes.isEmpty()) {
                Class annotationType = (Class)annotationTypes.remove(annotationTypes.size() - 1);
                if (!annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
                for (Annotation annotation : annotationType.getAnnotations()) {
                    annotationTypes.add(annotation.annotationType());
                    if (annotation.annotationType().equals(stereotypeAnnotationClass)) continue;
                    annotationSet.add(annotation);
                }
            }
        }
        return annotationSet;
    }

    public static <T extends Annotation> T findAnnotation(Method m, Class<?> clazz, Class<T> annotationClazz) {
        T result = AnnotationUtils.findAnnotation(m, annotationClazz);
        return result != null ? result : AnnotationUtils.findAnnotation(clazz, annotationClazz);
    }

    public static <T extends Annotation> T findAnnotation(Method m, Class<T> annotationClazz) {
        T annotation = m.getAnnotation(annotationClazz);
        if (annotation != null) {
            return annotation;
        }
        if (stereotypeAnnotationClass != null) {
            ArrayList annotations = new ArrayList();
            for (Annotation a : m.getAnnotations()) {
                annotations.add(a.annotationType());
            }
            return AnnotationUtils.findAnnotation(annotations, annotationClazz);
        }
        return null;
    }

    public static <T extends Annotation> T findAnnotation(Class<?> clazz, Class<T> annotationClazz) {
        T annotation = clazz.getAnnotation(annotationClazz);
        if (annotation != null) {
            return annotation;
        }
        Set<Class<?>> superTypes = ReflectionUtils.getSuperTypes(clazz);
        for (Class<?> type : superTypes) {
            annotation = type.getAnnotation(annotationClazz);
            if (annotation == null) continue;
            return annotation;
        }
        if (stereotypeAnnotationClass != null) {
            ArrayList annotations = new ArrayList();
            for (Class<?> type : superTypes) {
                for (Annotation a : type.getAnnotations()) {
                    annotations.add(a.annotationType());
                }
            }
            return AnnotationUtils.findAnnotation(annotations, annotationClazz);
        }
        return null;
    }

    private static <T extends Annotation> T findAnnotation(List<Class<?>> annotationTypes, Class<T> annotationClazz) {
        while (!annotationTypes.isEmpty()) {
            Class<?> annotationType = annotationTypes.remove(annotationTypes.size() - 1);
            if (!annotationType.isAnnotationPresent(stereotypeAnnotationClass)) continue;
            T annotation = annotationType.getAnnotation(annotationClazz);
            if (annotation != null) {
                return annotation;
            }
            for (Annotation a : annotationType.getAnnotations()) {
                Class<? extends Annotation> aType = a.annotationType();
                if (aType.equals(stereotypeAnnotationClass)) continue;
                annotationTypes.add(aType);
            }
        }
        return null;
    }

    static {
        try {
            stereotypeAnnotationClass = Class.forName("javax.enterprise.inject.Stereotype");
        }
        catch (ClassNotFoundException ex) {
            Logger log = Logger.getLogger(AnnotationUtils.class.getName());
            log.log(Level.WARNING, "Stereotype annotation can not be found, skipping annotation inheritance via stereotype.");
        }
    }
}

