/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect.multiple;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothSubScribeData;
import com.blakequ.bluetooth_manager_lib.connect.ConnectConfig;
import com.blakequ.bluetooth_manager_lib.connect.ConnectState;
import com.blakequ.bluetooth_manager_lib.connect.multiple.ConnectRequestQueue;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

@TargetApi(value=18)
public final class MultiConnectManager
extends ConnectRequestQueue {
    private static final String TAG = "MultiConnectManager";
    private static MultiConnectManager INSTANCE;
    private BluetoothManager bluetoothManager;
    private static String serviceUUID;
    private BluetoothGattCallback mBluetoothGattCallback;
    private final Queue<BluetoothSubScribeData> subscribeQueue;
    private static Object obj;

    private MultiConnectManager(Context context) {
        super(context);
        this.bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.subscribeQueue = new ConcurrentLinkedQueue<BluetoothSubScribeData>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MultiConnectManager getInstance(Context context) {
        if (INSTANCE == null) {
            Object object = obj;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new MultiConnectManager(context);
                }
            }
        }
        return INSTANCE;
    }

    public List<BluetoothDevice> getConnectedDevice() {
        List devices = this.bluetoothManager.getConnectedDevices(7);
        if (!this.isEmpty(devices)) {
            ArrayList<BluetoothDevice> newDevices = new ArrayList<BluetoothDevice>();
            for (BluetoothDevice device : devices) {
                if (this.getDeviceState(device.getAddress()) == ConnectState.CONNECTED) {
                    newDevices.add(device);
                    continue;
                }
                LogUtils.i(TAG, "Not exist connected device in queue " + device.getAddress());
            }
            return newDevices;
        }
        return Collections.EMPTY_LIST;
    }

    public void setBluetoothGattCallback(BluetoothGattCallback callback) {
        this.mBluetoothGattCallback = callback;
    }

    public void addBluetoothSubscribeData(BluetoothSubScribeData data) {
        this.subscribeQueue.add(data);
    }

    public void setServiceUUID(String serviceUUID) {
        MultiConnectManager.serviceUUID = serviceUUID;
    }

    @Override
    protected BluetoothGattCallback getBluetoothGattCallback() {
        return this.mBluetoothGattCallback;
    }

    @Override
    protected String getServiceUUID() {
        return serviceUUID;
    }

    @Override
    protected Queue<BluetoothSubScribeData> getSubscribeDataQueue() {
        return this.subscribeQueue;
    }

    @Deprecated
    public void setMaxConnectDeviceNum(int number) {
        ConnectConfig.maxConnectDeviceNum = number;
    }

    static {
        obj = new Object();
    }
}

