/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect.multiple;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothConnectInterface;
import com.blakequ.bluetooth_manager_lib.connect.ConnectConfig;
import com.blakequ.bluetooth_manager_lib.connect.ConnectState;
import com.blakequ.bluetooth_manager_lib.connect.ConnectStateListener;
import com.blakequ.bluetooth_manager_lib.connect.ReconnectParamsBean;
import com.blakequ.bluetooth_manager_lib.util.BluetoothUtils;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

public abstract class ConnectRequestQueue
extends BluetoothConnectInterface {
    private static final String TAG = "ConnectRequestQueue";
    private Map<String, ReconnectParamsBean> reconnectMap;
    private Map<String, ConnectState> macMap;
    private Map<String, BluetoothGatt> gattMap;
    private Queue<String> deviceQueue;
    private final BluetoothUtils mBluetoothUtils;
    private List<ConnectStateListener> connectStateListeners;
    private Runnable reconnectTask = new Runnable(){

        @Override
        public void run() {
            LogUtils.d(ConnectRequestQueue.TAG, "Start reconnect task by handler");
            ConnectRequestQueue.this.startReconnectTask();
        }
    };

    public ConnectRequestQueue(Context context) {
        super(context);
        this.macMap = new ConcurrentHashMap<String, ConnectState>();
        this.gattMap = new ConcurrentHashMap<String, BluetoothGatt>();
        this.reconnectMap = new ConcurrentHashMap<String, ReconnectParamsBean>();
        this.deviceQueue = new ConcurrentLinkedQueue<String>();
        this.mBluetoothUtils = BluetoothUtils.getInstance(context);
        this.connectStateListeners = new ArrayList<ConnectStateListener>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectStateListener(ConnectStateListener listener) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            this.connectStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectStateListener(ConnectStateListener listener) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            this.connectStateListeners.remove(listener);
        }
    }

    @Override
    protected void onDeviceConnected(BluetoothGatt gatt) {
        if (gatt != null) {
            this.updateConnectState(gatt.getDevice().getAddress(), ConnectState.CONNECTED);
        }
    }

    @Override
    protected void onDeviceDisconnect(BluetoothGatt gatt, int errorState) {
        LogUtils.e(TAG, "Disconnected from GATT server address:" + gatt.getDevice().getAddress());
        if (!this.mBluetoothUtils.isBluetoothIsEnable()) {
            this.closeAll();
        } else {
            this.close(gatt.getDevice().getAddress());
        }
    }

    @Override
    protected void onDiscoverServicesFail(BluetoothGatt gatt) {
        if (gatt != null) {
            this.updateConnectState(gatt.getDevice().getAddress(), ConnectState.NORMAL);
        }
    }

    @Override
    protected void onDiscoverServicesSuccess(BluetoothGatt gatt) {
        if (gatt != null) {
            this.updateConnectState(gatt.getDevice().getAddress(), ConnectState.CONNECTED);
        }
    }

    public void startConnect() {
        if (this.deviceQueue.size() > 0 && this.mBluetoothUtils.isBluetoothIsEnable()) {
            this.triggerConnectNextDevice();
        } else {
            LogUtils.e(TAG, "Fail to start connect task! connect queue size " + this.deviceQueue.size() + " ble state:" + this.mBluetoothUtils.isBluetoothIsEnable());
        }
    }

    public void startConnect(String macAddress) {
        if (macAddress != null && macAddress.length() > 0) {
            if (this.macMap.containsKey(macAddress)) {
                ConnectState state = this.macMap.get(macAddress);
                if (this.macMap.get(macAddress) == ConnectState.NORMAL) {
                    if (!this.reconnectMap.containsKey(macAddress)) {
                        ReconnectParamsBean bean = new ReconnectParamsBean(macAddress);
                        this.reconnectMap.put(macAddress, bean);
                    } else {
                        ReconnectParamsBean bean = this.reconnectMap.get(macAddress);
                        bean.updateAddress(macAddress);
                    }
                    this.startReconnectTask();
                } else {
                    LogUtils.i(TAG, "Device is " + (Object)((Object)state) + " state");
                }
            } else {
                LogUtils.e(TAG, "Fail to connect device, device can not found in queue, you must invoke addDeviceToQueue(Stirng)");
            }
        } else {
            LogUtils.e(TAG, "Fail to connect device, mac address is null");
        }
    }

    private void triggerConnectNextDevice() {
        String mac = this.deviceQueue.peek();
        if (!this.isEmpty(mac)) {
            LogUtils.i(TAG, "Start trigger connect device " + mac);
            this.connect(mac);
        }
    }

    private void updateConnectState(String address, ConnectState state) {
        this.macMap.put(address, state);
        this.updateConnectStateListener(address, state);
        switch (state) {
            case NORMAL: {
                String mac = this.deviceQueue.peek();
                if (!this.isEmpty(mac)) {
                    if (address.equals(mac)) {
                        this.deviceQueue.poll();
                    }
                    this.triggerConnectNextDevice();
                }
                this.triggerReconnect();
                break;
            }
            case CONNECTED: {
                this.reconnectMap.remove(address);
                String mac1 = this.deviceQueue.peek();
                if (!this.isEmpty(mac1)) {
                    if (address.equals(mac1)) {
                        this.deviceQueue.poll();
                    }
                    this.triggerConnectNextDevice();
                }
                this.triggerReconnect();
                break;
            }
        }
    }

    @Override
    public void release() {
        this.macMap.clear();
        this.closeAll();
        this.gattMap.clear();
        this.reconnectMap.clear();
        this.deviceQueue.clear();
        this.getMainLooperHandler().removeCallbacks(this.reconnectTask);
    }

    public int getQueueSize() {
        return this.macMap.size();
    }

    public void addDeviceToQueue(String macAddress) {
        if (!this.macMap.containsKey(macAddress)) {
            if (this.macMap.size() >= this.getMaxLen()) {
                String address = this.deviceQueue.poll();
                if (this.isEmpty(address)) {
                    address = this.getFirstDevice();
                }
                this.removeDeviceFromQueue(address);
            }
            this.deviceQueue.add(macAddress);
            this.macMap.put(macAddress, ConnectState.NORMAL);
        }
    }

    public void addDeviceToQueue(String[] devices) {
        if (devices != null && devices.length > 0) {
            for (int i = 0; i < devices.length; ++i) {
                this.addDeviceToQueue(devices[i]);
            }
        }
    }

    public void removeDeviceFromQueue(String macAddress) {
        if (this.isEmpty(macAddress)) {
            return;
        }
        this.macMap.remove(macAddress);
        this.reconnectMap.remove(macAddress);
        if (this.gattMap.containsKey(macAddress)) {
            this.close(macAddress);
        }
    }

    public List<String> getAllDevice() {
        if (this.macMap.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.macMap.keySet()) {
            list.add(key);
        }
        return list;
    }

    private String getFirstDevice() {
        if (this.macMap.size() <= 0) {
            return null;
        }
        Iterator<String> iterator = this.macMap.keySet().iterator();
        if (iterator.hasNext()) {
            String key = iterator.next();
            return key;
        }
        return null;
    }

    public List<String> getAllConnectedDevice() {
        if (this.macMap.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.macMap.keySet()) {
            if (this.macMap.get(key) != ConnectState.CONNECTED) continue;
            list.add(key);
        }
        return list;
    }

    public boolean containsDevice(String address) {
        return this.macMap.containsKey(address);
    }

    public ConnectState getDeviceState(String address) {
        return this.macMap.get(address);
    }

    public List<String> getAllConnectingDevice() {
        if (this.macMap.size() <= 0) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String key : this.macMap.keySet()) {
            if (this.macMap.get(key) != ConnectState.CONNECTING) continue;
            list.add(key);
        }
        return list;
    }

    public boolean isDisconnectDevice() {
        for (ConnectState value : this.macMap.values()) {
            if (value != ConnectState.NORMAL) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectingDevice() {
        for (ConnectState value : this.macMap.values()) {
            if (value != ConnectState.CONNECTING) continue;
            return true;
        }
        return false;
    }

    public boolean isConnectedDevice() {
        for (ConnectState value : this.macMap.values()) {
            if (value != ConnectState.CONNECTED) continue;
            return true;
        }
        return false;
    }

    @Override
    public BluetoothGatt getBluetoothGatt(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            return this.gattMap.get(address);
        }
        return null;
    }

    private void triggerReconnect() {
        if (this.deviceQueue.size() == 0) {
            for (String key : this.macMap.keySet()) {
                if (this.macMap.get(key) != ConnectState.NORMAL || this.reconnectMap.containsKey(key)) continue;
                ReconnectParamsBean bean = new ReconnectParamsBean(key);
                this.reconnectMap.put(key, bean);
            }
            this.startReconnectTask();
        }
    }

    private synchronized void startReconnectTask() {
        if (this.reconnectMap.size() <= 0) {
            return;
        }
        long nextTime = SystemClock.elapsedRealtime() * 2L;
        String address = "";
        for (String addr : this.reconnectMap.keySet()) {
            ReconnectParamsBean bean = this.reconnectMap.get(addr);
            if (bean.getNextReconnectTime() >= nextTime) continue;
            nextTime = bean.getNextReconnectTime();
            address = addr;
        }
        if (!this.isEmpty(address)) {
            if (nextTime <= SystemClock.elapsedRealtime()) {
                this.reconnectDevice(address);
            } else {
                this.getMainLooperHandler().removeCallbacks(this.reconnectTask);
                this.getMainLooperHandler().postDelayed(this.reconnectTask, nextTime - SystemClock.elapsedRealtime());
            }
        }
    }

    private synchronized void reconnectDevice(final String address) {
        if (this.macMap.containsKey(address)) {
            ReconnectParamsBean bean = this.reconnectMap.get(address);
            if (this.mBluetoothUtils.isBluetoothIsEnable()) {
                if (bean == null) {
                    this.reconnectMap.put(address, new ReconnectParamsBean(address));
                } else {
                    bean.addNumber();
                }
                ConnectState state = this.macMap.get(address);
                if (state == ConnectState.NORMAL) {
                    LogUtils.d(TAG, "Start reconnect device " + address + " reconnect number is " + bean.getNumber());
                    this.runOnUiThread(new Runnable(){

                        @Override
                        public void run() {
                            ConnectRequestQueue.this.connect(address);
                        }
                    });
                } else {
                    LogUtils.w(TAG, "Fail to reconnect device! " + address + " state is " + (Object)((Object)state));
                }
            } else {
                this.closeAll();
                LogUtils.w(TAG, "Fail to reconnect device! Bluetooth is not enable!");
            }
        } else {
            LogUtils.w(TAG, "Fail to reconnect device! " + address + " is remove from reconnectMap");
            this.reconnectMap.remove(address);
        }
    }

    protected boolean connect(String address) {
        BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
        if (mAdapter == null || address == null) {
            LogUtils.e(TAG, "BluetoothAdapter not initialized or unspecified address " + address);
            this.updateConnectStateListener(address, ConnectState.NORMAL);
            return false;
        }
        if (!this.mBluetoothUtils.isBluetoothIsEnable()) {
            LogUtils.e(TAG, "bluetooth is not enable.");
            this.closeAll();
            return false;
        }
        if (this.isEmpty(this.getServiceUUID())) {
            LogUtils.w(TAG, "Service uuid is null");
        }
        if (this.gattMap.containsKey(address)) {
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            LogUtils.i(TAG, "Trying to use an existing gatt and reconnection device " + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread()));
            if (mBluetoothGatt.connect()) {
                this.updateConnectState(address, ConnectState.CONNECTING);
                return true;
            }
            this.close(address);
            return false;
        }
        BluetoothDevice device = mAdapter.getRemoteDevice(address);
        if (device != null) {
            BluetoothGatt mBluetoothGatt = device.connectGatt(this.context, false, this.gattCallback);
            if (mBluetoothGatt != null) {
                LogUtils.i(TAG, "create a new connection address=" + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread()));
                this.gattMap.put(address, mBluetoothGatt);
                this.updateConnectState(address, ConnectState.CONNECTING);
                return true;
            }
            LogUtils.e(TAG, "Get Gatt fail!, address=" + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread()));
        } else {
            LogUtils.e(TAG, "Device not found, address=" + address);
        }
        return false;
    }

    public boolean close(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            LogUtils.w(TAG, "close gatt server " + address);
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            mBluetoothGatt.close();
            this.gattMap.remove(address);
            this.updateConnectState(address, ConnectState.NORMAL);
            return true;
        }
        return false;
    }

    public void closeAll() {
        for (String address : this.gattMap.keySet()) {
            this.close(address);
        }
    }

    public void disconnect(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            LogUtils.w(TAG, "disconnect gatt server " + address);
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            mBluetoothGatt.disconnect();
            this.updateConnectState(address, ConnectState.NORMAL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectStateListener(String address, ConnectState state) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            for (ConnectStateListener listener : this.connectStateListeners) {
                if (listener == null) continue;
                listener.onConnectStateChanged(address, state);
            }
        }
    }

    public int getMaxLen() {
        return ConnectConfig.maxConnectDeviceNum;
    }

    @Override
    public boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }
}

