/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanResult;
import android.os.Parcel;
import android.os.Parcelable;
import androidx.annotation.Nullable;
import com.blakequ.bluetooth_manager_lib.device.BluetoothLeDevice;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ObjectsCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanRecordCompat;

public class ScanResultCompat
implements Parcelable {
    private BluetoothLeDevice mDevice;
    @Nullable
    private ScanRecordCompat mScanRecord;
    private int mRssi;
    private long mTimestampNanos;
    public static final Parcelable.Creator<ScanResultCompat> CREATOR = new Parcelable.Creator<ScanResultCompat>(){

        public ScanResultCompat createFromParcel(Parcel source) {
            return new ScanResultCompat(source);
        }

        public ScanResultCompat[] newArray(int size) {
            return new ScanResultCompat[size];
        }
    };

    public ScanResultCompat(BluetoothDevice device, @Nullable ScanRecordCompat scanRecord, int rssi, long timestampNanos) {
        this.mDevice = new BluetoothLeDevice(device, rssi, scanRecord.getBytes(), timestampNanos);
        this.mScanRecord = scanRecord;
        this.mRssi = rssi;
        this.mTimestampNanos = timestampNanos;
    }

    @TargetApi(value=21)
    ScanResultCompat(ScanResult result) {
        this.mDevice = new BluetoothLeDevice(result.getDevice(), result.getRssi(), result.getScanRecord().getBytes(), System.currentTimeMillis());
        this.mScanRecord = new ScanRecordCompat(result.getScanRecord());
        this.mRssi = result.getRssi();
        this.mTimestampNanos = System.currentTimeMillis();
    }

    private ScanResultCompat(Parcel in) {
        this.readFromParcel(in);
    }

    public void writeToParcel(Parcel dest, int flags) {
        if (this.mDevice != null) {
            dest.writeInt(1);
            this.mDevice.writeToParcel(dest, flags);
        } else {
            dest.writeInt(0);
        }
        if (this.mScanRecord != null) {
            dest.writeInt(1);
            dest.writeByteArray(this.mScanRecord.getBytes());
        } else {
            dest.writeInt(0);
        }
        dest.writeInt(this.mRssi);
        dest.writeLong(this.mTimestampNanos);
    }

    private void readFromParcel(Parcel in) {
        if (in.readInt() == 1) {
            this.mDevice = (BluetoothLeDevice)BluetoothLeDevice.CREATOR.createFromParcel(in);
        }
        if (in.readInt() == 1) {
            this.mScanRecord = ScanRecordCompat.parseFromBytes(in.createByteArray());
        }
        this.mRssi = in.readInt();
        this.mTimestampNanos = in.readLong();
    }

    public int describeContents() {
        return 0;
    }

    public BluetoothLeDevice getLeDevice() {
        return this.mDevice;
    }

    public BluetoothDevice getDevice() {
        if (this.mDevice != null) {
            return this.mDevice.getDevice();
        }
        return null;
    }

    @Nullable
    public ScanRecordCompat getScanRecord() {
        return this.mScanRecord;
    }

    public int getRssi() {
        return this.mRssi;
    }

    public long getTimestampNanos() {
        return this.mTimestampNanos;
    }

    public int hashCode() {
        return ObjectsCompat.hash(this.mDevice, this.mRssi, this.mScanRecord, this.mTimestampNanos);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ScanResultCompat other = (ScanResultCompat)obj;
        return ObjectsCompat.equals(this.mDevice, other.mDevice) && this.mRssi == other.mRssi && ObjectsCompat.equals(this.mScanRecord, other.mScanRecord) && this.mTimestampNanos == other.mTimestampNanos;
    }

    public String toString() {
        return "ScanResult{mDevice=" + this.mDevice + ", mScanRecord=" + ObjectsCompat.toString(this.mScanRecord) + ", mRssi=" + this.mRssi + ", mTimestampNanos=" + this.mTimestampNanos + '}';
    }
}

