/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib;

import android.support.annotation.IntRange;

public class BleParamsOptions {
    private final boolean isDebugMode;
    private final long foregroundScanPeriod;
    private final long foregroundBetweenScanPeriod;
    private final long backgroundScanPeriod;
    private final long backgroundBetweenScanPeriod;
    private final int maxConnectDeviceNum;
    private final int reconnectStrategy;
    private final int reconnectMaxTimes;
    private final long reconnectBaseSpaceTime;
    private final int reconnectedLineToExponentTimes;
    private final int connectTimeOutTimes;

    public boolean isDebugMode() {
        return this.isDebugMode;
    }

    public long getForegroundScanPeriod() {
        return this.foregroundScanPeriod;
    }

    public long getForegroundBetweenScanPeriod() {
        return this.foregroundBetweenScanPeriod;
    }

    public long getBackgroundScanPeriod() {
        return this.backgroundScanPeriod;
    }

    public long getBackgroundBetweenScanPeriod() {
        return this.backgroundBetweenScanPeriod;
    }

    public int getMaxConnectDeviceNum() {
        return this.maxConnectDeviceNum;
    }

    public int getReconnectStrategy() {
        return this.reconnectStrategy;
    }

    public int getReconnectMaxTimes() {
        return this.reconnectMaxTimes;
    }

    public long getReconnectBaseSpaceTime() {
        return this.reconnectBaseSpaceTime;
    }

    public int getReconnectedLineToExponentTimes() {
        return this.reconnectedLineToExponentTimes;
    }

    public int getConnectTimeOutTimes() {
        return this.connectTimeOutTimes;
    }

    private BleParamsOptions(Builder builder) {
        this.isDebugMode = builder.isDebugMode;
        this.foregroundScanPeriod = builder.foregroundScanPeriod;
        this.foregroundBetweenScanPeriod = builder.foregroundBetweenScanPeriod;
        this.backgroundScanPeriod = builder.backgroundScanPeriod;
        this.backgroundBetweenScanPeriod = builder.backgroundBetweenScanPeriod;
        this.maxConnectDeviceNum = builder.maxConnectDeviceNum;
        this.reconnectStrategy = builder.reconnectStrategy;
        this.reconnectMaxTimes = builder.reconnectMaxTimes;
        this.reconnectBaseSpaceTime = builder.reconnectBaseSpaceTime;
        this.reconnectedLineToExponentTimes = builder.reconnectedLineToExponentTimes;
        this.connectTimeOutTimes = builder.connectTimeOutTimes;
    }

    public static BleParamsOptions createDefault() {
        return new Builder().build();
    }

    public static class Builder {
        private boolean isDebugMode = true;
        private long foregroundScanPeriod = 10000L;
        private long foregroundBetweenScanPeriod = 5000L;
        private long backgroundScanPeriod = 10000L;
        private long backgroundBetweenScanPeriod = 300000L;
        private int maxConnectDeviceNum = 5;
        private int reconnectStrategy = 3;
        private int reconnectMaxTimes = Integer.MAX_VALUE;
        private long reconnectBaseSpaceTime = 8000L;
        private int reconnectedLineToExponentTimes = 5;
        private int connectTimeOutTimes = 15000;

        public Builder setDebugMode(boolean isDebugMode) {
            this.isDebugMode = isDebugMode;
            return this;
        }

        public Builder setForegroundScanPeriod(@IntRange(from=0L) long foregroundScanPeriod) {
            if (foregroundScanPeriod < 0L) {
                throw new IllegalArgumentException("Period time must > 0, now is " + foregroundScanPeriod);
            }
            this.foregroundScanPeriod = foregroundScanPeriod;
            return this;
        }

        public Builder setForegroundBetweenScanPeriod(@IntRange(from=0L) long foregroundBetweenScanPeriod) {
            if (foregroundBetweenScanPeriod < 0L) {
                throw new IllegalArgumentException("Period time must > 0, now is " + foregroundBetweenScanPeriod);
            }
            this.foregroundBetweenScanPeriod = foregroundBetweenScanPeriod;
            return this;
        }

        public Builder setBackgroundScanPeriod(@IntRange(from=0L) long backgroundScanPeriod) {
            if (backgroundScanPeriod < 0L) {
                throw new IllegalArgumentException("Period time must > 0, now is " + backgroundScanPeriod);
            }
            this.backgroundScanPeriod = backgroundScanPeriod;
            return this;
        }

        public Builder setBackgroundBetweenScanPeriod(@IntRange(from=0L) long backgroundBetweenScanPeriod) {
            if (backgroundBetweenScanPeriod < 0L) {
                throw new IllegalArgumentException("Period time must > 0, now is " + backgroundBetweenScanPeriod);
            }
            this.backgroundBetweenScanPeriod = backgroundBetweenScanPeriod;
            return this;
        }

        public Builder setMaxConnectDeviceNum(@IntRange(from=1L) int maxConnectDeviceNum) {
            if (maxConnectDeviceNum < 1) {
                throw new IllegalArgumentException("Connect device number must > 1, now is " + maxConnectDeviceNum);
            }
            this.maxConnectDeviceNum = maxConnectDeviceNum;
            return this;
        }

        public Builder setReconnectStrategy(@IntRange(from=1L, to=4L) int reconnectStrategy) {
            if (reconnectStrategy < 1 || reconnectStrategy > 4) {
                throw new IllegalArgumentException("reconnectStrategy range is 1 to 4");
            }
            this.reconnectStrategy = reconnectStrategy;
            return this;
        }

        public Builder setReconnectedLineToExponentTimes(@IntRange(from=1L) int reconnectedLineToExponentTimes) {
            if (reconnectedLineToExponentTimes < 1) {
                throw new IllegalArgumentException("reconnectedLineToExponentTimes value must >= 1, now is " + reconnectedLineToExponentTimes);
            }
            this.reconnectedLineToExponentTimes = reconnectedLineToExponentTimes;
            return this;
        }

        public Builder setReconnectMaxTimes(@IntRange(from=0L) int reconnectMaxTimes) {
            if (reconnectMaxTimes < 0) {
                throw new IllegalArgumentException("Reconnect max times must > 0, now is " + reconnectMaxTimes);
            }
            this.reconnectMaxTimes = reconnectMaxTimes;
            return this;
        }

        public Builder setReconnectBaseSpaceTime(@IntRange(from=1000L) long reconnectBaseSpaceTime) {
            if (reconnectBaseSpaceTime < 1000L) {
                throw new IllegalArgumentException("reconnectBaseSpaceTime must >= 1000ms, now is " + reconnectBaseSpaceTime);
            }
            this.reconnectBaseSpaceTime = reconnectBaseSpaceTime;
            return this;
        }

        public Builder setConnectTimeOutTimes(@IntRange(from=1000L) int connectTimeOutTimes) {
            if (connectTimeOutTimes < 1000) {
                throw new IllegalArgumentException("connectTimeOutTimes must >= 1000ms, now is " + connectTimeOutTimes);
            }
            this.connectTimeOutTimes = connectTimeOutTimes;
            return this;
        }

        public BleParamsOptions build() {
            return new BleParamsOptions(this);
        }
    }
}

