/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCallback;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Looper;
import android.os.SystemClock;
import com.blakequ.bluetooth_manager_lib.BleManager;
import com.blakequ.bluetooth_manager_lib.BleParamsOptions;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothConnectInterface;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothSubScribeData;
import com.blakequ.bluetooth_manager_lib.connect.ConnectState;
import com.blakequ.bluetooth_manager_lib.connect.ConnectStateListener;
import com.blakequ.bluetooth_manager_lib.connect.ReconnectParamsBean;
import com.blakequ.bluetooth_manager_lib.util.BluetoothUtils;
import com.orhanobut.logger.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;

@TargetApi(value=18)
public final class BluetoothConnectManager
extends BluetoothConnectInterface {
    private static final String TAG = "BluetoothConnectManager";
    private static BluetoothConnectManager INSTANCE = null;
    private final BluetoothUtils mBluetoothUtils;
    private BluetoothGattCallback mBluetoothGattCallback;
    private BluetoothManager bluetoothManager;
    private final Map<String, BluetoothGatt> gattMap;
    private final Queue<BluetoothSubScribeData> subscribeQueue;
    private static String serviceUUID;
    private ReconnectParamsBean reconnectParamsBean;
    private List<ConnectStateListener> connectStateListeners;
    private ConnectState currentState = ConnectState.NORMAL;
    private static Object obj;
    private Runnable timeOutTask = new Runnable(){

        @Override
        public void run() {
            if (!BluetoothConnectManager.this.mBluetoothUtils.isBluetoothIsEnable()) {
                Logger.w((String)"Fail to connect device! Bluetooth is not enable!", (Object[])new Object[0]);
                BluetoothConnectManager.this.closeAll();
            }
        }
    };

    public BluetoothConnectManager(Context context) {
        super(context);
        this.subscribeQueue = new ConcurrentLinkedQueue<BluetoothSubScribeData>();
        this.mBluetoothUtils = BluetoothUtils.getInstance(context);
        this.bluetoothManager = (BluetoothManager)context.getSystemService("bluetooth");
        this.gattMap = new ConcurrentHashMap<String, BluetoothGatt>();
        this.connectStateListeners = new ArrayList<ConnectStateListener>();
        BleManager.getBleParamsOptions();
    }

    @Override
    public void release() {
        this.closeAll();
        this.gattMap.clear();
        this.reconnectParamsBean = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BluetoothConnectManager getInstance(Context context) {
        if (INSTANCE == null) {
            Object object = obj;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new BluetoothConnectManager(context);
                }
            }
        }
        return INSTANCE;
    }

    public void setBluetoothGattCallback(BluetoothGattCallback callback) {
        this.mBluetoothGattCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectStateListener(ConnectStateListener listener) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            this.connectStateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectStateListener(ConnectStateListener listener) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            this.connectStateListeners.remove(listener);
        }
    }

    public void addBluetoothSubscribeData(BluetoothSubScribeData data) {
        this.subscribeQueue.add(data);
    }

    public void cleanSubscribeData() {
        this.subscribeQueue.clear();
    }

    public void setServiceUUID(String serviceUUID) {
        BluetoothConnectManager.serviceUUID = serviceUUID;
    }

    @Override
    public BluetoothGatt getBluetoothGatt(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            return this.gattMap.get(address);
        }
        return null;
    }

    @Override
    protected BluetoothGattCallback getBluetoothGattCallback() {
        return this.mBluetoothGattCallback;
    }

    @Override
    protected String getServiceUUID() {
        return serviceUUID;
    }

    @Override
    protected void onDeviceDisconnect(final BluetoothGatt gatt, int errorState) {
        if (!this.checkIsSamsung() || !this.mBluetoothUtils.isBluetoothIsEnable()) {
            Logger.e((String)("Disconnected from GATT server address:" + gatt.getDevice().getAddress()), (Object[])new Object[0]);
            this.close(gatt.getDevice().getAddress());
        } else {
            this.updateConnectStateListener(gatt.getDevice().getAddress(), ConnectState.NORMAL);
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BluetoothConnectManager.this.reconnectDevice(gatt.getDevice().getAddress());
            }
        });
    }

    @Override
    protected void onDeviceConnected(BluetoothGatt gatt) {
        this.updateConnectStateListener(gatt.getDevice().getAddress(), ConnectState.CONNECTED);
        this.reconnectParamsBean = null;
    }

    @Override
    protected void onDiscoverServicesFail(final BluetoothGatt gatt) {
        if (!this.checkIsSamsung() || !this.mBluetoothUtils.isBluetoothIsEnable()) {
            Logger.e((String)("Disconnected from GATT server address:" + gatt.getDevice().getAddress()), (Object[])new Object[0]);
            this.close(gatt.getDevice().getAddress());
        } else {
            this.updateConnectStateListener(gatt.getDevice().getAddress(), ConnectState.NORMAL);
        }
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                BluetoothConnectManager.this.reconnectDevice(gatt.getDevice().getAddress());
            }
        });
    }

    public void updateReconnectParams() {
        this.reconnectParamsBean = null;
    }

    @Override
    protected void onDiscoverServicesSuccess(BluetoothGatt gatt) {
    }

    @Override
    protected Queue<BluetoothSubScribeData> getSubscribeDataQueue() {
        return this.subscribeQueue;
    }

    public boolean isConnectDevice() {
        return this.gattMap.size() != 0;
    }

    public List<BluetoothDevice> getConnectedDevice() {
        if (this.isConnectDevice()) {
            return this.bluetoothManager.getConnectedDevices(7);
        }
        return Collections.EMPTY_LIST;
    }

    public ConnectState getCurrentState() {
        return this.currentState;
    }

    public boolean connect(String address) {
        BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
        if (mAdapter == null || address == null) {
            Logger.w((String)"BluetoothAdapter not initialized or unspecified address.", (Object[])new Object[0]);
            this.updateConnectStateListener(address, ConnectState.NORMAL);
            return false;
        }
        if (!this.mBluetoothUtils.isBluetoothIsEnable()) {
            Logger.e((String)"bluetooth is not enable.", (Object[])new Object[0]);
            this.updateConnectStateListener(address, ConnectState.NORMAL);
            return false;
        }
        if (this.gattMap.containsKey(address)) {
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            Logger.i((String)("Trying to use an existing gatt and reconnection device " + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread())), (Object[])new Object[0]);
            if (mBluetoothGatt.connect()) {
                this.closeOtherDevice(address);
                this.updateConnectStateListener(address, ConnectState.CONNECTING);
                return true;
            }
            this.close(address);
            return false;
        }
        BluetoothDevice device = mAdapter.getRemoteDevice(address);
        if (device != null) {
            BluetoothGatt mBluetoothGatt = device.connectGatt(this.context, false, this.gattCallback);
            if (mBluetoothGatt != null) {
                Logger.d((String)("create a new connection address=" + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread())), (Object[])new Object[0]);
                this.gattMap.put(address, mBluetoothGatt);
                this.closeOtherDevice(address);
                this.updateConnectStateListener(address, ConnectState.CONNECTING);
                return true;
            }
            Logger.e((String)("Get Gatt fail!, address=" + address + " thread:" + (Thread.currentThread() == Looper.getMainLooper().getThread())), (Object[])new Object[0]);
        } else {
            Logger.e((String)("Device not found, address=" + address), (Object[])new Object[0]);
        }
        this.updateConnectStateListener(address, ConnectState.NORMAL);
        return false;
    }

    public boolean close(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            Logger.w((String)("close gatt server " + address), (Object[])new Object[0]);
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            mBluetoothGatt.close();
            this.gattMap.remove(address);
            this.updateConnectStateListener(address, ConnectState.NORMAL);
            return true;
        }
        return false;
    }

    public void closeAll() {
        for (String address : this.gattMap.keySet()) {
            this.close(address);
        }
    }

    public void disconnect(String address) {
        if (!this.isEmpty(address) && this.gattMap.containsKey(address)) {
            this.reconnectParamsBean = new ReconnectParamsBean(address);
            this.reconnectParamsBean.setNumber(1000);
            Logger.w((String)("disconnect gatt server " + address), (Object[])new Object[0]);
            BluetoothGatt mBluetoothGatt = this.gattMap.get(address);
            mBluetoothGatt.disconnect();
            this.updateConnectStateListener(address, ConnectState.NORMAL);
        }
    }

    private void reconnectDevice(final String address) {
        if (this.reconnectParamsBean != null) {
            if (!this.reconnectParamsBean.getAddress().equals(address)) {
                this.reconnectParamsBean.updateAddress(address);
            } else if (this.reconnectParamsBean.getNumber() == 0) {
                this.reconnectParamsBean.updateAddress(address);
            } else if (this.reconnectParamsBean.getNumber() == 1000) {
                Logger.i((String)"reconnect fail! disconnect by hand", (Object[])new Object[0]);
                this.reconnectParamsBean.setNumber(0);
                return;
            }
            this.reconnectParamsBean.addNumber();
        } else {
            this.reconnectParamsBean = new ReconnectParamsBean(address);
        }
        long nextReconnectTime = this.reconnectParamsBean.getNextReconnectTime() - SystemClock.elapsedRealtime();
        if (nextReconnectTime < 0L) {
            nextReconnectTime = 0L;
        }
        Logger.i((String)("next reconnect time " + this.reconnectParamsBean.toString() + " after:" + nextReconnectTime / 1000L + "seconds"), (Object[])new Object[0]);
        this.getMainLooperHandler().postDelayed(new Runnable(){

            @Override
            public void run() {
                if (BluetoothConnectManager.this.mBluetoothUtils.isBluetoothIsEnable()) {
                    boolean isReconncted = false;
                    if (BluetoothConnectManager.this.gattMap.containsKey(address)) {
                        if (BluetoothConnectManager.this.gattMap.size() == 1) {
                            isReconncted = true;
                        }
                    } else if (BluetoothConnectManager.this.gattMap.size() == 0) {
                        isReconncted = true;
                    }
                    if (!BluetoothConnectManager.this.isEmpty(BluetoothConnectManager.this.getConnectedDevice())) {
                        isReconncted = false;
                        BluetoothConnectManager.this.reconnectParamsBean = null;
                    }
                    if (isReconncted && BluetoothConnectManager.this.getConnectedDevice().size() == 0) {
                        Logger.d((String)("reconnecting! will reconnect " + address), (Object[])new Object[0]);
                        if (BluetoothConnectManager.this.reconnectParamsBean != null) {
                            BluetoothConnectManager.this.runOnUiThread(new Runnable(){

                                @Override
                                public void run() {
                                    BluetoothConnectManager.this.connect(address);
                                }
                            });
                        } else {
                            Logger.w((String)"Fail to reconnect, ReconnectParams is null", (Object[])new Object[0]);
                        }
                    } else {
                        Logger.w((String)("Fail to reconnect, refuse! " + address + " flag:" + isReconncted), (Object[])new Object[0]);
                    }
                } else {
                    Logger.w((String)"Fail to reconnect, the bluetooth is disable!", (Object[])new Object[0]);
                }
            }
        }, nextReconnectTime);
    }

    private void closeOtherDevice(String address) {
        if (!this.isEmpty(address)) {
            List<BluetoothDevice> list = this.getConnectedDevice();
            for (BluetoothDevice device : list) {
                if (device.getAddress().equals(address)) continue;
                this.close(device.getAddress());
            }
            for (String ads : this.gattMap.keySet()) {
                BluetoothGatt mBluetoothGatt = this.gattMap.get(ads);
                if (ads.equals(address)) continue;
                this.close(ads);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateConnectStateListener(String address, ConnectState state) {
        List<ConnectStateListener> list = this.connectStateListeners;
        synchronized (list) {
            this.currentState = state;
            if (state == ConnectState.CONNECTING) {
                BleParamsOptions options = BleManager.getBleParamsOptions();
                this.getMainLooperHandler().postDelayed(this.timeOutTask, (long)options.getConnectTimeOutTimes());
            }
            for (ConnectStateListener listener : this.connectStateListeners) {
                if (listener == null) continue;
                listener.onConnectStateChanged(address, state);
            }
        }
    }

    static {
        obj = new Object();
    }
}

