/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanResult;
import android.bluetooth.le.ScanSettings;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresPermission;
import android.support.v4.util.SimpleArrayMap;
import com.blakequ.bluetooth_manager_lib.scan.BluetoothScanManager;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanCallbackCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanFilterCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanRecordCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanResultCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanSettingsCompat;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;

public class BluetoothLeScannerCompat {
    private static final String TAG = "BLeScannerCompat";
    static final BluetoothLeScannerCompatImpl IMPL;

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static void flushPendingScanResults(@NonNull BluetoothAdapter adapter, @NonNull ScanCallbackCompat callbackCompat) {
        IMPL.flushPendingScanResults(adapter, callbackCompat);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static void startScan(@NonNull BluetoothAdapter adapter, @Nullable List<ScanFilterCompat> filters, @NonNull ScanSettingsCompat settings, @NonNull ScanCallbackCompat callbackCompat) {
        IMPL.startScan(adapter, filters, settings, callbackCompat);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static void startScan(@NonNull BluetoothAdapter adapter, @NonNull ScanCallbackCompat callbackCompat) {
        IMPL.startScan(adapter, callbackCompat);
    }

    @RequiresPermission(value="android.permission.BLUETOOTH_ADMIN")
    public static void stopScan(@NonNull BluetoothAdapter adapter, @NonNull ScanCallbackCompat callbackCompat) {
        IMPL.stopScan(adapter, callbackCompat);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = BluetoothScanManager.isAPI21ScanningDisabled() ? new API18BluetoothLeScannerCompatImpl() : (version >= 21 ? new API21BluetoothLeScannerCompatImpl() : new API18BluetoothLeScannerCompatImpl());
    }

    @TargetApi(value=21)
    static class API21ScanCallback
    extends ScanCallback {
        private final WeakReference<ScanCallbackCompat> callbackCompatRef;

        API21ScanCallback(ScanCallbackCompat callbackCompat) {
            this.callbackCompatRef = new WeakReference<ScanCallbackCompat>(callbackCompat);
        }

        public void onScanResult(int callbackType, ScanResult result) {
            ScanCallbackCompat callbackCompat = (ScanCallbackCompat)this.callbackCompatRef.get();
            if (callbackCompat != null) {
                callbackCompat.onScanResult(callbackType, new ScanResultCompat(result));
            }
        }

        public void onBatchScanResults(List<ScanResult> results) {
            ScanCallbackCompat callbackCompat = (ScanCallbackCompat)this.callbackCompatRef.get();
            if (callbackCompat == null) {
                return;
            }
            ArrayList<ScanResultCompat> compatResults = new ArrayList<ScanResultCompat>(results.size());
            for (ScanResult result : results) {
                compatResults.add(new ScanResultCompat(result));
            }
            callbackCompat.onBatchScanResults(compatResults);
        }

        public void onScanFailed(int errorCode) {
            ScanCallbackCompat callbackCompat = (ScanCallbackCompat)this.callbackCompatRef.get();
            if (callbackCompat != null) {
                callbackCompat.onScanFailed(errorCode);
            }
        }
    }

    static class API18ScanCallback
    implements BluetoothAdapter.LeScanCallback {
        private final List<ScanFilterCompat> filters;
        private final WeakReference<ScanCallbackCompat> callbackCompatRef;

        API18ScanCallback(List<ScanFilterCompat> filters, ScanCallbackCompat callbackCompat) {
            this.filters = filters;
            this.callbackCompatRef = new WeakReference<ScanCallbackCompat>(callbackCompat);
        }

        public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
            ScanCallbackCompat callbackCompat = (ScanCallbackCompat)this.callbackCompatRef.get();
            if (callbackCompat == null) {
                return;
            }
            ScanResultCompat result = new ScanResultCompat(device, ScanRecordCompat.parseFromBytes(scanRecord), rssi, System.currentTimeMillis());
            if (this.filters == null) {
                callbackCompat.onScanResult(1, result);
                return;
            }
            for (ScanFilterCompat filter : this.filters) {
                if (!filter.matches(result)) continue;
                callbackCompat.onScanResult(1, result);
                return;
            }
        }
    }

    @TargetApi(value=18)
    static class API18BluetoothLeScannerCompatImpl
    implements BluetoothLeScannerCompatImpl {
        static final SimpleArrayMap<ScanCallbackCompat, API18ScanCallback> callbackMap = new SimpleArrayMap();

        API18BluetoothLeScannerCompatImpl() {
        }

        @Override
        public void flushPendingScanResults(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            new IllegalArgumentException("this method can not found");
        }

        @Override
        public void startScan(BluetoothAdapter adapter, List<ScanFilterCompat> filters, ScanSettingsCompat settings, ScanCallbackCompat callbackCompat) {
            adapter.startLeScan((BluetoothAdapter.LeScanCallback)this.registerCallback(filters, callbackCompat));
        }

        @Override
        public void startScan(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            adapter.startLeScan((BluetoothAdapter.LeScanCallback)this.registerCallback(null, callbackCompat));
        }

        @Override
        public void stopScan(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            API18ScanCallback callback = (API18ScanCallback)callbackMap.remove((Object)callbackCompat);
            if (callback == null) {
                return;
            }
            adapter.stopLeScan((BluetoothAdapter.LeScanCallback)callback);
        }

        private API18ScanCallback registerCallback(List<ScanFilterCompat> filters, ScanCallbackCompat callbackCompat) {
            API18ScanCallback result = (API18ScanCallback)callbackMap.get((Object)callbackCompat);
            if (result != null) {
                return result;
            }
            result = new API18ScanCallback(filters, callbackCompat);
            callbackMap.put((Object)callbackCompat, (Object)result);
            return result;
        }
    }

    @TargetApi(value=21)
    static class API21BluetoothLeScannerCompatImpl
    implements BluetoothLeScannerCompatImpl {
        static final SimpleArrayMap<ScanCallbackCompat, API21ScanCallback> callbackMap = new SimpleArrayMap();

        API21BluetoothLeScannerCompatImpl() {
        }

        @Override
        public void flushPendingScanResults(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            API21ScanCallback result = (API21ScanCallback)((Object)callbackMap.get((Object)callbackCompat));
            if (result == null) {
                return;
            }
            adapter.getBluetoothLeScanner().flushPendingScanResults((ScanCallback)result);
        }

        @Override
        public void startScan(BluetoothAdapter adapter, List<ScanFilterCompat> filters, ScanSettingsCompat settings, ScanCallbackCompat callbackCompat) {
            ArrayList<ScanFilter> scanFilters = null;
            if (filters != null) {
                scanFilters = new ArrayList<ScanFilter>(filters.size());
                for (ScanFilterCompat filter : filters) {
                    scanFilters.add(filter.toApi21());
                }
            }
            if (settings == null) {
                throw new IllegalStateException("Scan settings are null");
            }
            ScanSettings scanSettings = settings.toApi21();
            adapter.getBluetoothLeScanner().startScan(scanFilters, scanSettings, (ScanCallback)this.registerCallback(callbackCompat));
        }

        @Override
        public void startScan(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            adapter.getBluetoothLeScanner().startScan((ScanCallback)this.registerCallback(callbackCompat));
        }

        @Override
        public void stopScan(BluetoothAdapter adapter, ScanCallbackCompat callbackCompat) {
            API21ScanCallback result = (API21ScanCallback)((Object)callbackMap.remove((Object)callbackCompat));
            if (result == null) {
                return;
            }
            adapter.getBluetoothLeScanner().stopScan((ScanCallback)result);
        }

        private API21ScanCallback registerCallback(ScanCallbackCompat callbackCompat) {
            API21ScanCallback result = (API21ScanCallback)((Object)callbackMap.get((Object)callbackCompat));
            if (result != null) {
                return result;
            }
            result = new API21ScanCallback(callbackCompat);
            callbackMap.put((Object)callbackCompat, (Object)result);
            return result;
        }
    }

    static interface BluetoothLeScannerCompatImpl {
        public void flushPendingScanResults(BluetoothAdapter var1, ScanCallbackCompat var2);

        public void startScan(BluetoothAdapter var1, List<ScanFilterCompat> var2, ScanSettingsCompat var3, ScanCallbackCompat var4);

        public void startScan(BluetoothAdapter var1, ScanCallbackCompat var2);

        public void stopScan(BluetoothAdapter var1, ScanCallbackCompat var2);
    }
}

