/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device;

import com.blakequ.bluetooth_manager_lib.device.BeaconType;
import com.blakequ.bluetooth_manager_lib.device.BluetoothLeDevice;
import com.blakequ.bluetooth_manager_lib.device.ibeacon.IBeaconConstants;
import com.blakequ.bluetooth_manager_lib.util.ByteUtils;

public final class BeaconUtils {
    private BeaconUtils() {
    }

    public static BeaconType getBeaconType(byte[] manufacturerData) {
        if (manufacturerData == null || manufacturerData.length == 0) {
            return BeaconType.NOT_A_BEACON;
        }
        if (BeaconUtils.isIBeacon(manufacturerData)) {
            return BeaconType.IBEACON;
        }
        return BeaconType.NOT_A_BEACON;
    }

    public static BeaconType getBeaconType(BluetoothLeDevice device) {
        int key = 255;
        return BeaconUtils.getBeaconType(device.getAdRecordStore().getRecordDataAsString(255).getBytes());
    }

    private static boolean isIBeacon(byte[] manufacturerData) {
        if (manufacturerData.length < 25) {
            return false;
        }
        return ByteUtils.doesArrayBeginWith(manufacturerData, IBeaconConstants.MANUFACTURER_DATA_IBEACON_PREFIX);
    }
}

