/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device.adrecord;

import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.SparseArray;
import com.blakequ.bluetooth_manager_lib.device.adrecord.AdRecord;
import com.blakequ.bluetooth_manager_lib.device.adrecord.AdRecordUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

public class AdRecordStore
implements Parcelable {
    public static final Parcelable.Creator<AdRecordStore> CREATOR = new Parcelable.Creator<AdRecordStore>(){

        public AdRecordStore createFromParcel(Parcel in) {
            return new AdRecordStore(in);
        }

        public AdRecordStore[] newArray(int size) {
            return new AdRecordStore[size];
        }
    };
    private final SparseArray<AdRecord> mAdRecords;
    private final String mLocalNameComplete;
    private final String mLocalNameShort;

    public AdRecordStore(Parcel in) {
        Bundle b = in.readBundle(this.getClass().getClassLoader());
        this.mAdRecords = b.getSparseParcelableArray("records_array");
        this.mLocalNameComplete = b.getString("local_name_complete");
        this.mLocalNameShort = b.getString("local_name_short");
    }

    public AdRecordStore(SparseArray<AdRecord> adRecords) {
        this.mAdRecords = adRecords;
        this.mLocalNameComplete = AdRecordUtils.getRecordDataAsString((AdRecord)this.mAdRecords.get(9));
        this.mLocalNameShort = AdRecordUtils.getRecordDataAsString((AdRecord)this.mAdRecords.get(8));
    }

    public int describeContents() {
        return 0;
    }

    public String getLocalNameComplete() {
        return this.mLocalNameComplete;
    }

    public String getLocalNameShort() {
        return this.mLocalNameShort;
    }

    public AdRecord getRecord(int record) {
        return (AdRecord)this.mAdRecords.get(record);
    }

    public String getRecordDataAsString(int record) {
        return AdRecordUtils.getRecordDataAsString((AdRecord)this.mAdRecords.get(record));
    }

    public Collection<AdRecord> getRecordsAsCollection() {
        return Collections.unmodifiableCollection(AdRecordStore.asList(this.mAdRecords));
    }

    public boolean isRecordPresent(int record) {
        return this.mAdRecords.indexOfKey(record) >= 0;
    }

    public String toString() {
        return "AdRecordStore [mLocalNameComplete=" + this.mLocalNameComplete + ", mLocalNameShort=" + this.mLocalNameShort + "]";
    }

    public void writeToParcel(Parcel parcel, int arg1) {
        Bundle b = new Bundle();
        b.putString("local_name_complete", this.mLocalNameComplete);
        b.putString("local_name_short", this.mLocalNameShort);
        b.putSparseParcelableArray("records_array", this.mAdRecords);
        parcel.writeBundle(b);
    }

    public static <C> Collection<C> asList(SparseArray<C> sparseArray) {
        if (sparseArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(sparseArray.size());
        for (int i = 0; i < sparseArray.size(); ++i) {
            arrayList.add(sparseArray.valueAt(i));
        }
        return arrayList;
    }
}

