/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.device;

import com.blakequ.bluetooth_manager_lib.device.BeaconType;
import com.blakequ.bluetooth_manager_lib.device.BeaconUtils;
import java.util.Arrays;

public abstract class BeaconManufacturerData {
    private final BeaconType mBeaconType;
    private final byte[] mData;

    protected BeaconManufacturerData(BeaconType expectedType, byte[] data) {
        if (BeaconUtils.getBeaconType(data) != expectedType) {
            throw new IllegalArgumentException("Manufacturer record '" + Arrays.toString(data) + "' is not from a " + (Object)((Object)expectedType));
        }
        this.mData = data;
        this.mBeaconType = expectedType;
    }

    public BeaconType getBeaconType() {
        return this.mBeaconType;
    }

    public byte[] getData() {
        return this.mData;
    }
}

