/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.content.Context;
import android.location.LocationManager;
import android.os.Build;
import android.os.Handler;
import android.os.SystemClock;
import android.support.v4.content.ContextCompat;
import com.blakequ.bluetooth_manager_lib.scan.ScanOverListener;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.BluetoothLeScannerCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanCallbackCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanFilterCompat;
import com.blakequ.bluetooth_manager_lib.scan.bluetoothcompat.ScanSettingsCompat;
import com.blakequ.bluetooth_manager_lib.util.BluetoothUtils;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

@TargetApi(value=18)
public class CycledLeScanner {
    private static final String TAG = "CycledLeScanner";
    private boolean isPrintCycleTime = true;
    private final Context mContext;
    private long scanPeriod;
    private long betweenScanPeriod;
    private boolean mBackgroundFlag = false;
    private ScanCallbackCompat scanCallbackCompat;
    private final BluetoothUtils mBluetoothUtils;
    private ScanOverListener scanOverListener;
    private long nextScanStartTime = 0L;
    private long scanStopTime = 0L;
    private long lastScanEndTime = 0L;
    private boolean mScanning = false;
    private boolean isPauseScan = false;
    private boolean isOnceScan = false;
    private boolean isStartNow = false;
    private final Handler mHandler = new Handler();
    private boolean isSetScanSetting = false;
    private ScanSettingsCompat scanSettings;
    private final List<ScanFilterCompat> scanFilterCompats = new CopyOnWriteArrayList<ScanFilterCompat>();

    public CycledLeScanner(Context context, long scanPeriod, long betweenScanPeriod, boolean backgroundFlag, ScanCallbackCompat callbackCompat) {
        this.mContext = context;
        this.scanPeriod = scanPeriod;
        this.betweenScanPeriod = betweenScanPeriod;
        this.scanCallbackCompat = callbackCompat;
        this.mBackgroundFlag = backgroundFlag;
        this.mBluetoothUtils = BluetoothUtils.getInstance(context);
    }

    public void setScanOverListener(ScanOverListener scanOverListener) {
        this.scanOverListener = scanOverListener;
    }

    public void addScanFilterCompats(ScanFilterCompat scanFilter) {
        this.scanFilterCompats.add(scanFilter);
    }

    public void setScanSettings(ScanSettingsCompat scanSettings) {
        this.isSetScanSetting = true;
        this.scanSettings = scanSettings;
    }

    public void startOnceScan() {
        this.isOnceScan = true;
        this.scanLeDevice(true);
    }

    public void setPauseScan(boolean isPauseScan) {
        this.isPauseScan = isPauseScan;
        if (!isPauseScan) {
            this.scanLeDevice(true);
        } else {
            this.scanLeDevice(false);
        }
    }

    public void startScan() {
        this.isPauseScan = false;
        this.scanLeDevice(true);
    }

    public void startScanNow() {
        this.isStartNow = true;
        this.scanLeDevice(true);
    }

    public void setBackgroundMode(long scanPeriod, long betweenScanPeriod, boolean backgroundFlag) {
        if (Build.VERSION.SDK_INT < 18) {
            LogUtils.w(TAG, "Not supported prior to API 18.  Method invocation will be ignored");
            return;
        }
        if (backgroundFlag != this.mBackgroundFlag) {
            long proposedStopTime;
            long proposedNextScanStartTime;
            LogUtils.d(TAG, "restart polling task scanPeriod:" + scanPeriod + " betweenScanPeriod:" + betweenScanPeriod + " backgroundFlag:" + backgroundFlag + " mode:" + this.mBackgroundFlag);
            this.mBackgroundFlag = backgroundFlag;
            this.scanPeriod = scanPeriod;
            this.betweenScanPeriod = betweenScanPeriod;
            long now = SystemClock.elapsedRealtime();
            if (this.nextScanStartTime > now && (proposedNextScanStartTime = this.lastScanEndTime + betweenScanPeriod) < this.nextScanStartTime) {
                LogUtils.d(TAG, "Waiting...Adjusted nextScanStartTime to be" + (proposedNextScanStartTime - now) + " old:" + (this.nextScanStartTime - now));
                this.nextScanStartTime = proposedNextScanStartTime;
            }
            if (this.scanStopTime > now && (proposedStopTime = this.nextScanStartTime + scanPeriod) < this.scanStopTime) {
                LogUtils.d(TAG, "Scanning...Adjusted scanStopTime to be " + (proposedStopTime - now) + " old:" + (this.scanStopTime - now));
                this.scanStopTime = proposedStopTime;
            }
            if (!this.isSetScanSetting || this.scanSettings == null) {
                if (this.mBackgroundFlag) {
                    LogUtils.d(TAG, "starting filtered scan in SCAN_MODE_LOW_POWER");
                    this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(0).build();
                } else {
                    LogUtils.d(TAG, "starting non-filtered scan in SCAN_MODE_LOW_LATENCY");
                    this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(2).build();
                }
            }
        }
    }

    public boolean isScanning() {
        return this.mScanning;
    }

    public boolean isPauseScan() {
        return this.isPauseScan;
    }

    private void scanLeDevice(boolean enable) {
        BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
        if (this.mBluetoothUtils == null || !this.mBluetoothUtils.isBluetoothIsEnable()) {
            LogUtils.e(TAG, "ScanDevice: Scanning fail! BluetoothAdapter is null");
            return;
        }
        if (this.deferScanIfNeeded()) {
            if (!this.isStartNow) {
                return;
            }
            this.isStartNow = false;
        }
        if (enable) {
            if (this.mScanning) {
                LogUtils.d(TAG, "ScanDevice: Scanning is running now !");
                return;
            }
            LogUtils.d(TAG, "ScanDevice: Starting Scanning scanPeriod:" + this.scanPeriod + ", between:" + this.betweenScanPeriod);
            this.mScanning = true;
            if (!this.isPauseScan || this.isOnceScan) {
                try {
                    if (Build.VERSION.SDK_INT < 23 || this.checkLocationPermission()) {
                        if (Build.VERSION.SDK_INT >= 23 && !CycledLeScanner.isGpsProviderEnabled(this.mContext)) {
                            LogUtils.e(TAG, "If SDK>=23, current SDK=" + Build.VERSION.SDK_INT + ", Location info not open and can not scan any device!");
                            this.scanCallbackCompat.onScanFailed(6);
                        } else {
                            LogUtils.i(TAG, "ScanDevice: Start scan...");
                            BluetoothLeScannerCompat.startScan(mAdapter, this.scanFilterCompats, this.getScanSettings(), this.scanCallbackCompat);
                        }
                    } else {
                        this.scanCallbackCompat.onScanFailed(5);
                        LogUtils.e(TAG, "If SDK>=23, current SDK=" + Build.VERSION.SDK_INT + ", Please check the location permission is enabled(ACCESS_COARSE_LOCATION and ACCESS_FINE_LOCATION)");
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    LogUtils.e(TAG, "Internal Android exception scanning for beacons " + e.toString());
                }
                if (this.isOnceScan) {
                    LogUtils.d(TAG, "ScanDevice: Scanning once");
                    this.isOnceScan = false;
                }
            } else {
                LogUtils.d(TAG, "ScanDevice: Pause Scanning");
            }
            this.scanStopTime = SystemClock.elapsedRealtime() + this.scanPeriod;
            this.nextScanStartTime = this.scanStopTime + this.betweenScanPeriod;
            this.scheduleScanStop();
        } else {
            LogUtils.d(TAG, "ScanDevice: Stopping Scan");
            this.stopScan();
        }
    }

    private void scheduleScanStop() {
        long millisecondsUntilStop = this.scanStopTime - SystemClock.elapsedRealtime();
        if (millisecondsUntilStop > 0L) {
            if (this.isPrintCycleTime) {
                LogUtils.d(TAG, "Waiting to stop scan cycle for another " + millisecondsUntilStop + " milliseconds");
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    CycledLeScanner.this.scheduleScanStop();
                }
            }, millisecondsUntilStop > 1000L ? 1000L : millisecondsUntilStop);
        } else {
            LogUtils.d(TAG, "Stop cycle scan");
            this.stopScan();
        }
    }

    private void stopScan() {
        if (this.scanOverListener != null) {
            this.scanOverListener.onScanOver();
        }
        if (this.mScanning) {
            BluetoothAdapter mAdapter = this.mBluetoothUtils.getBluetoothAdapter();
            if (mAdapter != null && this.mBluetoothUtils.isBluetoothIsEnable()) {
                try {
                    BluetoothLeScannerCompat.stopScan(mAdapter, this.scanCallbackCompat);
                    this.lastScanEndTime = SystemClock.elapsedRealtime();
                    LogUtils.d(TAG, "stopping bluetooth le scan " + this.lastScanEndTime);
                }
                catch (Exception e) {
                    LogUtils.w(TAG, "Internal Android exception scanning for beacons " + e.toString());
                }
            } else {
                LogUtils.d(TAG, "Bluetooth is disabled.  Cannot scan for beacons.");
            }
            this.nextScanStartTime = SystemClock.elapsedRealtime() + this.betweenScanPeriod;
            if (!this.isPauseScan) {
                this.scanLeDevice(true);
            }
        }
        this.mScanning = false;
    }

    private boolean deferScanIfNeeded() {
        long millisecondsUntilStart = this.nextScanStartTime - SystemClock.elapsedRealtime();
        if (millisecondsUntilStart > 0L) {
            if (this.isPrintCycleTime) {
                LogUtils.d(TAG, "Waiting to start next Bluetooth scan for another " + millisecondsUntilStart + " milliseconds");
            }
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (!CycledLeScanner.this.isPauseScan) {
                        CycledLeScanner.this.scanLeDevice(true);
                    }
                }
            }, millisecondsUntilStart > 1000L ? 1000L : millisecondsUntilStart);
            return true;
        }
        LogUtils.d(TAG, "Start cycle scan");
        return false;
    }

    private ScanSettingsCompat getScanSettings() {
        if (this.scanSettings == null) {
            if (this.mBackgroundFlag) {
                LogUtils.d(TAG, "starting filtered scan in SCAN_MODE_LOW_POWER");
                this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(0).build();
            } else {
                LogUtils.d(TAG, "starting non-filtered scan in SCAN_MODE_LOW_LATENCY");
                this.scanSettings = new ScanSettingsCompat.Builder().setScanMode(2).build();
            }
        }
        return this.scanSettings;
    }

    public static boolean isGpsProviderEnabled(Context context) {
        LocationManager service = (LocationManager)context.getSystemService("location");
        return service.isProviderEnabled("gps");
    }

    private boolean checkLocationPermission() {
        return this.checkPermission("android.permission.ACCESS_COARSE_LOCATION") || this.checkPermission("android.permission.ACCESS_FINE_LOCATION");
    }

    private boolean checkPermission(String permission) {
        return ContextCompat.checkSelfPermission((Context)this.mContext, (String)permission) == 0;
    }
}

