/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib.connect;

import java.util.UUID;

public class BluetoothSubScribeData {
    private UUID characteristicUUID;
    private byte[] characteristicValue;
    private UUID descriptorUUID;
    private byte[] descriptorValue;
    private Type operatorType;

    private BluetoothSubScribeData(UUID characteristicUUID, byte[] characteristicValue, UUID descriptorUUID, byte[] descriptorValue, Type operatorType) {
        this.characteristicUUID = characteristicUUID;
        this.characteristicValue = characteristicValue;
        this.descriptorUUID = descriptorUUID;
        this.descriptorValue = descriptorValue;
        this.operatorType = operatorType;
    }

    private BluetoothSubScribeData(UUID characteristicUUID, Type operatorType) {
        this.characteristicUUID = characteristicUUID;
        this.operatorType = operatorType;
    }

    public UUID getCharacteristicUUID() {
        return this.characteristicUUID;
    }

    public byte[] getCharacteristicValue() {
        return this.characteristicValue;
    }

    public UUID getDescriptorUUID() {
        return this.descriptorUUID;
    }

    public byte[] getDescriptorValue() {
        return this.descriptorValue;
    }

    public Type getOperatorType() {
        return this.operatorType;
    }

    public static enum Type {
        CHAR_WIRTE,
        CHAR_READ,
        DESC_WRITE,
        DESC_READ,
        NOTIFY;

    }

    public static final class Builder {
        private UUID characteristicUUID;
        private byte[] characteristicValue;
        private UUID descriptorUUID;
        private byte[] descriptorValue;
        private Type operatorType;

        public Builder setCharacteristicRead(UUID characteristicUUID) {
            this.operatorType = Type.CHAR_READ;
            this.characteristicUUID = characteristicUUID;
            return this;
        }

        public Builder setCharacteristicWrite(UUID characteristicUUID, byte[] characteristicValue) {
            this.operatorType = Type.CHAR_WIRTE;
            this.characteristicUUID = characteristicUUID;
            this.characteristicValue = characteristicValue;
            return this;
        }

        public Builder setDescriptorRead(UUID characteristicUUID, UUID descriptorUUID) {
            this.operatorType = Type.DESC_READ;
            this.characteristicUUID = characteristicUUID;
            this.descriptorUUID = descriptorUUID;
            return this;
        }

        public Builder setDescriptorWrite(UUID characteristicUUID, UUID descriptorUUID, byte[] descriptorValue) {
            this.operatorType = Type.DESC_WRITE;
            this.characteristicUUID = characteristicUUID;
            this.descriptorUUID = descriptorUUID;
            this.descriptorValue = descriptorValue;
            return this;
        }

        public Builder setCharacteristicNotify(UUID characteristicNotificationUUID) {
            this.operatorType = Type.NOTIFY;
            this.characteristicUUID = characteristicNotificationUUID;
            this.descriptorUUID = UUID.fromString("00002902-0000-1000-8000-00805f9b34fb");
            return this;
        }

        public BluetoothSubScribeData build() {
            if (this.characteristicUUID == null) {
                throw new IllegalArgumentException("invalid characteristic, and characteristic can not be null");
            }
            BluetoothSubScribeData data = null;
            switch (this.operatorType) {
                case CHAR_READ: {
                    data = new BluetoothSubScribeData(this.characteristicUUID, this.operatorType);
                    break;
                }
                case CHAR_WIRTE: {
                    if (this.characteristicValue == null) {
                        throw new IllegalArgumentException("invalid null characteristic value");
                    }
                    data = new BluetoothSubScribeData(this.characteristicUUID, this.characteristicValue, null, null, this.operatorType);
                    break;
                }
                case DESC_READ: {
                    if (this.descriptorUUID == null) {
                        throw new IllegalArgumentException("invalid null descriptor UUID");
                    }
                    data = new BluetoothSubScribeData(this.characteristicUUID, null, this.descriptorUUID, null, this.operatorType);
                    break;
                }
                case DESC_WRITE: {
                    if (this.descriptorUUID == null || this.descriptorValue == null) {
                        throw new IllegalArgumentException("invalid null descriptor UUID or value");
                    }
                    data = new BluetoothSubScribeData(this.characteristicUUID, null, this.descriptorUUID, this.descriptorValue, this.operatorType);
                    break;
                }
                case NOTIFY: {
                    if (this.descriptorUUID == null) {
                        throw new IllegalArgumentException("invalid null descriptor UUID");
                    }
                    data = new BluetoothSubScribeData(this.characteristicUUID, null, this.descriptorUUID, null, this.operatorType);
                }
            }
            return data;
        }
    }
}

