/*
 * Decompiled with CFR 0.152.
 */
package com.blakequ.bluetooth_manager_lib;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.Build;
import android.support.annotation.NonNull;
import com.blakequ.bluetooth_manager_lib.BleNotAvailableException;
import com.blakequ.bluetooth_manager_lib.connect.BluetoothConnectManager;
import com.blakequ.bluetooth_manager_lib.connect.multiple.MultiConnectManager;
import com.blakequ.bluetooth_manager_lib.scan.BluetoothScanManager;
import com.blakequ.bluetooth_manager_lib.util.LogUtils;

@TargetApi(value=18)
public final class BleManager {
    private BluetoothConnectManager singleConnectManager;
    private BluetoothScanManager scanManager;
    private MultiConnectManager multiConnectManager;
    private static Object obj = new Object();
    private static BleManager INSTANCE = null;

    private BleManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BleManager getInstance() {
        if (INSTANCE == null) {
            Object object = obj;
            synchronized (object) {
                if (INSTANCE == null) {
                    INSTANCE = new BleManager();
                }
            }
        }
        return INSTANCE;
    }

    public BluetoothConnectManager getConnectManager(@NonNull Context context) {
        return BluetoothConnectManager.getInstance(context);
    }

    public BluetoothScanManager getScanManager(@NonNull Context context) {
        return BluetoothScanManager.getInstance(context);
    }

    public MultiConnectManager getMultiConnectManager(@NonNull Context context) {
        return MultiConnectManager.getInstance(context);
    }

    public static boolean checkAvailability(Context context) throws BleNotAvailableException {
        if (BleManager.isSDKAvailable()) {
            if (!context.getPackageManager().hasSystemFeature("android.hardware.bluetooth_le")) {
                throw new BleNotAvailableException("Bluetooth LE not supported by this device");
            }
            if (((BluetoothManager)context.getSystemService("bluetooth")).getAdapter().isEnabled()) {
                return true;
            }
        }
        return false;
    }

    public static boolean isSDKAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            throw new BleNotAvailableException("Bluetooth LE not supported by this device");
        }
        return true;
    }

    public void setLogDebugMode(boolean isDebugMode) {
        LogUtils.setDebugLog(isDebugMode);
    }
}

