/*
 * Decompiled with CFR 0.152.
 */
package com.blade.kit;

import com.blade.kit.Assert;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class CollectionKit {
    public static <T> boolean isEmpty(T[] array) {
        return null == array || array.length == 0;
    }

    public static <T> boolean isNotEmpty(T[] array) {
        return null != array && array.length > 0;
    }

    public static <T> boolean isEmpty(Collection<T> collection) {
        return null == collection || collection.size() == 0;
    }

    public static <T> boolean isNotEmpty(Collection<T> collection) {
        return null != collection && collection.size() > 0;
    }

    public static <K, V> HashMap<K, V> newMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @SafeVarargs
    public static <T> List<T> newLists(T ... values) {
        if (null == values || values.length == 0) {
            Assert.notNull(values, "values not is null.");
        }
        return Arrays.asList(values);
    }

    @SafeVarargs
    public static <T> Set<T> newSets(T ... values) {
        if (null == values || values.length == 0) {
            Assert.notNull(values, "values not is null.");
        }
        return new HashSet<T>(Arrays.asList(values));
    }

    private CollectionKit() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

