/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;
import com.bitly.Response;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

abstract class HttpAsyncTask
extends AsyncTask<Void, Void, Void> {
    private final Uri uri;

    public HttpAsyncTask(Uri uri) {
        this.uri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Void doInBackground(Void ... params) {
        HttpURLConnection connection = null;
        BufferedReader reader = null;
        try {
            String line;
            connection = (HttpURLConnection)new URL(this.uri.toString()).openConnection();
            reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(connection.getInputStream())));
            StringBuilder result = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                result.append(line);
            }
            this.onResponse(new Response(new JSONObject(result.toString())));
        }
        catch (Exception e) {
            this.onException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    Log.e((String)"BitlySDK", (String)"Bitly SDK failed to close reader", (Throwable)e);
                }
            }
            if (connection != null) {
                connection.disconnect();
            }
        }
        return null;
    }

    public final void executeSafely() {
        if (Build.VERSION.SDK_INT >= 11 && AsyncTask.THREAD_POOL_EXECUTOR != null) {
            this.executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new Void[0]);
        } else {
            this.execute(new Void[0]);
        }
    }

    abstract void onResponse(Response var1);

    abstract void onException(Exception var1);
}

