/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Handler;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import java.util.ArrayList;
import java.util.List;

class WebHelper {
    private static final String STABLE_PACKAGE = "com.android.chrome";
    private static final String BETA_PACKAGE = "com.chrome.beta";
    private static final String DEV_PACKAGE = "com.chrome.dev";
    private static final String LOCAL_PACKAGE = "com.google.android.apps.chrome";
    private static final String ACTION_CUSTOM_TABS_CONNECTION = "android.support.customtabs.action.CustomTabsService";
    private static CustomTabsServiceConnection connection;
    private static WebView webView;

    WebHelper() {
    }

    static void loadUri(Context context, Uri uri, final Callback callback) {
        String packageName = WebHelper.getPackageNameToUse(context);
        if (packageName != null) {
            WebHelper.launchUrl(context, uri, callback);
        } else {
            webView = new WebView(context);
            webView.setWebViewClient(new WebViewClient(){

                public final void onPageStarted(WebView view, String url, Bitmap favicon) {
                    super.onPageStarted(view, url, favicon);
                    callback.onPageStarted();
                }

                public final void onPageFinished(WebView view, String url) {
                    super.onPageFinished(view, url);
                    webView = null;
                    callback.onPageFinished();
                }
            });
            webView.loadUrl(uri.toString());
        }
    }

    private static String getPackageNameToUse(Context context) {
        PackageManager pm = context.getPackageManager();
        Intent activityIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)"http://www.example.com"));
        ResolveInfo defaultViewHandlerInfo = pm.resolveActivity(activityIntent, 0);
        String defaultViewHandlerPackageName = null;
        if (defaultViewHandlerInfo != null) {
            defaultViewHandlerPackageName = defaultViewHandlerInfo.activityInfo.packageName;
        }
        List resolvedActivityList = pm.queryIntentActivities(activityIntent, 0);
        ArrayList<String> packagesSupportingCustomTabs = new ArrayList<String>();
        for (ResolveInfo info : resolvedActivityList) {
            Intent serviceIntent = new Intent();
            serviceIntent.setAction(ACTION_CUSTOM_TABS_CONNECTION);
            serviceIntent.setPackage(info.activityInfo.packageName);
            if (pm.resolveService(serviceIntent, 0) == null) continue;
            packagesSupportingCustomTabs.add(info.activityInfo.packageName);
        }
        String packageNameToUse = null;
        if (packagesSupportingCustomTabs.isEmpty()) {
            packageNameToUse = null;
        } else if (packagesSupportingCustomTabs.size() == 1) {
            packageNameToUse = (String)packagesSupportingCustomTabs.get(0);
        } else if (!TextUtils.isEmpty((CharSequence)defaultViewHandlerPackageName) && !WebHelper.hasSpecializedHandlerIntents(context, activityIntent) && packagesSupportingCustomTabs.contains(defaultViewHandlerPackageName)) {
            packageNameToUse = defaultViewHandlerPackageName;
        } else if (packagesSupportingCustomTabs.contains(STABLE_PACKAGE)) {
            packageNameToUse = STABLE_PACKAGE;
        } else if (packagesSupportingCustomTabs.contains(BETA_PACKAGE)) {
            packageNameToUse = BETA_PACKAGE;
        } else if (packagesSupportingCustomTabs.contains(DEV_PACKAGE)) {
            packageNameToUse = DEV_PACKAGE;
        } else if (packagesSupportingCustomTabs.contains(LOCAL_PACKAGE)) {
            packageNameToUse = LOCAL_PACKAGE;
        }
        return packageNameToUse;
    }

    private static boolean hasSpecializedHandlerIntents(Context context, Intent intent) {
        try {
            PackageManager pm = context.getPackageManager();
            List handlers = pm.queryIntentActivities(intent, 64);
            if (handlers == null || handlers.size() == 0) {
                return false;
            }
            for (ResolveInfo resolveInfo : handlers) {
                IntentFilter filter = resolveInfo.filter;
                if (filter == null || filter.countDataAuthorities() == 0 || filter.countDataPaths() == 0 || resolveInfo.activityInfo == null) continue;
                return true;
            }
        }
        catch (RuntimeException e) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK Failed to determine specialized handler intents", (Throwable)e);
        }
        return false;
    }

    private static void launchUrl(Context context, final Uri uri, final Callback callback) {
        String packageName = WebHelper.getPackageNameToUse(context);
        if (packageName == null) {
            return;
        }
        connection = new CustomTabsServiceConnection(){
            private CustomTabsClient client;
            private CustomTabsSession session;

            public void onCustomTabsServiceConnected(ComponentName name, CustomTabsClient newClient) {
                this.client = newClient;
                this.client.warmup(0L);
                this.session = this.client.newSession(null);
                if (this.session != null) {
                    this.session.mayLaunchUrl(uri, null, null);
                    new Handler().postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            callback.onPageFinished();
                            this.onServiceDisconnected(null);
                        }
                    }, 1000L);
                }
            }

            public void onServiceDisconnected(ComponentName name) {
                this.client = null;
                this.session = null;
                connection = null;
            }
        };
        CustomTabsClient.bindCustomTabsService((Context)context, (String)packageName, (CustomTabsServiceConnection)connection);
    }

    static interface Callback {
        public void onPageStarted();

        public void onPageFinished();
    }
}

