/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.bitly.Bitly;
import com.bitly.Error;
import com.bitly.HttpAsyncTask;
import com.bitly.Response;

class Decoder {
    Decoder() {
    }

    private static String clickUrl() {
        return Bitly.baseUrl() + "api/click";
    }

    private static String deeplinkUrl() {
        return Bitly.baseUrl() + "v3/deferred_deeplink/lookup";
    }

    static void handle(Intent intent) {
        if (intent == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid intent found to process");
            return;
        }
        Decoder.handle(Decoder.getLink(intent));
    }

    static void handle(Error error) {
        if (error == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid error found to process");
            return;
        }
        Decoder.handle(error.getOriginalUrl());
    }

    private static void handle(String link) {
        if (TextUtils.isEmpty((CharSequence)link)) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid link found to process");
            return;
        }
        String bitlink = Bitly.domainSupported(link) ? link : (Bitly.schemeSupported(link) ? Decoder.parseCustomScheme(link) : null);
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            try {
                Uri.Builder builder = Uri.parse((String)Decoder.clickUrl()).buildUpon().appendQueryParameter("app_id", Bitly.currentAppId()).appendQueryParameter("device_id", Bitly.currentDeviceId()).appendQueryParameter("device_id_type", "android").appendQueryParameter("link", bitlink);
                Decoder.processLinkCall(builder.build(), link, bitlink, Bitly.currentCallback(), null);
            }
            catch (Exception e) {
                Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse link: " + e.getMessage()));
                if (Bitly.currentCallback() != null) {
                    Bitly.currentCallback().onError(new Error(e.getMessage(), e, link, bitlink));
                }
            }
        } else {
            Log.d((String)"BitlySDK", (String)String.format("Bitly SDK URL %s is not supported by config", link));
        }
    }

    static void handleDeeplink(Context context, boolean correlated) {
        Decoder.handleDeeplink(context, 1000, correlated);
    }

    private static void handleDeeplink(final Context context, final int delay, final boolean correlated) {
        SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if ((long)delay <= 8000L) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Uri.Builder builder = Uri.parse((String)Decoder.deeplinkUrl()).buildUpon().appendQueryParameter("app_id", Bitly.currentAppId()).appendQueryParameter("device_id", Bitly.currentDeviceId()).appendQueryParameter("device_id_type", "android");
                    Decoder.processLinkCall(builder.build(), null, null, new Bitly.Callback(){

                        @Override
                        public void onResponse(Response response) {
                            if (!TextUtils.isEmpty((CharSequence)response.getUrl()) && Bitly.currentCallback() != null) {
                                Bitly.currentCallback().onResponse(response);
                            }
                        }

                        @Override
                        public void onError(Error error) {
                            if (Bitly.currentCallback() != null) {
                                Bitly.currentCallback().onError(error);
                            }
                        }
                    }, new RetryCallback(){

                        @Override
                        public void onPostExecute() {
                            if (correlated) {
                                Decoder.handleDeeplink(context, delay + delay, correlated);
                            }
                        }
                    });
                }
            }, (long)delay);
        } else {
            Log.d((String)"BitlySDK", (String)"Bitly SDK found no deeplink");
        }
    }

    private static void processLinkCall(Uri uri, final String link, final String bitlink, final Bitly.Callback callback, final RetryCallback retryCallback) {
        new HttpAsyncTask(uri){

            @Override
            void onResponse(Response response) {
                Log.d((String)"BitlySDK", (String)"Bitly SDK parsing JSON response and calling handler");
                if (callback != null) {
                    callback.onResponse(response);
                }
            }

            @Override
            void onException(Exception e) {
                Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse JSON: " + e.getMessage()));
                if (callback != null) {
                    callback.onError(new Error(e.getMessage(), e, link, bitlink));
                }
            }

            protected void onPostExecute(Void aVoid) {
                super.onPostExecute((Object)aVoid);
                if (retryCallback != null) {
                    retryCallback.onPostExecute();
                }
            }
        }.execute(new Void[0]);
    }

    private static String parseCustomScheme(String url) {
        String bitlink = Uri.parse((String)url).getQueryParameter("bitly_bitlink");
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            bitlink = "http://" + bitlink;
        }
        return bitlink;
    }

    private static String getLink(Intent intent) {
        if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            return intent.getData().toString();
        }
        return null;
    }

    private static interface RetryCallback {
        public void onPostExecute();
    }
}

