/*
 * Decompiled with CFR 0.152.
 */
package com.bitly;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import android.util.Log;
import com.bitly.Bitly;
import com.bitly.Error;
import com.bitly.Response;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.json.JSONObject;

class Decoder {
    Decoder() {
    }

    private static String clickUrl() {
        return Bitly.baseUrl() + "api/click";
    }

    private static String deeplinkUrl() {
        return Bitly.baseUrl() + "v3/deferred_deeplink/lookup";
    }

    static void handle(Intent intent) {
        if (intent == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid intent found to process");
            return;
        }
        Decoder.handle(Decoder.getLink(intent));
    }

    static void handle(Error error) {
        if (error == null) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid error found to process");
            return;
        }
        Decoder.handle(error.getOriginalUrl());
    }

    private static void handle(String link) {
        if (TextUtils.isEmpty((CharSequence)link)) {
            Log.d((String)"BitlySDK", (String)"Bitly SDK no valid link found to process");
            return;
        }
        String bitlink = Bitly.domainSupported(link) ? link : (Bitly.schemeSupported(link) ? Decoder.parseCustomScheme(link) : null);
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            try {
                Uri.Builder builder = Uri.parse((String)Decoder.clickUrl()).buildUpon().appendQueryParameter("app_id", Bitly.currentAppId()).appendQueryParameter("device_id", Bitly.currentDeviceId()).appendQueryParameter("device_id_type", "android").appendQueryParameter("link", bitlink);
                Decoder.processLinkCall(builder.build(), link, bitlink, Bitly.currentCallback(), null);
            }
            catch (Exception e) {
                Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse link: " + e.getMessage()));
                if (Bitly.currentCallback() != null) {
                    Bitly.currentCallback().onError(new Error(e.getMessage(), e, link, bitlink));
                }
            }
        } else {
            Log.d((String)"BitlySDK", (String)String.format("Bitly SDK URL %s is not supported by config", link));
        }
    }

    public static void handleDeeplink(Context context) {
        Decoder.handleDeeplink(context, 1000);
    }

    private static void handleDeeplink(final Context context, final int delay) {
        final SharedPreferences sharedPreferences = PreferenceManager.getDefaultSharedPreferences((Context)context);
        if (delay <= 8000 && sharedPreferences.getBoolean("bitly.should.check.deeplink", true)) {
            new Handler().postDelayed(new Runnable(){

                @Override
                public void run() {
                    Uri.Builder builder = Uri.parse((String)Decoder.deeplinkUrl()).buildUpon().appendQueryParameter("app_id", Bitly.currentAppId()).appendQueryParameter("device_id", Bitly.currentDeviceId()).appendQueryParameter("device_id_type", "android");
                    Decoder.processLinkCall(builder.build(), null, null, new Bitly.Callback(){

                        @Override
                        public void onResponse(Response response) {
                            if (!TextUtils.isEmpty((CharSequence)response.getUrl())) {
                                if (Bitly.currentCallback() != null) {
                                    Bitly.currentCallback().onResponse(response);
                                }
                                sharedPreferences.edit().putBoolean("bitly.should.check.deeplink", false).apply();
                            }
                        }

                        @Override
                        public void onError(Error error) {
                            if (Bitly.currentCallback() != null) {
                                Bitly.currentCallback().onError(error);
                            }
                            sharedPreferences.edit().putBoolean("bitly.should.check.deeplink", false).apply();
                        }
                    }, new RetryCallback(){

                        @Override
                        public void onPostExecute() {
                            Decoder.handleDeeplink(context, delay + delay);
                        }
                    });
                }
            }, (long)delay);
        } else {
            Log.d((String)"BitlySDK", (String)"Bitly SDK found no deeplink");
            sharedPreferences.edit().putBoolean("bitly.should.check.deeplink", false).apply();
        }
    }

    private static void processLinkCall(final Uri uri, final String link, final String bitlink, final Bitly.Callback callback, final RetryCallback retryCallback) {
        new AsyncTask<Void, Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected Void doInBackground(Void ... params) {
                HttpURLConnection connection = null;
                BufferedReader reader = null;
                try {
                    String line;
                    connection = (HttpURLConnection)new URL(uri.toString()).openConnection();
                    reader = new BufferedReader(new InputStreamReader(new BufferedInputStream(connection.getInputStream())));
                    StringBuilder result = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        result.append(line);
                    }
                    Response response = new Response(new JSONObject(result.toString()));
                    Log.d((String)"BitlySDK", (String)"Bitly SDK parsing JSON response and calling handler");
                    if (callback != null) {
                        callback.onResponse(response);
                    }
                }
                catch (Exception e) {
                    Log.d((String)"BitlySDK", (String)("Bitly SDK failed to parse JSON: " + e.getMessage()));
                    if (callback != null) {
                        callback.onError(new Error(e.getMessage(), e, link, bitlink));
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {
                            Log.e((String)"BitlySDK", (String)"Bitly SDK failed to close reader", (Throwable)e);
                        }
                    }
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
                return null;
            }

            protected void onPostExecute(Void aVoid) {
                super.onPostExecute((Object)aVoid);
                if (retryCallback != null) {
                    retryCallback.onPostExecute();
                }
            }
        }.execute((Object[])new Void[0]);
    }

    private static String parseCustomScheme(String url) {
        String bitlink = Uri.parse((String)url).getQueryParameter("bitly_bitlink");
        if (!TextUtils.isEmpty((CharSequence)bitlink)) {
            bitlink = "http://" + bitlink;
        }
        return bitlink;
    }

    private static String getLink(Intent intent) {
        if ("android.intent.action.VIEW".equals(intent.getAction()) && intent.getData() != null) {
            return intent.getData().toString();
        }
        return null;
    }

    private static interface RetryCallback {
        public void onPostExecute();
    }
}

