/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.scheduling;

import android.annotation.TargetApi;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.birbit.android.jobqueue.JobManager;
import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.scheduling.FrameworkScheduler;
import com.birbit.android.jobqueue.scheduling.Scheduler;

@TargetApi(value=21)
public abstract class FrameworkJobSchedulerService
extends JobService {
    public static FrameworkScheduler createSchedulerFor(Context appContext, Class<? extends FrameworkJobSchedulerService> klass) {
        if (FrameworkJobSchedulerService.class == klass) {
            throw new IllegalArgumentException("You must create a service that extends FrameworkJobSchedulerService");
        }
        return new FrameworkScheduler(klass);
    }

    public void onCreate() {
        super.onCreate();
        FrameworkScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            scheduler.setJobService(this);
        } else {
            JqLog.e("FrameworkJobSchedulerService has been created but it does not have a scheduler. You must initialize JobManager before the service is created.", new Object[0]);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        FrameworkScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            scheduler.setJobService(null);
        } else {
            JqLog.e("FrameworkJobSchedulerService is being destroyed but it does not have a scheduler :/. You must initialize JobManager before the service is created.", new Object[0]);
        }
    }

    public boolean onStartJob(JobParameters params) {
        FrameworkScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            return scheduler.onStartJob(params);
        }
        JqLog.e("FrameworkJobSchedulerService has been triggered but it does not have a scheduler. You must initialize JobManager before the service is created.", new Object[0]);
        return false;
    }

    public boolean onStopJob(JobParameters params) {
        FrameworkScheduler scheduler = this.getScheduler();
        if (scheduler != null) {
            return scheduler.onStopJob(params);
        }
        JqLog.e("FrameworkJobSchedulerService has been stopped but it does not have a scheduler. You must initialize JobManager before the service is created.", new Object[0]);
        return false;
    }

    @Nullable
    private FrameworkScheduler getScheduler() {
        Scheduler scheduler = this.getJobManager().getScheduler();
        if (scheduler instanceof FrameworkScheduler) {
            return (FrameworkScheduler)scheduler;
        }
        JqLog.e("FrameworkJobSchedulerService has been created but the JobManager does not have a scheduler created by FrameworkJobSchedulerService.", new Object[0]);
        return null;
    }

    @NonNull
    protected abstract JobManager getJobManager();
}

