/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.network;

import android.annotation.TargetApi;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.os.Build;
import android.os.PowerManager;
import com.birbit.android.jobqueue.network.NetworkEventProvider;
import com.birbit.android.jobqueue.network.NetworkUtil;

public class NetworkUtilImpl
implements NetworkUtil,
NetworkEventProvider {
    private NetworkEventProvider.Listener listener;

    public NetworkUtilImpl(Context context) {
        context = context.getApplicationContext();
        if (Build.VERSION.SDK_INT >= 21) {
            if (Build.VERSION.SDK_INT >= 23) {
                this.listenForIdle(context);
            }
            this.listenNetworkViaConnectivityManager(context);
        } else {
            context.registerReceiver(new BroadcastReceiver(){

                public void onReceive(Context context, Intent intent) {
                    NetworkUtilImpl.this.dispatchNetworkChange(context);
                }
            }, NetworkUtilImpl.getNetworkIntentFilter());
        }
    }

    @TargetApi(value=23)
    private void listenNetworkViaConnectivityManager(final Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkRequest request = new NetworkRequest.Builder().addCapability(12).addCapability(13).build();
        cm.registerNetworkCallback(request, new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                NetworkUtilImpl.this.dispatchNetworkChange(context);
            }
        });
    }

    @TargetApi(value=23)
    private void listenForIdle(Context context) {
        context.registerReceiver(new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                NetworkUtilImpl.this.dispatchNetworkChange(context);
            }
        }, new IntentFilter("android.os.action.DEVICE_IDLE_MODE_CHANGED"));
    }

    void dispatchNetworkChange(Context context) {
        if (this.listener == null) {
            return;
        }
        this.listener.onNetworkChange(this.getNetworkStatus(context));
    }

    @Override
    public int getNetworkStatus(Context context) {
        if (NetworkUtilImpl.isDozing(context)) {
            return 0;
        }
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo netInfo = cm.getActiveNetworkInfo();
        if (netInfo == null) {
            return 0;
        }
        if (netInfo.getType() == 1 || netInfo.getType() == 9) {
            return 2;
        }
        return 1;
    }

    @TargetApi(value=23)
    private static IntentFilter getNetworkIntentFilter() {
        IntentFilter networkIntentFilter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        if (Build.VERSION.SDK_INT >= 23) {
            networkIntentFilter.addAction("android.os.action.DEVICE_IDLE_MODE_CHANGED");
        }
        return networkIntentFilter;
    }

    @TargetApi(value=23)
    private static boolean isDozing(Context context) {
        if (Build.VERSION.SDK_INT >= 23) {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            return powerManager.isDeviceIdleMode() && !powerManager.isIgnoringBatteryOptimizations(context.getPackageName());
        }
        return false;
    }

    @Override
    public void setListener(NetworkEventProvider.Listener listener) {
        this.listener = listener;
    }
}

