/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.messaging;

import com.birbit.android.jobqueue.log.JqLog;
import com.birbit.android.jobqueue.messaging.DelayedMessageBag;
import com.birbit.android.jobqueue.messaging.Message;
import com.birbit.android.jobqueue.messaging.MessageFactory;
import com.birbit.android.jobqueue.messaging.MessagePredicate;
import com.birbit.android.jobqueue.messaging.MessageQueue;
import com.birbit.android.jobqueue.messaging.MessageQueueConsumer;
import com.birbit.android.jobqueue.messaging.Type;
import com.birbit.android.jobqueue.messaging.UnsafeMessageQueue;
import com.birbit.android.jobqueue.timer.Timer;
import java.util.concurrent.atomic.AtomicBoolean;

public class PriorityMessageQueue
implements MessageQueue {
    private final Object LOCK = new Object();
    private final UnsafeMessageQueue[] queues;
    private final DelayedMessageBag delayedBag;
    private final Timer timer;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private boolean postJobTick = false;
    private final MessageFactory factory;
    private static final String LOG_TAG = "priority_mq";

    public PriorityMessageQueue(Timer timer, MessageFactory factory) {
        this.delayedBag = new DelayedMessageBag(factory);
        this.factory = factory;
        this.queues = new UnsafeMessageQueue[Type.MAX_PRIORITY + 1];
        this.timer = timer;
    }

    @Override
    public void consume(MessageQueueConsumer consumer) {
        if (this.running.getAndSet(true)) {
            throw new IllegalStateException("only 1 consumer per MQ");
        }
        while (this.running.get()) {
            Message message = this.next(consumer);
            if (message == null) continue;
            JqLog.d("[%s] consuming message of type %s", new Object[]{LOG_TAG, message.type});
            consumer.handleMessage(message);
            this.factory.release(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = Type.MAX_PRIORITY; i >= 0; --i) {
                UnsafeMessageQueue mq = this.queues[i];
                if (mq == null) continue;
                mq.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.running.set(false);
        Object object = this.LOCK;
        synchronized (object) {
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message next(MessageQueueConsumer consumer) {
        boolean calledOnIdle = false;
        while (this.running.get()) {
            Long nextDelayedReadyAt;
            long now;
            Object object = this.LOCK;
            synchronized (object) {
                now = this.timer.nanoTime();
                JqLog.d("[%s] looking for next message at time %s", LOG_TAG, now);
                nextDelayedReadyAt = this.delayedBag.flushReadyMessages(now, this);
                JqLog.d("[%s] next delayed job %s", LOG_TAG, nextDelayedReadyAt);
                for (int i = Type.MAX_PRIORITY; i >= 0; --i) {
                    Message message;
                    UnsafeMessageQueue mq = this.queues[i];
                    if (mq == null || (message = mq.next()) == null) continue;
                    return message;
                }
                this.postJobTick = false;
            }
            if (!calledOnIdle) {
                consumer.onIdle();
                calledOnIdle = true;
            }
            object = this.LOCK;
            synchronized (object) {
                JqLog.d("[%s] did on idle post a message? %s", LOG_TAG, this.postJobTick);
                if (this.postJobTick) {
                    continue;
                }
                if (nextDelayedReadyAt != null && nextDelayedReadyAt <= now) {
                    continue;
                }
                if (this.running.get()) {
                    try {
                        if (nextDelayedReadyAt == null) {
                            this.timer.waitOnObject(this.LOCK);
                        } else {
                            this.timer.waitOnObjectUntilNs(this.LOCK, nextDelayedReadyAt);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void post(Message message) {
        Object object = this.LOCK;
        synchronized (object) {
            this.postJobTick = true;
            int index = message.type.priority;
            if (this.queues[index] == null) {
                this.queues[index] = new UnsafeMessageQueue(this.factory, "queue_" + message.type.name());
            }
            this.queues[index].post(message);
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void postAt(Message message, long readyNs) {
        Object object = this.LOCK;
        synchronized (object) {
            this.postJobTick = true;
            this.delayedBag.add(message, readyNs);
            this.timer.notifyObject(this.LOCK);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelMessages(MessagePredicate predicate) {
        Object object = this.LOCK;
        synchronized (object) {
            for (int i = 0; i <= Type.MAX_PRIORITY; ++i) {
                UnsafeMessageQueue mq = this.queues[i];
                if (mq == null) continue;
                mq.removeMessages(predicate);
            }
            this.delayedBag.removeMessages(predicate);
        }
    }
}

