/*
 * Decompiled with CFR 0.152.
 */
package com.birbit.android.jobqueue.log;

import android.util.Log;
import com.birbit.android.jobqueue.log.CustomLogger;

public class JqLog {
    private static CustomLogger customLogger;

    public static void clearLogger() {
        JqLog.setCustomLogger(new CustomLogger(){

            @Override
            public boolean isDebugEnabled() {
                return false;
            }

            @Override
            public void d(String text, Object ... args) {
            }

            @Override
            public void e(Throwable t, String text, Object ... args) {
            }

            @Override
            public void e(String text, Object ... args) {
            }

            @Override
            public void v(String text, Object ... args) {
            }
        });
    }

    public static void setCustomLogger(CustomLogger customLogger) {
        JqLog.customLogger = customLogger;
    }

    public static boolean isDebugEnabled() {
        return customLogger.isDebugEnabled();
    }

    public static void d(String text, Object ... args) {
        customLogger.d(text, args);
    }

    public static void e(Throwable t, String text, Object ... args) {
        customLogger.e(t, text, args);
    }

    public static void e(String text, Object ... args) {
        customLogger.e(text, args);
    }

    public static void v(String text, Object ... args) {
        customLogger.v(text, args);
    }

    static {
        JqLog.clearLogger();
    }

    public static class ErrorLogger
    implements CustomLogger {
        private static final String TAG = "JobManager";

        @Override
        public boolean isDebugEnabled() {
            return false;
        }

        @Override
        public void d(String text, Object ... args) {
        }

        @Override
        public void e(Throwable t, String text, Object ... args) {
            Log.e((String)TAG, (String)String.format(text, args), (Throwable)t);
        }

        @Override
        public void e(String text, Object ... args) {
            Log.e((String)TAG, (String)String.format(text, args));
        }

        @Override
        public void v(String text, Object ... args) {
        }
    }
}

